/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.util.HTMLConstants;
import org.eclipse.birt.report.engine.layout.pdf.util.StyleProperties;
import org.w3c.dom.Element;

public abstract class PropertiesProcessor
implements HTMLConstants {
    private static String[] FONT_SIZE = new String[]{"7.5pt", "7.5pt", "7.5pt", "7.5pt", "7.5pt", "7.5pt", "10pt", "7.5pt", "7.5pt", "10pt", "12pt", "13.8pt", "18pt", "23pt", "36pt"};
    public static final HashMap<String, String[]> tagPropertiesMap = new HashMap();
    private static Map<String, PropertiesProcessor> properties2Style = new HashMap<String, PropertiesProcessor>();

    static {
        properties2Style.put("cellpadding", new PropertiesProcessor(){

            public void process(String value, StyleProperties sp) {
                if (value != null && value.length() > 0) {
                    if (value.endsWith("%")) {
                        IStyle style = sp.getStyle();
                        if (!this.hasProperty(style, 7)) {
                            style.setPaddingLeft(value);
                        }
                        if (!this.hasProperty(style, 12)) {
                            style.setPaddingRight(value);
                        }
                        if (!this.hasProperty(style, 10)) {
                            style.setPaddingTop(value);
                        }
                        if (!this.hasProperty(style, 9)) {
                            style.setPaddingBottom(value);
                        }
                    } else {
                        try {
                            int size = Integer.parseInt(value);
                            String padding = String.valueOf(size) + "px";
                            IStyle style = sp.getStyle();
                            if (!this.hasProperty(style, 7)) {
                                style.setPaddingLeft(padding);
                            }
                            if (!this.hasProperty(style, 12)) {
                                style.setPaddingRight(padding);
                            }
                            if (!this.hasProperty(style, 10)) {
                                style.setPaddingTop(padding);
                            }
                            if (!this.hasProperty(style, 9)) {
                                style.setPaddingBottom(padding);
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
        properties2Style.put("background", new PropertiesProcessor(){

            public void process(String value, StyleProperties sp) {
                IStyle style = sp.getStyle();
                if (!this.hasProperty(style, 25)) {
                    style.setBackgroundColor(value);
                }
            }
        });
        properties2Style.put("size", new PropertiesProcessor(){

            public void process(String value, StyleProperties sp) {
                try {
                    int size = Integer.parseInt(value);
                    IStyle style = sp.getStyle();
                    if (!this.hasProperty(style, 44)) {
                        style.setFontSize(FONT_SIZE[size + 7]);
                    }
                }
                catch (Exception exception) {}
            }
        });
        properties2Style.put("text", new PropertiesProcessor(){

            public void process(String value, StyleProperties sp) {
                IStyle style = sp.getStyle();
                if (!this.hasProperty(style, 26)) {
                    style.setColor(value);
                }
            }
        });
        properties2Style.put("color", new PropertiesProcessor(){

            public void process(String value, StyleProperties sp) {
                IStyle style = sp.getStyle();
                if (!this.hasProperty(style, 26)) {
                    style.setColor(value);
                }
            }
        });
        properties2Style.put("bgcolor", new PropertiesProcessor(){

            public void process(String value, StyleProperties sp) {
                IStyle style = sp.getStyle();
                if (!this.hasProperty(style, 25)) {
                    style.setBackgroundColor(value);
                }
            }
        });
        properties2Style.put("border", new PropertiesProcessor(){

            public void process(String value, StyleProperties sp) {
                try {
                    int size = Integer.parseInt(value);
                    String width = String.valueOf(size) + "px";
                    IStyle style = sp.getStyle();
                    if (!this.hasProperty(style, 6)) {
                        style.setBorderTopWidth(width);
                    }
                    if (!this.hasProperty(style, 23)) {
                        style.setBorderBottomWidth(width);
                    }
                    if (!this.hasProperty(style, 31)) {
                        style.setBorderLeftWidth(width);
                    }
                    if (!this.hasProperty(style, 8)) {
                        style.setBorderRightWidth(width);
                    }
                    if (!this.hasProperty(style, 46)) {
                        style.setBorderTopStyle("solid");
                    }
                    if (!this.hasProperty(style, 32)) {
                        style.setBorderBottomStyle("solid");
                    }
                    if (!this.hasProperty(style, 40)) {
                        style.setBorderLeftStyle("solid");
                    }
                    if (!this.hasProperty(style, 19)) {
                        style.setBorderRightStyle("solid");
                    }
                }
                catch (Exception exception) {}
            }
        });
        properties2Style.put("face", new PropertiesProcessor(){

            public void process(String value, StyleProperties sp) {
                IStyle style = sp.getStyle();
                if (!this.hasProperty(style, 55)) {
                    style.setFontFamily(value);
                }
            }
        });
        properties2Style.put("align", new PropertiesProcessor(){

            public void process(String value, StyleProperties sp) {
                IStyle style = sp.getStyle();
                if (!this.hasProperty(style, 24)) {
                    style.setTextAlign(value);
                }
            }
        });
        properties2Style.put("valign", new PropertiesProcessor(){

            public void process(String value, StyleProperties sp) {
                IStyle style = sp.getStyle();
                if (!this.hasProperty(style, 38)) {
                    style.setVerticalAlign(value);
                }
            }
        });
        properties2Style.put("width", new PropertiesProcessor(){

            public void process(String value, StyleProperties sp) {
                DimensionType d;
                if (value != null && value.length() > 0 && (d = DimensionType.parserUnit(value)) != null) {
                    String unit = d.getUnits();
                    if (unit == null || unit.length() == 0) {
                        d = new DimensionType(d.getMeasure(), "px");
                    }
                    sp.addProperty("width", d);
                }
            }
        });
        properties2Style.put("height", new PropertiesProcessor(){

            public void process(String value, StyleProperties sp) {
                DimensionType d;
                if (value != null && value.length() > 0 && (d = DimensionType.parserUnit(value)) != null) {
                    String unit = d.getUnits();
                    if (unit == null || unit.length() == 0) {
                        d = new DimensionType(d.getMeasure(), "px");
                    }
                    sp.addProperty("height", d);
                }
            }
        });
    }

    abstract void process(String var1, StyleProperties var2);

    public static void process(String[] properties, Element ele, StyleProperties sp) {
        int i = 0;
        while (i < properties.length) {
            String value;
            PropertiesProcessor p2s = properties2Style.get(properties[i]);
            if (p2s != null && (value = ele.getAttribute(properties[i])) != null && value.length() > 0) {
                p2s.process(value, sp);
            }
            ++i;
        }
    }

    public static void process(String property, String value, StyleProperties sp) {
        PropertiesProcessor p2s = properties2Style.get(property);
        if (p2s != null && value != null && value.length() > 0) {
            p2s.process(value, sp);
        }
    }

    protected boolean hasProperty(IStyle style, int index) {
        return style.getProperty(index) != null;
    }
}

