/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.visualizador.workbench.views.stocks;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;
import org.projectocolibri.rcp.visualizador.RCPVisualizador;
import org.projectocolibri.rcp.visualizador.model.ArtigosExistencias;

public class ArtigosSTOCKSView
extends ViewPart {
    public static final String ID = "ArtigosSTOCKSView";
    private TableViewer tableViewer;
    private int direction = -1;

    public void createPartControl(Composite parent) {
        try {
            parent.setLayout((Layout)new FillLayout(256));
            GridLayout layout = new GridLayout(2, false);
            parent.setLayout((Layout)layout);
            this.createTableViewer(parent);
            this.createActions();
            this.initializeToolBar();
            this.initializeMenu();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFocus() {
    }

    private void createActions() {
    }

    private void initializeToolBar() {
    }

    private void initializeMenu() {
    }

    private void createTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68354);
        this.createTableColumns(parent, this.tableViewer);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(RCPVisualizador.getDefault().getModelProvider().getArtigosExistencias());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.tableViewer.getControl().setLayoutData((Object)gridData);
    }

    private void createTableColumns(Composite parent, TableViewer viewer) {
        TableViewerColumn column = this.createTableViewerColumn("C\u00f3digo", 100, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ArtigosExistencias p = (ArtigosExistencias)element;
                return p.getCodigo();
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArtigosSTOCKSView.this.direction = -ArtigosSTOCKSView.this.direction;
                ArtigosSTOCKSView.this.tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        ArtigosExistencias p1 = (ArtigosExistencias)e1;
                        ArtigosExistencias p2 = (ArtigosExistencias)e2;
                        int ret = p1.codigo.compareTo(p2.codigo);
                        return ret * ArtigosSTOCKSView.this.direction;
                    }
                });
            }
        });
        column = this.createTableViewerColumn("Descri\u00e7\u00e3o", 300, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ArtigosExistencias p = (ArtigosExistencias)element;
                return p.getDescricao();
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArtigosSTOCKSView.this.direction = -ArtigosSTOCKSView.this.direction;
                ArtigosSTOCKSView.this.tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        ArtigosExistencias p1 = (ArtigosExistencias)e1;
                        ArtigosExistencias p2 = (ArtigosExistencias)e2;
                        int ret = p1.descricao.toLowerCase().compareTo(p2.descricao.toLowerCase());
                        return ret * ArtigosSTOCKSView.this.direction;
                    }
                });
            }
        });
        column = this.createTableViewerColumn("C\u00f3digo Barras", 120, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ArtigosExistencias p = (ArtigosExistencias)element;
                return p.getCodigoBarras();
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArtigosSTOCKSView.this.direction = -ArtigosSTOCKSView.this.direction;
                ArtigosSTOCKSView.this.tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        ArtigosExistencias p1 = (ArtigosExistencias)e1;
                        ArtigosExistencias p2 = (ArtigosExistencias)e2;
                        int ret = p1.codigoBarras.compareTo(p2.codigoBarras);
                        return ret * ArtigosSTOCKSView.this.direction;
                    }
                });
            }
        });
        column = this.createTableViewerColumn("Unidade", 100, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ArtigosExistencias p = (ArtigosExistencias)element;
                return p.getUnidadeMedida();
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArtigosSTOCKSView.this.direction = -ArtigosSTOCKSView.this.direction;
                ArtigosSTOCKSView.this.tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        ArtigosExistencias p1 = (ArtigosExistencias)e1;
                        ArtigosExistencias p2 = (ArtigosExistencias)e2;
                        int ret = p1.unidadeMedida.compareTo(p2.unidadeMedida);
                        return ret * ArtigosSTOCKSView.this.direction;
                    }
                });
            }
        });
        column = this.createTableViewerColumn("Categoria", 50, 0x1000000);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ArtigosExistencias p = (ArtigosExistencias)element;
                return p.getCategoria();
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArtigosSTOCKSView.this.direction = -ArtigosSTOCKSView.this.direction;
                ArtigosSTOCKSView.this.tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        ArtigosExistencias p1 = (ArtigosExistencias)e1;
                        ArtigosExistencias p2 = (ArtigosExistencias)e2;
                        int ret = p1.categoria.compareTo(p2.categoria);
                        return ret * ArtigosSTOCKSView.this.direction;
                    }
                });
            }
        });
        column = this.createTableViewerColumn("Stock", 100, 131072);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ArtigosExistencias p = (ArtigosExistencias)element;
                return p.getStock().toString();
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArtigosSTOCKSView.this.direction = -ArtigosSTOCKSView.this.direction;
                ArtigosSTOCKSView.this.tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        ArtigosExistencias p1 = (ArtigosExistencias)e1;
                        ArtigosExistencias p2 = (ArtigosExistencias)e2;
                        int ret = p1.stock.compareTo(p2.stock);
                        return ret * ArtigosSTOCKSView.this.direction;
                    }
                });
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }
}

