/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.visualizador.workbench.views.saft.stocks;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;
import org.projectocolibri.rcp.visualizador.RCPVisualizador;
import org.projectocolibri.rcp.visualizador.model.MovimentosStocks;

public class MovimentosTransporteView
extends ViewPart {
    public static final String ID = "MovimentosTransporteView";
    private TableViewer tableViewer;
    private int direction = -1;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(256));
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        this.createTableViewer(parent);
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
    }

    public void setFocus() {
    }

    private void createActions() {
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    private void createTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68354);
        this.createTableColumns(parent, this.tableViewer);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(RCPVisualizador.getDefault().getModelProvider().getMovimentosStocks());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.tableViewer.getControl().setLayoutData((Object)gridData);
    }

    private void createTableColumns(Composite parent, TableViewer viewer) {
        TableViewerColumn column = this.createTableViewerColumn("Documento", 120, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MovimentosStocks p = (MovimentosStocks)element;
                return p.getDocumento();
            }
        });
        column = this.createTableViewerColumn("Data", 100, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MovimentosStocks p = (MovimentosStocks)element;
                return p.getData();
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MovimentosTransporteView.this.direction = -MovimentosTransporteView.this.direction;
                MovimentosTransporteView.this.tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        MovimentosStocks p1 = (MovimentosStocks)e1;
                        MovimentosStocks p2 = (MovimentosStocks)e2;
                        int ret = p1.data.compareTo(p2.data);
                        return ret * MovimentosTransporteView.this.direction;
                    }
                });
            }
        });
        column = this.createTableViewerColumn("Cliente", 100, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MovimentosStocks p = (MovimentosStocks)element;
                return p.getCliente();
            }
        });
        column = this.createTableViewerColumn("Nome", 200, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MovimentosStocks p = (MovimentosStocks)element;
                return p.getNome();
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MovimentosTransporteView.this.direction = -MovimentosTransporteView.this.direction;
                MovimentosTransporteView.this.tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        MovimentosStocks p1 = (MovimentosStocks)e1;
                        MovimentosStocks p2 = (MovimentosStocks)e2;
                        int ret = p1.nome.compareTo(p2.nome);
                        return ret * MovimentosTransporteView.this.direction;
                    }
                });
            }
        });
        column = this.createTableViewerColumn("Contribuinte", 100, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MovimentosStocks p = (MovimentosStocks)element;
                return p.getContribuinte();
            }
        });
        column = this.createTableViewerColumn("Artigo", 100, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MovimentosStocks p = (MovimentosStocks)element;
                return p.getArtigo();
            }
        });
        column = this.createTableViewerColumn("Descri\u00e7\u00e3o", 200, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MovimentosStocks p = (MovimentosStocks)element;
                return p.getDescricao();
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MovimentosTransporteView.this.direction = -MovimentosTransporteView.this.direction;
                MovimentosTransporteView.this.tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        MovimentosStocks p1 = (MovimentosStocks)e1;
                        MovimentosStocks p2 = (MovimentosStocks)e2;
                        int ret = p1.descricao.compareTo(p2.descricao);
                        return ret * MovimentosTransporteView.this.direction;
                    }
                });
            }
        });
        column = this.createTableViewerColumn("UM", 100, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MovimentosStocks p = (MovimentosStocks)element;
                return p.getUnidade();
            }
        });
        column = this.createTableViewerColumn("Quantidade", 100, 131072);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MovimentosStocks p = (MovimentosStocks)element;
                return p.getQuantidade();
            }
        });
        column = this.createTableViewerColumn("Pre\u00e7o", 100, 131072);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MovimentosStocks p = (MovimentosStocks)element;
                return p.getPreco();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }
}

