/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.visualizador.workbench.views.saft.stocks;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;
import org.projectocolibri.rcp.visualizador.RCPVisualizador;
import org.projectocolibri.rcp.visualizador.model.DocumentosStocks;
import org.projectocolibri.rcp.visualizador.workbench.actions.saft.OpenTransporteViewAction;

public class DocumentosTransporteView
extends ViewPart {
    public static final String ID = "DocumentosTransporteView";
    private TableViewer tableViewer;
    private int direction = -1;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(256));
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        this.createTableViewer(parent);
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
    }

    public void setFocus() {
    }

    private void createActions() {
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    private void createTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68354);
        this.createTableColumns(parent, this.tableViewer);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(RCPVisualizador.getDefault().getModelProvider().getDocumentosStocks());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                DocumentosStocks documento = (DocumentosStocks)selection.getFirstElement();
                new OpenTransporteViewAction(documento).run();
            }
        });
    }

    private void createTableColumns(Composite parent, TableViewer viewer) {
        TableViewerColumn column = this.createTableViewerColumn("Tipo", 50, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DocumentosStocks p = (DocumentosStocks)element;
                return p.getTipoDocumento();
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocumentosTransporteView.this.direction = -DocumentosTransporteView.this.direction;
                DocumentosTransporteView.this.tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        DocumentosStocks p1 = (DocumentosStocks)e1;
                        DocumentosStocks p2 = (DocumentosStocks)e2;
                        int ret = p1.tipoDocumento.compareTo(p2.tipoDocumento);
                        return ret * DocumentosTransporteView.this.direction;
                    }
                });
            }
        });
        column = this.createTableViewerColumn("Data Documento", 115, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DocumentosStocks p = (DocumentosStocks)element;
                return p.getDataDocumento();
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocumentosTransporteView.this.direction = -DocumentosTransporteView.this.direction;
                DocumentosTransporteView.this.tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        DocumentosStocks p1 = (DocumentosStocks)e1;
                        DocumentosStocks p2 = (DocumentosStocks)e2;
                        int ret = p1.dataDocumento.compareTo(p2.dataDocumento);
                        return ret * DocumentosTransporteView.this.direction;
                    }
                });
            }
        });
        column = this.createTableViewerColumn("Data Sistema", 160, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DocumentosStocks p = (DocumentosStocks)element;
                return p.getDataSistema();
            }
        });
        column = this.createTableViewerColumn("N\u00famero Documento", 120, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DocumentosStocks p = (DocumentosStocks)element;
                return p.getNumeroDocumento();
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocumentosTransporteView.this.direction = -DocumentosTransporteView.this.direction;
                DocumentosTransporteView.this.tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        DocumentosStocks p1 = (DocumentosStocks)e1;
                        DocumentosStocks p2 = (DocumentosStocks)e2;
                        int ret = p1.numeroDocumento.compareTo(p2.numeroDocumento);
                        return ret * DocumentosTransporteView.this.direction;
                    }
                });
            }
        });
        column = this.createTableViewerColumn("N\u00famero Cliente", 120, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DocumentosStocks p = (DocumentosStocks)element;
                return p.getNumeroCliente();
            }
        });
        column = this.createTableViewerColumn("Total IVA", 125, 131072);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DocumentosStocks p = (DocumentosStocks)element;
                return p.getTotalIva();
            }
        });
        column = this.createTableViewerColumn("Total Liquido", 125, 131072);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DocumentosStocks p = (DocumentosStocks)element;
                return p.getTotalLiquido();
            }
        });
        column = this.createTableViewerColumn("Total", 125, 131072);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DocumentosStocks p = (DocumentosStocks)element;
                return p.getTotalDocumento();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }
}

