/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.visualizador.workbench.views.saft.facturas;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.projectocolibri.rcp.visualizador.RCPVisualizador;
import org.projectocolibri.rcp.visualizador.model.DocumentosFacturas;
import x0401.oecdStandardAuditFileTaxPT1.CustomerDocument;
import x0401.oecdStandardAuditFileTaxPT1.SourceDocumentsDocument;

public class FacturaView
extends ViewPart {
    public static final String ID = "FacturaView";
    private Composite container;
    private Text textNumeroDocumento;
    private Text textDataDocumento;
    private Text textDataSistema;
    private Text textTipoDocumento;
    private Text textEntidade;
    private Text textNomeEntidade;
    private Text textMorada;
    private Text textCodigoPostal;
    private Text textContribuinte;
    private Text textTotalIva;
    private Text textTotalIliquido;
    private Text textTotal;
    private Text textHashControl;
    private Text textEstado;
    private TableViewer tableViewer;
    private Table tableLinhas;
    private TableColumn colunaCodigo;

    public void createPartControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(2, false));
        this.createDocumentoGroup();
        this.createEntidadeGroup();
        this.createLinhasTable();
        this.createHashGroup();
        this.createTotaisGroup();
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
    }

    public void setFocus() {
    }

    private void createActions() {
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    private void createDocumentoGroup() {
        Group grupoDocumento = new Group(this.container, 0);
        grupoDocumento.setLayout((Layout)new GridLayout(2, false));
        grupoDocumento.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label labelNumeroDocumento = new Label((Composite)grupoDocumento, 0);
        labelNumeroDocumento.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        labelNumeroDocumento.setText("Documento");
        this.textNumeroDocumento = new Text((Composite)grupoDocumento, 2048);
        this.textNumeroDocumento.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textNumeroDocumento.setEditable(false);
        Label labelDataCriacao = new Label((Composite)grupoDocumento, 0);
        labelDataCriacao.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        labelDataCriacao.setText("Data Cria\u00e7\u00e3o");
        this.textDataDocumento = new Text((Composite)grupoDocumento, 2048);
        this.textDataDocumento.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textDataDocumento.setEditable(false);
        Label labelDataSistema = new Label((Composite)grupoDocumento, 0);
        labelDataSistema.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        labelDataSistema.setText("Data Sistema");
        this.textDataSistema = new Text((Composite)grupoDocumento, 2048);
        this.textDataSistema.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textDataSistema.setEditable(false);
        Label labelTipoDocumento = new Label((Composite)grupoDocumento, 0);
        labelTipoDocumento.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        labelTipoDocumento.setText("Tipo Documento");
        this.textTipoDocumento = new Text((Composite)grupoDocumento, 2048);
        this.textTipoDocumento.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textTipoDocumento.setEditable(false);
        Label labelEstado = new Label((Composite)grupoDocumento, 0);
        labelEstado.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        labelEstado.setText("Estado");
        this.textEstado = new Text((Composite)grupoDocumento, 2048);
        this.textEstado.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textEstado.setEditable(false);
    }

    private void createEntidadeGroup() {
        Group grupoEntidade = new Group(this.container, 0);
        grupoEntidade.setLayout((Layout)new GridLayout(4, false));
        grupoEntidade.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label labelEntidade = new Label((Composite)grupoEntidade, 0);
        labelEntidade.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        labelEntidade.setText("Cliente");
        this.textEntidade = new Text((Composite)grupoEntidade, 2048);
        this.textEntidade.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.textEntidade.setEditable(false);
        Label labelContribuinte = new Label((Composite)grupoEntidade, 0);
        labelContribuinte.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        labelContribuinte.setText("Contribuinte");
        this.textContribuinte = new Text((Composite)grupoEntidade, 2048);
        this.textContribuinte.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textContribuinte.setEditable(false);
        Label labelNome = new Label((Composite)grupoEntidade, 0);
        labelNome.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        labelNome.setText("Nome");
        this.textNomeEntidade = new Text((Composite)grupoEntidade, 2048);
        this.textNomeEntidade.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.textNomeEntidade.setEditable(false);
        Label labelMorada = new Label((Composite)grupoEntidade, 0);
        labelMorada.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        labelMorada.setText("Morada");
        this.textMorada = new Text((Composite)grupoEntidade, 2050);
        this.textMorada.setLayoutData((Object)new GridData(4, 4, false, false, 3, 3));
        this.textMorada.setEditable(false);
        new Label((Composite)grupoEntidade, 0);
        new Label((Composite)grupoEntidade, 0);
        Label labelCodigoPostal = new Label((Composite)grupoEntidade, 0);
        labelCodigoPostal.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        labelCodigoPostal.setText("C\u00f3digo Postal");
        this.textCodigoPostal = new Text((Composite)grupoEntidade, 2048);
        this.textCodigoPostal.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.textCodigoPostal.setEditable(false);
        new Label((Composite)grupoEntidade, 0);
        new Label((Composite)grupoEntidade, 0);
        new Label((Composite)grupoEntidade, 0);
        new Label((Composite)grupoEntidade, 0);
    }

    @Deprecated
    private void createSeparator() {
        Label separador = new Label(this.container, 258);
        separador.setText("Linhas Documento");
        separador.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        new Label(this.container, 0);
        new Label(this.container, 0);
    }

    private void createLinhasTable() {
        this.tableViewer = new TableViewer(this.container, 68354);
        this.createTableColumns(this.container, this.tableViewer);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableLinhas = this.tableViewer.getTable();
        this.tableLinhas.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.tableLinhas.setHeaderVisible(true);
        this.tableLinhas.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setSorter(new ViewerSorter());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
    }

    private void createTableColumns(Composite parent, TableViewer viewer) {
        TableViewerColumn col = this.createTableViewerColumn("C\u00f3digo", 100);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line p = (SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line)element;
                return p.getProductCode();
            }
        });
        col = this.createTableViewerColumn("Descri\u00e7\u00e3o", 550);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line p = (SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line)element;
                return p.getProductDescription();
            }
        });
        col = this.createTableViewerColumn("Unidade", 100);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line p = (SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line)element;
                return p.getUnitOfMeasure();
            }
        });
        col = this.createTableViewerColumn("Quantidade", 100);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line p = (SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line)element;
                return p.getQuantity().toString();
            }
        });
        col = this.createTableViewerColumn("Pre\u00e7o", 100);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line p = (SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line)element;
                return p.getUnitPrice().toString();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void createHashGroup() {
        Group grupoHash = new Group(this.container, 0);
        grupoHash.setLayout((Layout)new GridLayout(1, false));
        grupoHash.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        grupoHash.setText("Hash");
        this.textHashControl = new Text((Composite)grupoHash, 2);
        this.textHashControl.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    private void createTotaisGroup() {
        Group grupoTotais = new Group(this.container, 0);
        grupoTotais.setLayout((Layout)new GridLayout(17, false));
        grupoTotais.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        Label labelTotalIva = new Label((Composite)grupoTotais, 0);
        labelTotalIva.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        labelTotalIva.setText("Total IVA");
        new Label((Composite)grupoTotais, 0);
        this.textTotalIva = new Text((Composite)grupoTotais, 133120);
        this.textTotalIva.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        Label labelTotalIliquido = new Label((Composite)grupoTotais, 0);
        labelTotalIliquido.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        labelTotalIliquido.setText("Total iliquido");
        new Label((Composite)grupoTotais, 0);
        this.textTotalIliquido = new Text((Composite)grupoTotais, 133120);
        this.textTotalIliquido.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        new Label((Composite)grupoTotais, 0);
        Label labelTotal = new Label((Composite)grupoTotais, 0);
        labelTotal.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        labelTotal.setText("Total");
        new Label((Composite)grupoTotais, 0);
        this.textTotal = new Text((Composite)grupoTotais, 133120);
        this.textTotal.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    public void setData(DocumentosFacturas documento) {
        SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice invoice = RCPVisualizador.getDefault().getInvoice(documento.getNumeroDocumento());
        CustomerDocument.Customer cliente = RCPVisualizador.getDefault().getCustomer(invoice.getCustomerID());
        this.textEntidade.setText(cliente.getCustomerID());
        this.textNomeEntidade.setText(cliente.getCompanyName());
        this.textContribuinte.setText(cliente.getCustomerTaxID());
        this.textMorada.setText(cliente.getBillingAddress().getAddressDetail());
        this.textCodigoPostal.setText(cliente.getBillingAddress().getPostalCode());
        this.textNumeroDocumento.setText(invoice.getInvoiceNo());
        this.textDataDocumento.setText(invoice.getInvoiceDate().toString());
        this.textDataSistema.setText(invoice.getSystemEntryDate().toString());
        this.textTipoDocumento.setText(invoice.getInvoiceType().toString());
        this.textEstado.setText(invoice.getDocumentStatus().getInvoiceStatus().toString());
        this.textHashControl.setText(invoice.getHash());
        this.textTotalIva.setText(invoice.getDocumentTotals().getTaxPayable().toString());
        this.textTotalIliquido.setText(invoice.getDocumentTotals().getNetTotal().toString());
        this.textTotal.setText(invoice.getDocumentTotals().getGrossTotal().toString());
        this.tableViewer.setInput((Object)invoice.getLineList());
    }
}

