/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.visualizador.workbench.views.saft;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;
import org.projectocolibri.rcp.visualizador.RCPVisualizador;
import org.projectocolibri.rcp.visualizador.model.TaxasIVA;

public class TaxasIVAView
extends ViewPart {
    public static final String ID = "TaxasIVAView";
    private TableViewer tableViewer;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(256));
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        this.createTableViewer(parent);
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
    }

    public void setFocus() {
    }

    private void createActions() {
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    private void createTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68354);
        this.createColumns(parent, this.tableViewer);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(RCPVisualizador.getDefault().getModelProvider().getTaxasIVA());
        this.tableViewer.setSorter(new ViewerSorter());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.tableViewer.getControl().setLayoutData((Object)gridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        TableViewerColumn col = this.createTableViewerColumn("Taxa", 60);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxasIVA p = (TaxasIVA)element;
                return p.getTaxa();
            }
        });
        col = this.createTableViewerColumn("Descri\u00e7\u00e3o", 200);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxasIVA p = (TaxasIVA)element;
                return p.getDescricao();
            }
        });
        col = this.createTableViewerColumn("C\u00f3digo", 150);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxasIVA p = (TaxasIVA)element;
                return p.getCodigo();
            }
        });
        col = this.createTableViewerColumn("Regi\u00e3o", 100);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxasIVA p = (TaxasIVA)element;
                return p.getRegiao();
            }
        });
        col = this.createTableViewerColumn("Tipo", 100);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TaxasIVA p = (TaxasIVA)element;
                return p.getTipo();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }
}

