/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.visualizador.workbench.actions;

import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;
import org.projectocolibri.rcp.visualizador.RCPVisualizador;
import org.projectocolibri.rcp.visualizador.workbench.views.TreeView;
import stockFilePT101.StockFileDocument;
import stockFilePT102.StockFileDocument;
import x0401.oecdStandardAuditFileTaxPT1.AuditFileDocument;

public class OpenXMLFileAction
extends Action
implements ISelectionListener {
    public static final String ID = "OpenXMLFileAction";
    private final IWorkbenchWindow window;
    private RCPVisualizador visualizador;

    public OpenXMLFileAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public OpenXMLFileAction(IWorkbenchWindow window) {
        this.window = window;
        this.setId(ID);
        this.setToolTipText("Carregar Ficheiro XML");
        this.setHoverImageDescriptor(ResourceManager.getPluginImageDescriptor("org.projectocolibri.rcp.visualizador", "icons/24/open24.png"));
    }

    public void dispose() {
        this.window.getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void run() {
        this.window.getActivePage().resetPerspective();
        this.visualizador = RCPVisualizador.getDefault();
        this.visualizador.resetRules();
        String fileSelected = this.showOpenDialog();
        if (fileSelected != null) {
            this.visualizador.setXmlFile(fileSelected);
            if (this.validaXML(fileSelected)) {
                this.visualizador.setRules();
                IViewPart viewPart = this.window.getActivePage().findView("TreeView");
                TreeView view = (TreeView)viewPart;
                view.updateNodes();
            }
        } else {
            MessageDialog.openInformation((Shell)this.window.getShell(), (String)"Info", (String)"Carregue o seu ficheiro XML");
        }
    }

    private String showOpenDialog() {
        FileDialog fileDialog = new FileDialog(this.window.getShell(), 4096);
        fileDialog.setText("Abrir ficheiro XML");
        fileDialog.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.xml"};
        fileDialog.setFilterExtensions(filterExt);
        return fileDialog.open();
    }

    private boolean validaXML(String filename) {
        StockFileDocument.StockFile stockFile;
        StockFileDocument stockFileDocument;
        File file = new File(filename);
        try {
            AuditFileDocument auditFileDocument = AuditFileDocument.Factory.parse((File)file);
            AuditFileDocument.AuditFile auditFile = auditFileDocument.getAuditFile();
            if (auditFileDocument.validate()) {
                this.visualizador.setDocumentFile(auditFile);
                return true;
            }
        }
        catch (Exception exception) {}
        try {
            stockFileDocument = StockFileDocument.Factory.parse((File)file);
            stockFile = stockFileDocument.getStockFile();
            if (stockFile.validate()) {
                this.visualizador.setDocumentFile(stockFile);
                return true;
            }
        }
        catch (Exception exception) {}
        try {
            stockFileDocument = StockFileDocument.Factory.parse((File)file);
            stockFile = stockFileDocument.getStockFile();
            if (stockFile.validate()) {
                this.visualizador.setDocumentFile((StockFileDocument.StockFile)stockFile);
                return true;
            }
        }
        catch (Exception exception) {}
        MessageDialog.openError((Shell)this.window.getShell(), (String)"Erro", (String)"Este ficheiro XML n\u00e3o \u00e9 v\u00e1lido. Norma suportada V1.04");
        return false;
    }
}

