/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.visualizador.model.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.projectocolibri.rcp.visualizador.model.Artigos;
import org.projectocolibri.rcp.visualizador.model.ArtigosExistencias;
import org.projectocolibri.rcp.visualizador.model.Clientes;
import org.projectocolibri.rcp.visualizador.model.DocumentosFacturas;
import org.projectocolibri.rcp.visualizador.model.DocumentosStocks;
import org.projectocolibri.rcp.visualizador.model.Fornecedores;
import org.projectocolibri.rcp.visualizador.model.MovimentosFacturas;
import org.projectocolibri.rcp.visualizador.model.MovimentosStocks;
import org.projectocolibri.rcp.visualizador.model.TaxasIVA;
import org.projectocolibri.rcp.visualizador.model.provider.IModelProvider;
import stockFilePT101.StockDocument;
import stockFilePT101.StockFileDocument;

public class STOCKS101ModelProvider
implements IModelProvider {
    private final StockFileDocument.StockFile stockFile;

    public STOCKS101ModelProvider(StockFileDocument.StockFile stockFile) {
        this.stockFile = stockFile;
    }

    @Override
    public Collection<TaxasIVA> getTaxasIVA() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Artigos> getArtigos() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ArtigosExistencias> getArtigosExistencias() {
        ArrayList<ArtigosExistencias> col = new ArrayList<ArtigosExistencias>();
        try {
            for (StockDocument.Stock stock : this.stockFile.getStockList()) {
                ArtigosExistencias artigoExistencias = new ArtigosExistencias();
                artigoExistencias.setCodigo(stock.getProductCode());
                artigoExistencias.setCodigoBarras(stock.getProductNumberCode());
                artigoExistencias.setDescricao(stock.getProductDescription());
                artigoExistencias.setUnidadeMedida(stock.getUnitOfMeasure());
                artigoExistencias.setCategoria(stock.getProductCategory().toString());
                artigoExistencias.setStock(stock.getClosingStockQuantity());
                col.add(artigoExistencias);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }

    @Override
    public Collection<Clientes> getClientes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Fornecedores> getFornecedores() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<DocumentosFacturas> getDocumentosFacturas() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<DocumentosStocks> getDocumentosStocks() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<MovimentosFacturas> getMovimentosFacturas() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<MovimentosStocks> getMovimentosStocks() {
        throw new UnsupportedOperationException();
    }
}

