/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.visualizador.model.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.projectocolibri.rcp.visualizador.RCPVisualizador;
import org.projectocolibri.rcp.visualizador.model.Artigos;
import org.projectocolibri.rcp.visualizador.model.ArtigosExistencias;
import org.projectocolibri.rcp.visualizador.model.Clientes;
import org.projectocolibri.rcp.visualizador.model.DocumentosFacturas;
import org.projectocolibri.rcp.visualizador.model.DocumentosStocks;
import org.projectocolibri.rcp.visualizador.model.Fornecedores;
import org.projectocolibri.rcp.visualizador.model.MovimentosFacturas;
import org.projectocolibri.rcp.visualizador.model.MovimentosStocks;
import org.projectocolibri.rcp.visualizador.model.TaxasIVA;
import org.projectocolibri.rcp.visualizador.model.provider.IModelProvider;
import x0401.oecdStandardAuditFileTaxPT1.AuditFileDocument;
import x0401.oecdStandardAuditFileTaxPT1.CustomerDocument;
import x0401.oecdStandardAuditFileTaxPT1.ProductDocument;
import x0401.oecdStandardAuditFileTaxPT1.SourceDocumentsDocument;
import x0401.oecdStandardAuditFileTaxPT1.SupplierDocument;
import x0401.oecdStandardAuditFileTaxPT1.TaxTableEntryDocument;

public class SAFT104ModelProvider
implements IModelProvider {
    private final AuditFileDocument.AuditFile auditFile;

    public SAFT104ModelProvider(AuditFileDocument.AuditFile auditFile) {
        this.auditFile = auditFile;
    }

    private static String getCodigoIva(String code) {
        if (code.equals("1") || code.toUpperCase().equals("INT")) {
            return "INT - Interm\u00e9dia";
        }
        if (code.equals("2") || code.toUpperCase().equals("NOR")) {
            return "NOR - Normal";
        }
        if (code.equals("3") || code.toUpperCase().equals("RED")) {
            return "RED - Reduzida";
        }
        if (code.equals("4") || code.toUpperCase().equals("ISE")) {
            return "ISE - Isenta";
        }
        return "";
    }

    @Override
    public Collection<TaxasIVA> getTaxasIVA() {
        ArrayList<TaxasIVA> col = new ArrayList<TaxasIVA>();
        try {
            for (TaxTableEntryDocument.TaxTableEntry taxTable : this.auditFile.getMasterFiles().getTaxTable().getTaxTableEntryList()) {
                TaxasIVA iva = new TaxasIVA();
                iva.setTaxa(taxTable.getTaxPercentage().toString());
                iva.setDescricao(taxTable.getDescription());
                iva.setCodigo(SAFT104ModelProvider.getCodigoIva(taxTable.getTaxCode()));
                iva.setRegiao(taxTable.getTaxCountryRegion());
                iva.setTipo(taxTable.getTaxType().toString());
                col.add(iva);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }

    @Override
    public Collection<Artigos> getArtigos() {
        ArrayList<Artigos> col = new ArrayList<Artigos>();
        try {
            for (ProductDocument.Product product : this.auditFile.getMasterFiles().getProductList()) {
                Artigos artigo = new Artigos();
                artigo.setCodigo(product.getProductCode());
                artigo.setCodigoBarras(product.getProductNumberCode());
                artigo.setDescricao(product.getProductDescription());
                artigo.setGrupo(product.getProductGroup());
                artigo.setTipo(product.getProductType().toString());
                col.add(artigo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }

    @Override
    public Collection<ArtigosExistencias> getArtigosExistencias() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Clientes> getClientes() {
        ArrayList<Clientes> col = new ArrayList<Clientes>();
        try {
            for (CustomerDocument.Customer customer : this.auditFile.getMasterFiles().getCustomerList()) {
                Clientes cliente = new Clientes();
                cliente.setId(customer.getCustomerID());
                cliente.setNome(customer.getCompanyName());
                cliente.setContribuinte(customer.getCustomerTaxID());
                cliente.setMorada(customer.getBillingAddress().getAddressDetail());
                cliente.setCodigoPostal(customer.getBillingAddress().getPostalCode());
                cliente.setLocalidade(customer.getBillingAddress().getCity());
                cliente.setPais(customer.getBillingAddress().getCountry());
                col.add(cliente);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }

    @Override
    public Collection<Fornecedores> getFornecedores() {
        ArrayList<Fornecedores> col = new ArrayList<Fornecedores>();
        try {
            for (SupplierDocument.Supplier supplier : this.auditFile.getMasterFiles().getSupplierList()) {
                Fornecedores fornecedor = new Fornecedores();
                fornecedor.setId(supplier.getSupplierID());
                fornecedor.setNome(supplier.getCompanyName());
                fornecedor.setContribuinte(supplier.getSupplierID());
                fornecedor.setMorada(supplier.getBillingAddress().getAddressDetail());
                fornecedor.setCodigoPostal(supplier.getBillingAddress().getPostalCode());
                fornecedor.setLocalidade(supplier.getBillingAddress().getCity());
                fornecedor.setPais(supplier.getBillingAddress().getCountry());
                col.add(fornecedor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }

    @Override
    public Collection<DocumentosFacturas> getDocumentosFacturas() {
        ArrayList<DocumentosFacturas> col = new ArrayList<DocumentosFacturas>();
        try {
            if (this.auditFile.getSourceDocuments().getSalesInvoices() != null) {
                for (SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice invoice : this.auditFile.getSourceDocuments().getSalesInvoices().getInvoiceList()) {
                    DocumentosFacturas documento = new DocumentosFacturas();
                    documento.setDataDocumento(invoice.getInvoiceDate().toString());
                    documento.setDataSistema(invoice.getSystemEntryDate().toString());
                    documento.setNumeroDocumento(invoice.getInvoiceNo());
                    documento.setTipoDocumento(invoice.getInvoiceType().toString());
                    documento.setNumeroCliente(invoice.getCustomerID());
                    documento.setTotalIva(invoice.getDocumentTotals().getTaxPayable().toString());
                    documento.setTotalLiquido(invoice.getDocumentTotals().getNetTotal().toString());
                    documento.setTotalDocumento(invoice.getDocumentTotals().getGrossTotal().toString());
                    col.add(documento);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }

    @Override
    public Collection<DocumentosStocks> getDocumentosStocks() {
        ArrayList<DocumentosStocks> col = new ArrayList<DocumentosStocks>();
        try {
            if (this.auditFile.getSourceDocuments().getMovementOfGoods() != null) {
                for (SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement movement : this.auditFile.getSourceDocuments().getMovementOfGoods().getStockMovementList()) {
                    DocumentosStocks documento = new DocumentosStocks();
                    documento.setDataDocumento(movement.getMovementDate().toString());
                    documento.setDataSistema(movement.getSystemEntryDate().toString());
                    documento.setNumeroDocumento(movement.getDocumentNumber());
                    documento.setTipoDocumento(movement.getMovementType().toString());
                    if (movement.getCustomerID() != null) {
                        documento.setNumeroCliente(movement.getCustomerID());
                    }
                    if (movement.getSupplierID() != null) {
                        documento.setNumeroCliente(movement.getSupplierID());
                    }
                    documento.setTotalIva(movement.getDocumentTotals().getTaxPayable().toString());
                    documento.setTotalLiquido(movement.getDocumentTotals().getNetTotal().toString());
                    documento.setTotalDocumento(movement.getDocumentTotals().getGrossTotal().toString());
                    col.add(documento);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }

    @Override
    public Collection<MovimentosFacturas> getMovimentosFacturas() {
        ArrayList<MovimentosFacturas> col = new ArrayList<MovimentosFacturas>();
        try {
            if (this.auditFile.getSourceDocuments().getSalesInvoices() != null) {
                for (SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice invoice : this.auditFile.getSourceDocuments().getSalesInvoices().getInvoiceList()) {
                    for (SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line line : invoice.getLineList()) {
                        MovimentosFacturas movimento = new MovimentosFacturas();
                        movimento.setDocumento(invoice.getInvoiceNo());
                        movimento.setData(invoice.getInvoiceDate().toString());
                        CustomerDocument.Customer cliente = RCPVisualizador.getDefault().getCustomer(invoice.getCustomerID());
                        movimento.setCliente(cliente.getCustomerID());
                        movimento.setNome(cliente.getCompanyName());
                        movimento.setContribuinte(cliente.getCustomerTaxID());
                        movimento.setArtigo(line.getProductCode());
                        movimento.setDescricao(line.getProductDescription());
                        movimento.setUnidade(line.getUnitOfMeasure());
                        movimento.setQuantidade(line.getQuantity().toString());
                        movimento.setPreco(line.getUnitPrice().toString());
                        col.add(movimento);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }

    @Override
    public Collection<MovimentosStocks> getMovimentosStocks() {
        ArrayList<MovimentosStocks> col = new ArrayList<MovimentosStocks>();
        try {
            if (this.auditFile.getSourceDocuments().getMovementOfGoods() != null) {
                for (SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement movement : this.auditFile.getSourceDocuments().getMovementOfGoods().getStockMovementList()) {
                    for (SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement.Line line : movement.getLineList()) {
                        MovimentosStocks movimento = new MovimentosStocks();
                        movimento.setDocumento(movement.getDocumentNumber());
                        movimento.setData(movement.getMovementDate().toString());
                        CustomerDocument.Customer customer = RCPVisualizador.getDefault().getCustomer(movement.getCustomerID());
                        if (customer != null) {
                            movimento.setCliente(customer.getCustomerID());
                            movimento.setNome(customer.getCompanyName());
                            movimento.setContribuinte(customer.getCustomerTaxID());
                        } else {
                            SupplierDocument.Supplier supplier = RCPVisualizador.getDefault().getSupplier(movement.getSupplierID());
                            movimento.setCliente(supplier.getSupplierID());
                            movimento.setNome(supplier.getCompanyName());
                            movimento.setContribuinte(supplier.getSupplierTaxID());
                        }
                        movimento.setArtigo(line.getProductCode());
                        movimento.setDescricao(line.getProductDescription());
                        movimento.setUnidade(line.getUnitOfMeasure());
                        movimento.setQuantidade(line.getQuantity().toString());
                        movimento.setPreco(line.getUnitPrice().toString());
                        col.add(movimento);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }
}

