/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.visualizador.birt;

import java.io.File;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.projectocolibri.rcp.visualizador.RCPVisualizador;
import org.projectocolibri.rcp.visualizador.birt.BIRTEngine;
import stockFilePT101.StockDocument;
import stockFilePT101.StockFileDocument;
import stockFilePT102.StockDocument;
import stockFilePT102.StockFileDocument;

public class RelatorioSTOCKS {
    public String execute() {
        try {
            BIRTEngine engine = new BIRTEngine();
            IRunAndRenderTask task = engine.createNewTask("/reports/STOCKS.rptdesign");
            this.setParameters(task);
            File tempFile = File.createTempFile("STOCKS", ".pdf");
            tempFile.deleteOnExit();
            PDFRenderOption options = new PDFRenderOption();
            options.setOutputFileName(tempFile.getAbsolutePath());
            options.setSupportedImageFormats("PNG;GIF;JPG;BMP;SWF;SVG");
            options.setOption("pdfRenderOption.pageOverflow", (Object)8);
            options.setOption("pdfRenderOption.pageOverflow", (Object)2);
            options.setOption("htmlPagination", (Object)Boolean.FALSE);
            options.setOutputFormat("pdf");
            task.setRenderOption((IRenderOption)options);
            task.run();
            task.close();
            engine.dispose();
            return tempFile.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setParameters(IRunAndRenderTask task) {
        Integer total = 0;
        Integer countM = 0;
        Integer countP = 0;
        Integer countA = 0;
        Integer countS = 0;
        Integer countT = 0;
        if (RCPVisualizador.getDefault().getStockFile01() != null) {
            StockFileDocument.StockFile stockFile = RCPVisualizador.getDefault().getStockFile01();
            task.setParameterValue("VersaoFicheiro", (Object)stockFile.getStockHeader().getFileVersion());
            task.setParameterValue("AnoFiscal", (Object)new Integer(stockFile.getStockHeader().getFiscalYear()).toString());
            task.setParameterValue("DataFinal", (Object)stockFile.getStockHeader().getEndDate().toString());
            task.setParameterValue("Contribuinte", (Object)new Integer(stockFile.getStockHeader().getTaxRegistrationNumber()).toString());
            total = stockFile.getStockList().size();
            for (StockDocument.Stock stock : stockFile.getStockList()) {
                switch (stock.getProductCategory().intValue()) {
                    case 1: {
                        countM = countM + 1;
                        break;
                    }
                    case 2: {
                        countP = countP + 1;
                        break;
                    }
                    case 3: {
                        countA = countA + 1;
                        break;
                    }
                    case 4: {
                        countS = countS + 1;
                        break;
                    }
                    case 5: {
                        countT = countT + 1;
                    }
                }
            }
        } else if (RCPVisualizador.getDefault().getStockFile02() != null) {
            StockFileDocument.StockFile stockFile = RCPVisualizador.getDefault().getStockFile02();
            task.setParameterValue("VersaoFicheiro", (Object)stockFile.getStockHeader().getFileVersion());
            task.setParameterValue("AnoFiscal", (Object)new Integer(stockFile.getStockHeader().getFiscalYear()).toString());
            task.setParameterValue("DataFinal", (Object)stockFile.getStockHeader().getEndDate().toString());
            task.setParameterValue("Contribuinte", (Object)new Integer(stockFile.getStockHeader().getTaxRegistrationNumber()).toString());
            total = stockFile.getStockList().size();
            for (StockDocument.Stock stock : stockFile.getStockList()) {
                switch (stock.getProductCategory().intValue()) {
                    case 1: {
                        countM = countM + 1;
                        break;
                    }
                    case 2: {
                        countP = countP + 1;
                        break;
                    }
                    case 3: {
                        countA = countA + 1;
                        break;
                    }
                    case 4: {
                        countS = countS + 1;
                        break;
                    }
                    case 5: {
                        countT = countT + 1;
                    }
                }
            }
        }
        task.setParameterValue("TotalArtigos", (Object)total.toString());
        task.setParameterValue("ArtigosM", (Object)countM.toString());
        task.setParameterValue("ArtigosP", (Object)countP.toString());
        task.setParameterValue("ArtigosA", (Object)countA.toString());
        task.setParameterValue("ArtigosS", (Object)countS.toString());
        task.setParameterValue("ArtigosT", (Object)countT.toString());
    }
}

