/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.visualizador.birt;

import java.io.File;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.projectocolibri.rcp.visualizador.RCPVisualizador;
import org.projectocolibri.rcp.visualizador.birt.BIRTEngine;
import x0401.oecdStandardAuditFileTaxPT1.AuditFileDocument;
import x0401.oecdStandardAuditFileTaxPT1.HeaderDocument;

public class RelatorioSAFT {
    public String execute() {
        try {
            BIRTEngine engine = new BIRTEngine();
            IRunAndRenderTask task = engine.createNewTask("/reports/SAFT.rptdesign");
            this.setParameters(task);
            File tempFile = File.createTempFile("SAFT", ".pdf");
            tempFile.deleteOnExit();
            PDFRenderOption options = new PDFRenderOption();
            options.setOutputFileName(tempFile.getAbsolutePath());
            options.setSupportedImageFormats("PNG;GIF;JPG;BMP;SWF;SVG");
            options.setOption("pdfRenderOption.pageOverflow", (Object)8);
            options.setOption("pdfRenderOption.pageOverflow", (Object)2);
            options.setOption("htmlPagination", (Object)Boolean.FALSE);
            options.setOutputFormat("pdf");
            task.setRenderOption((IRenderOption)options);
            task.run();
            task.close();
            engine.dispose();
            return tempFile.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setParameters(IRunAndRenderTask task) {
        AuditFileDocument.AuditFile auditFile = RCPVisualizador.getDefault().getAuditFile();
        HeaderDocument.Header saftHeader = auditFile.getHeader();
        task.setParameterValue("empresaContribuinte", (Object)this.clearString(saftHeader.getTaxRegistrationNumber()));
        task.setParameterValue("empresaNome", (Object)this.clearString(saftHeader.getCompanyName()));
        task.setParameterValue("empresaMorada", (Object)this.clearString(saftHeader.getCompanyAddress().getAddressDetail()));
        task.setParameterValue("empresaLocalidade", (Object)this.clearString(saftHeader.getCompanyAddress().getCity()));
        task.setParameterValue("empresaCodigoPostal", (Object)this.clearString(saftHeader.getCompanyAddress().getPostalCode()));
        task.setParameterValue("empresaPais", (Object)"PT");
        task.setParameterValue("empresaTelefone", (Object)this.clearString(saftHeader.getTelephone()));
        task.setParameterValue("empresaEmail", (Object)this.clearString(saftHeader.getEmail()));
        task.setParameterValue("empresaWebsite", (Object)this.clearString(saftHeader.getWebsite()));
        task.setParameterValue("empresaFax", (Object)this.clearString(saftHeader.getFax()));
        task.setParameterValue("saftVersao", (Object)this.clearString(saftHeader.getAuditFileVersion()));
        task.setParameterValue("saftAnoFiscal", (Object)this.clearString(saftHeader.getFiscalYear()));
        task.setParameterValue("saftDataInicio", (Object)this.clearString(saftHeader.getStartDate()));
        task.setParameterValue("saftDataFim", (Object)this.clearString(saftHeader.getEndDate()));
        task.setParameterValue("saftDataCriacao", (Object)this.clearString(saftHeader.getDateCreated()));
        task.setParameterValue("saftMoeda", (Object)saftHeader.getCurrencyCode());
        task.setParameterValue("softwareEmpresa", (Object)this.clearString(saftHeader.getProductCompanyTaxID()));
        task.setParameterValue("softwareNome", (Object)this.clearString(saftHeader.getProductID()));
        task.setParameterValue("softwareVersao", (Object)this.clearString(saftHeader.getProductVersion()));
        task.setParameterValue("softwareNumeroCertificacao", (Object)this.clearString(saftHeader.getSoftwareCertificateNumber()));
        task.setParameterValue("resumoNumeroArtigos", (Object)new Integer(auditFile.getMasterFiles().getProductList().size()).toString());
        task.setParameterValue("resumoNumeroClientes", (Object)new Integer(auditFile.getMasterFiles().getCustomerList().size()).toString());
        if (auditFile.getSourceDocuments().getSalesInvoices() != null) {
            task.setParameterValue("resumoNumeroDocumentos", (Object)auditFile.getSourceDocuments().getSalesInvoices().getNumberOfEntries().toString());
        } else {
            task.setParameterValue("resumoNumeroDocumentos", (Object)"0");
        }
        if (auditFile.getSourceDocuments().getSalesInvoices() != null) {
            task.setParameterValue("resumoTotalCredito", (Object)auditFile.getSourceDocuments().getSalesInvoices().getTotalCredit().toString());
        } else {
            task.setParameterValue("resumoTotalCredito", (Object)"0.00");
        }
        if (auditFile.getSourceDocuments().getSalesInvoices() != null) {
            task.setParameterValue("resumoTotalDebito", (Object)auditFile.getSourceDocuments().getSalesInvoices().getTotalDebit().toString());
        } else {
            task.setParameterValue("resumoTotalDebito", (Object)"0.00");
        }
        task.setParameterValue("resumoNumeroFornecedores", (Object)new Integer(auditFile.getMasterFiles().getSupplierList().size()).toString());
        if (auditFile.getSourceDocuments().getMovementOfGoods() != null) {
            task.setParameterValue("resumoNumeroDocumentosTransporte", (Object)new Integer(auditFile.getSourceDocuments().getMovementOfGoods().getStockMovementList().size()).toString());
        } else {
            task.setParameterValue("resumoNumeroDocumentosTransporte", (Object)"0");
        }
    }

    private String clearString(Object object) {
        return object == null ? "" : object.toString();
    }
}

