/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.visualizador;

import org.projectocolibri.rcp.ApplicationActionBarAdvisor;
import org.projectocolibri.rcp.visualizador.model.provider.IModelProvider;
import org.projectocolibri.rcp.visualizador.model.provider.SAFT104ModelProvider;
import org.projectocolibri.rcp.visualizador.model.provider.STOCKS101ModelProvider;
import org.projectocolibri.rcp.visualizador.model.provider.STOCKS102ModelProvider;
import stockFilePT101.StockFileDocument;
import stockFilePT102.StockFileDocument;
import x0401.oecdStandardAuditFileTaxPT1.AuditFileDocument;
import x0401.oecdStandardAuditFileTaxPT1.CustomerDocument;
import x0401.oecdStandardAuditFileTaxPT1.SourceDocumentsDocument;
import x0401.oecdStandardAuditFileTaxPT1.SupplierDocument;

public class RCPVisualizador {
    private static RCPVisualizador instance;
    private String XmlFile;
    private AuditFileDocument.AuditFile auditFile;
    private StockFileDocument.StockFile stockFile01;
    private StockFileDocument.StockFile stockFile02;
    private IModelProvider modelProvider;
    private ApplicationActionBarAdvisor coolbar;

    public static RCPVisualizador getDefault() {
        if (instance == null) {
            instance = new RCPVisualizador();
        }
        return instance;
    }

    public String getXmlFile() {
        return this.XmlFile;
    }

    public void setXmlFile(String xmlFile) {
        this.XmlFile = xmlFile;
    }

    public void setDocumentFile(AuditFileDocument.AuditFile auditFile) {
        this.auditFile = auditFile;
        this.modelProvider = new SAFT104ModelProvider(auditFile);
    }

    public void setDocumentFile(StockFileDocument.StockFile stockFile) {
        this.stockFile01 = stockFile;
        this.modelProvider = new STOCKS101ModelProvider(this.stockFile01);
    }

    public void setDocumentFile(StockFileDocument.StockFile stockFile) {
        this.stockFile02 = stockFile;
        this.modelProvider = new STOCKS102ModelProvider(this.stockFile02);
    }

    public AuditFileDocument.AuditFile getAuditFile() {
        return this.auditFile;
    }

    public StockFileDocument.StockFile getStockFile01() {
        return this.stockFile01;
    }

    public StockFileDocument.StockFile getStockFile02() {
        return this.stockFile02;
    }

    public IModelProvider getModelProvider() {
        return this.modelProvider;
    }

    public CustomerDocument.Customer getCustomer(String id) {
        for (CustomerDocument.Customer customer : this.auditFile.getMasterFiles().getCustomerList()) {
            if (!customer.getCustomerID().equals(id)) continue;
            return customer;
        }
        return null;
    }

    public SupplierDocument.Supplier getSupplier(String id) {
        for (SupplierDocument.Supplier supplier : this.auditFile.getMasterFiles().getSupplierList()) {
            if (!supplier.getSupplierID().equals(id)) continue;
            return supplier;
        }
        return null;
    }

    public SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice getInvoice(String invoiceNo) {
        for (SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice invoice : this.auditFile.getSourceDocuments().getSalesInvoices().getInvoiceList()) {
            if (!invoice.getInvoiceNo().equals(invoiceNo)) continue;
            return invoice;
        }
        return null;
    }

    public SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement getStock(String documentNumber) {
        for (SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement stock : this.auditFile.getSourceDocuments().getMovementOfGoods().getStockMovementList()) {
            if (!stock.getDocumentNumber().equals(documentNumber)) continue;
            return stock;
        }
        return null;
    }

    public void setApplicationActionBarAdvisor(ApplicationActionBarAdvisor coolbar) {
        this.coolbar = coolbar;
        this.setRules();
    }

    public void setRules() {
        this.coolbar.openInformacaoSAFTViewAction.setEnabled(this.auditFile != null);
        this.coolbar.openArtigosViewAction.setEnabled(this.auditFile != null);
        this.coolbar.openTaxasIVAViewAction.setEnabled(this.auditFile != null);
        this.coolbar.openClientesViewAction.setEnabled(this.auditFile != null);
        this.coolbar.openDocumentosFacturasViewAction.setEnabled(this.auditFile != null);
        this.coolbar.openResumoSAFTViewAction.setEnabled(this.auditFile != null);
        this.coolbar.sendFicheiroSAFTAction.setEnabled(this.auditFile != null);
        this.coolbar.openInformacaoSTOCKSViewAction.setEnabled(this.stockFile01 != null || this.stockFile02 != null);
        this.coolbar.openArtigosExistenciasViewAction.setEnabled(this.stockFile01 != null || this.stockFile02 != null);
        this.coolbar.openResumoExistenciasViewAction.setEnabled(this.stockFile01 != null || this.stockFile02 != null);
    }

    public void resetRules() {
        this.XmlFile = null;
        this.auditFile = null;
        this.modelProvider = null;
        this.stockFile01 = null;
        this.stockFile02 = null;
        this.setRules();
    }
}

