/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.DateTimeFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.StringFormatValue;
import org.eclipse.birt.report.model.api.simpleapi.IHighlightRule;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.simpleapi.Structure;

public class HighlightRuleImpl
extends Structure
implements IHighlightRule {
    private HighlightRule rule;

    public HighlightRuleImpl() {
        super(null);
        this.rule = this.createHighlightRule();
    }

    public HighlightRuleImpl(HighlightRuleHandle ruleHandle) {
        super(ruleHandle);
        if (ruleHandle == null) {
            this.rule = this.createHighlightRule();
        } else {
            this.structureHandle = ruleHandle;
            this.rule = (HighlightRule)ruleHandle.getStructure();
        }
    }

    public HighlightRuleImpl(HighlightRule rule) {
        super(null);
        this.rule = rule == null ? this.createHighlightRule() : rule;
    }

    private HighlightRule createHighlightRule() {
        HighlightRule r = new HighlightRule();
        return r;
    }

    public String getColor() {
        Object obj = this.rule.getProperty(null, "color");
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return StringUtil.toRgbText((Integer)obj).toUpperCase();
        }
        return obj.toString();
    }

    public String getDateTimeFormat() {
        Object value = this.rule.getProperty(null, "dateTimeFormat");
        if (value == null) {
            return null;
        }
        assert (value instanceof DateTimeFormatValue);
        return ((DateTimeFormatValue)value).getPattern();
    }

    public String getFontStyle() {
        return (String)this.rule.getProperty(null, "fontStyle");
    }

    public String getFontWeight() {
        return (String)this.rule.getProperty(null, "fontWeight");
    }

    public String getStringFormat() {
        Object value = this.rule.getProperty(null, "stringFormat");
        if (value == null) {
            return null;
        }
        assert (value instanceof StringFormatValue);
        return ((StringFormatValue)value).getPattern();
    }

    public String getTestExpression() {
        return this.rule.getTestExpression();
    }

    public void setColor(String color) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty("color", color);
            return;
        }
        this.rule.setProperty("color", (Object)color);
    }

    public void setDateTimeFormat(String format) throws SemanticException {
        if (this.structureHandle != null) {
            ActivityStack cmdStack = this.structureHandle.getModule().getActivityStack();
            cmdStack.startNonUndoableTrans(null);
            ((HighlightRuleHandle)this.structureHandle).setDateTimeFormat(format);
            cmdStack.commit();
            return;
        }
        Object value = this.rule.getProperty(null, "dateTimeFormat");
        if (value == null) {
            DateTimeFormatValue formatValueToSet = new DateTimeFormatValue();
            formatValueToSet.setPattern(format);
            this.rule.setProperty("dateTimeFormat", (Object)formatValueToSet);
        } else {
            assert (value instanceof DateTimeFormatValue);
            ((DateTimeFormatValue)value).setPattern(format);
        }
    }

    public void setFontStyle(String style) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty("fontStyle", style);
            return;
        }
        this.rule.setProperty("fontStyle", (Object)style);
    }

    public void setFontWeight(String weight) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty("fontWeight", weight);
            return;
        }
        this.rule.setProperty("fontWeight", (Object)weight);
    }

    public void setStringFormat(String format) throws SemanticException {
        if (this.structureHandle != null) {
            ActivityStack cmdStack = this.structureHandle.getModule().getActivityStack();
            cmdStack.startNonUndoableTrans(null);
            ((HighlightRuleHandle)this.structureHandle).setStringFormat(format);
            cmdStack.commit();
            return;
        }
        Object value = this.rule.getProperty(null, "stringFormat");
        if (value == null) {
            StringFormatValue formatValueToSet = new StringFormatValue();
            formatValueToSet.setPattern(format);
            this.rule.setProperty("stringFormat", (Object)formatValueToSet);
        } else {
            assert (value instanceof StringFormatValue);
            ((StringFormatValue)value).setPattern(format);
        }
    }

    public void setTestExpression(String expression) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty("testExpr", expression);
            return;
        }
        this.rule.setTestExpression(expression);
    }

    public void setValue1(String value1) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty("value1", value1);
            return;
        }
        this.rule.setValue1(value1);
    }

    public void setValue2(String value2) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty("value2", value2);
            return;
        }
        this.rule.setValue2(value2);
    }

    public void setOperator(String operator) throws SemanticException {
        if (this.structureHandle != null) {
            ActivityStack cmdStack = this.structureHandle.getModule().getActivityStack();
            cmdStack.startNonUndoableTrans(null);
            try {
                ((HighlightRuleHandle)this.structureHandle).setOperator(operator);
            }
            catch (SemanticException e) {
                cmdStack.rollback();
                throw e;
            }
            cmdStack.commit();
            return;
        }
        this.rule.setOperator(operator);
    }

    public void setBackGroundColor(String color) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty("backgroundColor", color);
            return;
        }
        this.rule.setProperty("backgroundColor", (Object)color);
    }

    public IStructure getStructure() {
        return this.rule;
    }

    public String getBackGroundColor() {
        Object obj = this.rule.getProperty(null, "backgroundColor");
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return StringUtil.toRgbText((Integer)obj).toUpperCase();
        }
        return obj.toString();
    }

    public String getOperator() {
        return this.rule.getOperator();
    }

    public String getValue1() {
        return this.rule.getValue1();
    }

    public String getValue2() {
        return this.rule.getValue2();
    }
}

