/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.net.URL;
import java.util.Map;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.core.DesignSessionImpl;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.parser.LibraryState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.URIUtilImpl;
import org.eclipse.birt.report.model.util.XMLParserHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryParserHandler
extends ModuleParserHandler {
    LibraryParserHandler(DesignSessionImpl theSession, Module host, URL fileName, ModuleOption options, Map<String, Library> reloadLibs) {
        super(theSession, fileName.toExternalForm(), reloadLibs);
        this.module = new Library(theSession, host);
        URL url = URIUtilImpl.getDirectory(fileName);
        this.module.setSystemId(url);
        this.module.setFileName(fileName.toExternalForm());
        this.module.setOptions(options);
        URL location = ModelUtil.getURLPresentation(fileName.toExternalForm());
        this.module.setLocation(location);
        this.buildModuleOptions(options);
    }

    LibraryParserHandler(DesignSessionImpl theSession, Module host, String fileName, ModuleOption options) {
        super(theSession, fileName);
        this.module = new Library(theSession, host);
        URL url = URIUtilImpl.getDirectory(fileName);
        this.module.setSystemId(url);
        this.module.setFileName(fileName);
        this.module.setOptions(options);
        URL location = ModelUtil.getURLPresentation(fileName);
        this.module.setLocation(location);
        this.buildModuleOptions(options);
    }

    LibraryParserHandler(DesignSessionImpl theSession, String fileName, ModuleOption options) {
        super(theSession, fileName);
        this.module = new Library(theSession, null);
        URL systemId = URIUtilImpl.getDirectory(fileName);
        this.module.setSystemId(systemId);
        this.module.setFileName(fileName);
        this.module.setOptions(options);
        URL location = ModelUtil.getURLPresentation(fileName);
        this.module.setLocation(location);
        this.buildModuleOptions(options);
    }

    LibraryParserHandler(DesignSessionImpl theSession, URL systemId, ModuleOption options) {
        super(theSession, systemId.toExternalForm());
        this.module = new Library(theSession, null);
        this.module.setSystemId(systemId);
        this.module.setOptions(options);
        this.buildModuleOptions(options);
    }

    @Override
    public AbstractParseState createStartState() {
        return new StartState();
    }

    class StartState
    extends XMLParserHandler.InnerParseState {
        StartState() {
            super(LibraryParserHandler.this);
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase("library")) {
                if (LibraryParserHandler.this.markLineNumber) {
                    LibraryParserHandler.this.tempLineNumbers.put(LibraryParserHandler.this.module, LibraryParserHandler.this.locator.getLineNumber());
                }
                return new LibraryState(LibraryParserHandler.this);
            }
            return super.startElement(tagName);
        }
    }
}

