/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.util.HashMap;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.dom.CellMergedStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.HTMLWriter;
import org.eclipse.birt.report.engine.emitter.html.AttributeBuilder;
import org.eclipse.birt.report.engine.emitter.html.HTMLEmitter;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.emitter.html.util.HTMLEmitterUtil;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.w3c.dom.css.CSSValue;

public class HTMLVisionOptimize
extends HTMLEmitter {
    private static HashMap borderStyleMap = null;
    protected boolean htmlRtLFlag = false;

    static {
        borderStyleMap = new HashMap();
        borderStyleMap.put("none", 0);
        borderStyleMap.put("inset", 1);
        borderStyleMap.put("groove", 2);
        borderStyleMap.put("outset", 3);
        borderStyleMap.put("ridge", 4);
        borderStyleMap.put("dotted", 5);
        borderStyleMap.put("dashed", 6);
        borderStyleMap.put("solid", 7);
        borderStyleMap.put("double", 8);
    }

    public HTMLVisionOptimize(HTMLReportEmitter reportEmitter, HTMLWriter writer, boolean fixedReport, boolean enableInlineStyle, boolean htmlRtLFlag, int browserVersion) {
        super(reportEmitter, writer, fixedReport, enableInlineStyle, browserVersion);
        this.htmlRtLFlag = htmlRtLFlag;
    }

    public void buildDefaultStyle(StringBuffer styleBuffer, IStyle style) {
        if (style == null || style.isEmpty()) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        String value = style.getTextAlign();
        if (value != null) {
            styleBuffer.append(" text-align:");
            styleBuffer.append(value);
            styleBuffer.append(";");
        }
    }

    public void buildStyle(StringBuffer styleBuffer, IStyle style) {
        if (style == null || style.isEmpty()) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
    }

    public void buildPageBandStyle(StringBuffer styleBuffer, IStyle style) {
        if (style == null || style.isEmpty()) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        String value = style.getVerticalAlign();
        if (value != null) {
            styleBuffer.append(" vertical-align:");
            styleBuffer.append(value);
            styleBuffer.append(";");
        }
        if ((value = style.getTextAlign()) != null) {
            styleBuffer.append(" text-align:");
            styleBuffer.append(value);
            styleBuffer.append(";");
        }
    }

    public void buildTableStyle(ITableContent table, StringBuffer styleBuffer) {
        this.addDefaultTableStyles(styleBuffer);
        IStyle style = table.getStyle();
        boolean isInline = false;
        CSSValue display = style.getProperty(54);
        if (IStyle.NONE_VALUE == display) {
            styleBuffer.append(" display: none;");
        } else if (IStyle.INLINE_VALUE == display || IStyle.INLINE_BLOCK_VALUE == display) {
            isInline = true;
            if (!this.reportEmitter.browserSupportsInlineBlock) {
                styleBuffer.append(" display:table !important; display:inline;");
            } else {
                styleBuffer.append(" display:inline-block; zoom:1; *+display:inline;");
            }
        }
        DimensionType height = table.getHeight();
        if (height != null) {
            this.buildSize(styleBuffer, "height", height);
        }
        boolean widthOutputFlag = false;
        DimensionType width = table.getWidth();
        if (width != null) {
            this.buildSize(styleBuffer, "width", width);
            widthOutputFlag = true;
        } else if (!"true".equalsIgnoreCase(style.getCanShrink())) {
            boolean absoluteWidth = true;
            int i = 0;
            while (i < table.getColumnCount()) {
                IColumn column = table.getColumn(i);
                DimensionType columnWidth = column.getWidth();
                if (columnWidth == null) {
                    absoluteWidth = false;
                    break;
                }
                if ("%".endsWith(columnWidth.getUnits())) {
                    absoluteWidth = false;
                    break;
                }
                ++i;
            }
            if (!absoluteWidth) {
                styleBuffer.append(" width: 100%;");
                widthOutputFlag = true;
            }
        }
        if (this.fixedReport && !"true".equalsIgnoreCase(style.getCanShrink())) {
            if (!widthOutputFlag) {
                if (isInline) {
                    styleBuffer.append(" width: auto;");
                } else {
                    styleBuffer.append(" width: 1px;");
                }
            }
            styleBuffer.append(" overflow:hidden; table-layout:fixed;");
        }
        if ((style = this.getElementStyle((IContent)table)) == null) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
    }

    public void buildColumnStyle(IColumn column, StringBuffer styleBuffer) {
        this.buildSize(styleBuffer, "width", column.getWidth());
        IStyle style = column.getStyle();
        CSSValue display = style.getProperty(54);
        if (IStyle.NONE_VALUE == display) {
            styleBuffer.append(" display:none;");
        }
    }

    public void handleColumnAlign(IColumn column) {
    }

    public void buildRowStyle(IRowContent row, StringBuffer styleBuffer) {
        this.buildSize(styleBuffer, "height", row.getHeight());
        IStyle style = row.getStyle();
        CSSValue display = style.getProperty(54);
        if (IStyle.NONE_VALUE == display) {
            styleBuffer.append(" display: none;");
        }
        if ((style = this.getElementStyle((IContent)row)) == null) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
    }

    public void handleRowAlign(IRowContent row) {
        IStyle rowComputedStyle = row.getComputedStyle();
        CSSValue vAlign = rowComputedStyle.getProperty(38);
        if (vAlign == null || IStyle.BASELINE_VALUE == vAlign) {
            vAlign = IStyle.TOP_VALUE;
        }
        this.writer.attribute("valign", vAlign.getCssText());
        String hAlignText = null;
        CSSValue hAlign = rowComputedStyle.getProperty(24);
        if (hAlign != null) {
            hAlignText = hAlign.getCssText();
        }
        if (hAlignText == null) {
            hAlignText = this.htmlRtLFlag ? "right" : "left";
        }
        this.writer.attribute("align", hAlignText);
    }

    public void buildCellStyle(ICellContent cell, StringBuffer styleBuffer, boolean isHead) {
        CSSValue display;
        IStyle style = this.getElementStyle((IContent)cell);
        if (this.fixedReport) {
            HTMLEmitterUtil.buildOverflowStyle(styleBuffer, style, true);
        }
        CellMergedStyle cellMergedStyle = new CellMergedStyle(cell);
        if (style != null && IStyle.NONE_VALUE == (display = style.getProperty(54))) {
            styleBuffer.append(" display: none !important; display: block;");
        }
        if (style != null) {
            AttributeBuilder.buildFont(styleBuffer, style);
        }
        AttributeBuilder.buildFont(styleBuffer, (IStyle)cellMergedStyle);
        if (isHead) {
            String fontWeight = null;
            if (style != null) {
                fontWeight = style.getFontWeight();
            }
            String mergedFontWeight = cellMergedStyle.getFontWeight();
            if (fontWeight == null && mergedFontWeight == null) {
                IStyle cellComputedStyle = cell.getComputedStyle();
                if (cellComputedStyle != null) {
                    fontWeight = cellComputedStyle.getFontWeight();
                }
                if (fontWeight == null) {
                    fontWeight = "normal";
                }
                styleBuffer.append("font-weight: ");
                styleBuffer.append(fontWeight);
                styleBuffer.append(";");
            }
        }
        if (style != null) {
            AttributeBuilder.buildMargins(styleBuffer, style);
            AttributeBuilder.buildPaddings(styleBuffer, style);
        }
        AttributeBuilder.buildMargins(styleBuffer, (IStyle)cellMergedStyle);
        AttributeBuilder.buildPaddings(styleBuffer, (IStyle)cellMergedStyle);
        this.buildCellBorder(cell, styleBuffer);
        if (style != null) {
            AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
            AttributeBuilder.buildText(styleBuffer, style);
            AttributeBuilder.buildVisual(styleBuffer, style);
        }
        AttributeBuilder.buildBackground(styleBuffer, (IStyle)cellMergedStyle, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, (IStyle)cellMergedStyle);
        AttributeBuilder.buildVisual(styleBuffer, (IStyle)cellMergedStyle);
    }

    public void handleCellVAlign(ICellContent cell) {
        IStyle style = cell.getStyle();
        CSSValue vAlign = style.getProperty(38);
        if (vAlign == null) {
            CellMergedStyle cellMergedStyle = new CellMergedStyle(cell);
            vAlign = cellMergedStyle.getProperty(38);
        }
        if (IStyle.BASELINE_VALUE == vAlign) {
            vAlign = IStyle.TOP_VALUE;
        }
        if (vAlign != null) {
            this.writer.attribute("valign", vAlign.getCssText());
        }
    }

    public void buildContainerStyle(IContainerContent container, StringBuffer styleBuffer) {
        int display = (Integer)this.containerDisplayStack.peek();
        this.handleShrink(display, container.getStyle(), container.getHeight(), container.getWidth(), styleBuffer);
        if ((display & 8) > 0) {
            styleBuffer.append("display: none;");
        } else if ((display & 2) > 0 || (display & 4) > 0) {
            styleBuffer.append("display:inline-block; zoom:1; *+display:inline;");
        }
        IStyle style = this.getElementStyle((IContent)container);
        if (style == null) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
    }

    public void handleContainerAlign(IContainerContent container) {
        IStyle style = container.getStyle();
        CSSValue hAlign = style.getProperty(24);
        if (hAlign != null) {
            this.writer.attribute("align", hAlign.getCssText());
        }
    }

    public void buildTextStyle(ITextContent text, StringBuffer styleBuffer, int display) {
        String textAlign;
        IStyle style = text.getStyle();
        this.handleTextShrink(display, style, text.getHeight(), text.getWidth(), styleBuffer);
        this.setDisplayProperty(display, 4, styleBuffer);
        IStyle textComputedStyle = text.getComputedStyle();
        if (textComputedStyle != null) {
            AttributeBuilder.buildTextDecoration(styleBuffer, textComputedStyle);
            AttributeBuilder.buildBidiDirection(styleBuffer, textComputedStyle);
        }
        if ((textAlign = style.getTextAlign()) != null) {
            styleBuffer.append(" text-align:");
            styleBuffer.append(textAlign);
            styleBuffer.append(";");
        }
        if ((style = this.getElementStyle((IContent)text)) == null) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
    }

    public void buildForeignStyle(IForeignContent foreign, StringBuffer styleBuffer, int display) {
        String textAlign;
        IStyle style = foreign.getStyle();
        this.handleShrink(display, style, foreign.getHeight(), foreign.getWidth(), styleBuffer);
        this.setDisplayProperty(display, 4, styleBuffer);
        IStyle textComputedStyle = foreign.getComputedStyle();
        if (textComputedStyle != null) {
            AttributeBuilder.buildTextDecoration(styleBuffer, textComputedStyle);
        }
        if ((textAlign = style.getTextAlign()) != null) {
            styleBuffer.append(" text-align:");
            styleBuffer.append(textAlign);
            styleBuffer.append(";");
        }
        if ((style = this.getElementStyle((IContent)foreign)) == null) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        AttributeBuilder.buildBidiDirection(styleBuffer, textComputedStyle);
    }

    public void buildImageStyle(IImageContent image, StringBuffer styleBuffer, int display) {
        IStyle style;
        String verticalAlign;
        this.buildSize(styleBuffer, "width", image.getWidth());
        this.buildSize(styleBuffer, "height", image.getHeight());
        this.setDisplayProperty(display, 1, styleBuffer);
        IStyle imageComputedStyle = image.getComputedStyle();
        if (imageComputedStyle != null) {
            AttributeBuilder.buildTextDecoration(styleBuffer, imageComputedStyle);
        }
        if ((verticalAlign = (style = image.getStyle()).getVerticalAlign()) != null) {
            styleBuffer.append(" vertical-align:");
            styleBuffer.append(verticalAlign);
            styleBuffer.append(";");
        }
        if ((style = this.getElementStyle((IContent)image)) == null) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
    }

    protected void buildCellBorder(ICellContent cell, StringBuffer styleBuffer) {
        int columnCount = -1;
        IStyle cellStyle = null;
        IStyle cellComputedStyle = null;
        IStyle rowStyle = null;
        IStyle rowComputedStyle = null;
        cellStyle = cell.getStyle();
        cellComputedStyle = cell.getComputedStyle();
        IRowContent row = (IRowContent)cell.getParent();
        if (row != null) {
            rowStyle = row.getStyle();
            rowComputedStyle = row.getComputedStyle();
            ITableContent table = row.getTable();
            if (table != null) {
                columnCount = table.getColumnCount();
            }
        }
        if (rowStyle == null || cell.getColumn() < 0 || columnCount < 1) {
            if (cellStyle != null) {
                this.buildCellRowBorder(styleBuffer, "border-top", cellStyle.getBorderTopWidth(), cellStyle.getBorderTopStyle(), cellStyle.getBorderTopColor(), 0, null, null, null, 0);
                this.buildCellRowBorder(styleBuffer, "border-right", cellStyle.getBorderRightWidth(), cellStyle.getBorderRightStyle(), cellStyle.getBorderRightColor(), 0, null, null, null, 0);
                this.buildCellRowBorder(styleBuffer, "border-bottom", cellStyle.getBorderBottomWidth(), cellStyle.getBorderBottomStyle(), cellStyle.getBorderBottomColor(), 0, null, null, null, 0);
                this.buildCellRowBorder(styleBuffer, "border-left", cellStyle.getBorderLeftWidth(), cellStyle.getBorderLeftStyle(), cellStyle.getBorderLeftColor(), 0, null, null, null, 0);
            }
        } else if (cellStyle == null) {
            this.buildCellRowBorder(styleBuffer, "border-top", null, null, null, 0, rowStyle.getBorderTopWidth(), rowStyle.getBorderTopStyle(), rowStyle.getBorderTopColor(), 0);
            this.buildCellRowBorder(styleBuffer, "border-right", null, null, null, 0, rowStyle.getBorderRightWidth(), rowStyle.getBorderRightStyle(), rowStyle.getBorderRightColor(), 0);
            this.buildCellRowBorder(styleBuffer, "border-bottom", null, null, null, 0, rowStyle.getBorderBottomWidth(), rowStyle.getBorderBottomStyle(), rowStyle.getBorderBottomColor(), 0);
            this.buildCellRowBorder(styleBuffer, "border-left", null, null, null, 0, rowStyle.getBorderLeftWidth(), rowStyle.getBorderLeftStyle(), rowStyle.getBorderLeftColor(), 0);
        } else {
            int cellWidthValue = this.getBorderWidthValue(cellComputedStyle, 6);
            int rowWidthValue = this.getBorderWidthValue(rowComputedStyle, 6);
            this.buildCellRowBorder(styleBuffer, "border-top", cellStyle.getBorderTopWidth(), cellStyle.getBorderTopStyle(), cellStyle.getBorderTopColor(), cellWidthValue, rowStyle.getBorderTopWidth(), rowStyle.getBorderTopStyle(), rowStyle.getBorderTopColor(), rowWidthValue);
            if (cell.getColumn() + cell.getColSpan() == columnCount) {
                cellWidthValue = this.getBorderWidthValue(cellComputedStyle, 8);
                rowWidthValue = this.getBorderWidthValue(rowComputedStyle, 8);
                this.buildCellRowBorder(styleBuffer, "border-right", cellStyle.getBorderRightWidth(), cellStyle.getBorderRightStyle(), cellStyle.getBorderRightColor(), cellWidthValue, rowStyle.getBorderRightWidth(), rowStyle.getBorderRightStyle(), rowStyle.getBorderRightColor(), rowWidthValue);
            } else {
                this.buildCellRowBorder(styleBuffer, "border-right", cellStyle.getBorderRightWidth(), cellStyle.getBorderRightStyle(), cellStyle.getBorderRightColor(), 0, null, null, null, 0);
            }
            cellWidthValue = this.getBorderWidthValue(cellComputedStyle, 23);
            rowWidthValue = this.getBorderWidthValue(rowComputedStyle, 23);
            this.buildCellRowBorder(styleBuffer, "border-bottom", cellStyle.getBorderBottomWidth(), cellStyle.getBorderBottomStyle(), cellStyle.getBorderBottomColor(), cellWidthValue, rowStyle.getBorderBottomWidth(), rowStyle.getBorderBottomStyle(), rowStyle.getBorderBottomColor(), rowWidthValue);
            if (cell.getColumn() == 0) {
                cellWidthValue = this.getBorderWidthValue(cellComputedStyle, 31);
                rowWidthValue = this.getBorderWidthValue(rowComputedStyle, 31);
                this.buildCellRowBorder(styleBuffer, "border-left", cellStyle.getBorderLeftWidth(), cellStyle.getBorderLeftStyle(), cellStyle.getBorderLeftColor(), cellWidthValue, rowStyle.getBorderLeftWidth(), rowStyle.getBorderLeftStyle(), rowStyle.getBorderLeftColor(), rowWidthValue);
            } else {
                this.buildCellRowBorder(styleBuffer, "border-left", cellStyle.getBorderLeftWidth(), cellStyle.getBorderLeftStyle(), cellStyle.getBorderLeftColor(), 0, null, null, null, 0);
            }
        }
    }

    private int getBorderWidthValue(IStyle style, int borderNum) {
        if (style == null) {
            return 0;
        }
        if (6 != borderNum && 8 != borderNum && 23 != borderNum && 31 != borderNum) {
            return 0;
        }
        CSSValue value = style.getProperty(borderNum);
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            switch (fv.getPrimitiveType()) {
                case 6: {
                    return (int)((double)(v * 72000.0f) / 2.54);
                }
                case 8: {
                    return (int)(v * 72000.0f);
                }
                case 7: {
                    return (int)((double)(v * 7200.0f) / 2.54);
                }
                case 9: {
                    return (int)(v * 1000.0f);
                }
                case 1: {
                    return (int)v;
                }
            }
        }
        return 0;
    }

    private void buildCellRowBorder(StringBuffer content, String borderName, String cellBorderWidth, String cellBorderStyle, String cellBorderColor, int cellWidthValue, String rowBorderWidth, String rowBorderStyle, String rowBorderColor, int rowWidthValue) {
        boolean bUseCellBorder = true;
        if (rowBorderStyle != null) {
            if (cellBorderStyle == null) {
                bUseCellBorder = false;
            } else if (!cellBorderStyle.matches("hidden")) {
                if (rowBorderStyle.matches("hidden")) {
                    bUseCellBorder = false;
                } else if (!rowBorderStyle.matches("none")) {
                    if (cellBorderStyle.matches("none")) {
                        bUseCellBorder = false;
                    } else if (rowWidthValue >= cellWidthValue) {
                        if (rowWidthValue > cellWidthValue) {
                            bUseCellBorder = false;
                        } else if (!cellBorderStyle.matches(rowBorderStyle)) {
                            Integer iCellBorderLevel = (Integer)borderStyleMap.get(cellBorderStyle);
                            Integer iRowBorderLevel = (Integer)borderStyleMap.get(rowBorderStyle);
                            if (iCellBorderLevel == null) {
                                iCellBorderLevel = -1;
                            }
                            if (iRowBorderLevel == null) {
                                iRowBorderLevel = -1;
                            }
                            if (iRowBorderLevel > iCellBorderLevel) {
                                bUseCellBorder = false;
                            }
                        }
                    }
                }
            }
        }
        if (bUseCellBorder) {
            AttributeBuilder.buildBorder(content, borderName, cellBorderWidth, cellBorderStyle, cellBorderColor);
        } else {
            AttributeBuilder.buildBorder(content, borderName, rowBorderWidth, rowBorderStyle, rowBorderColor);
        }
    }
}

