
package pt.gov.portaldasfinancas.servicos.series;

import java.math.BigInteger;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Action;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2.4-b01
 * Generated source version: 2.2
 *
 */
@WebService(name = "SeriesWS", targetNamespace = "http://at.gov.pt/")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface SeriesWS {


    /**
     *
     *                 Esta funcionalidade tem como objetivo, permitir a comunicação das séries à AT, através do
     *                 registo das mesmas, de modo a que seja atribuído um código único de validação da série.
     *
     *
     * @param numCertSWFatur
     * @param serie
     * @param tipoDoc
     * @param meioProcessamento
     * @param numInicialSeq
     * @param dataInicioPrevUtiliz
     * @param tipoSerie
     * @param classeDoc
     * @return
     *     returns pt.gov.portaldasfinancas.servicos.series.SeriesResp
     */
    @WebMethod
    @WebResult(name = "registarSerieResp", targetNamespace = "")
    @RequestWrapper(localName = "registarSerie", targetNamespace = "http://at.gov.pt/", className = "pt.gov.portaldasfinancas.servicos.series.RegistarSerie")
    @ResponseWrapper(localName = "registarSerieResponse", targetNamespace = "http://at.gov.pt/", className = "pt.gov.portaldasfinancas.servicos.series.RegistarSerieResponse")
    @Action(input = "http://at.gov.pt/SeriesWS/registarSerieRequest", output = "http://at.gov.pt/SeriesWS/registarSerieResponse")
    public SeriesResp registarSerie(
        @WebParam(name = "serie", targetNamespace = "")
        String serie,
        @WebParam(name = "tipoSerie", targetNamespace = "")
        String tipoSerie,
        @WebParam(name = "classeDoc", targetNamespace = "")
        String classeDoc,
        @WebParam(name = "tipoDoc", targetNamespace = "")
        String tipoDoc,
        @WebParam(name = "numInicialSeq", targetNamespace = "")
        BigInteger numInicialSeq,
        @WebParam(name = "dataInicioPrevUtiliz", targetNamespace = "")
        XMLGregorianCalendar dataInicioPrevUtiliz,
        @WebParam(name = "numCertSWFatur", targetNamespace = "")
        BigInteger numCertSWFatur,
        @WebParam(name = "meioProcessamento", targetNamespace = "")
        String meioProcessamento);

    /**
     *
     *                 Esta funcionalidade tem como objetivo, indicar que uma série foi válida para um conjunto
     *                 de documentos, mas que a mesma já não será usada a partir do último documento comunicado.
     *
     *
     * @param serie
     * @param justificacao
     * @param tipoDoc
     * @param codValidacaoSerie
     * @param seqUltimoDocEmitido
     * @param classeDoc
     * @return
     *     returns pt.gov.portaldasfinancas.servicos.series.SeriesResp
     */
    @WebMethod
    @WebResult(name = "finalizarSerieResp", targetNamespace = "")
    @RequestWrapper(localName = "finalizarSerie", targetNamespace = "http://at.gov.pt/", className = "pt.gov.portaldasfinancas.servicos.series.FinalizarSerie")
    @ResponseWrapper(localName = "finalizarSerieResponse", targetNamespace = "http://at.gov.pt/", className = "pt.gov.portaldasfinancas.servicos.series.FinalizarSerieResponse")
    @Action(input = "http://at.gov.pt/SeriesWS/finalizarSerieRequest", output = "http://at.gov.pt/SeriesWS/finalizarSerieResponse")
    public SeriesResp finalizarSerie(
        @WebParam(name = "serie", targetNamespace = "")
        String serie,
        @WebParam(name = "classeDoc", targetNamespace = "")
        String classeDoc,
        @WebParam(name = "tipoDoc", targetNamespace = "")
        String tipoDoc,
        @WebParam(name = "codValidacaoSerie", targetNamespace = "")
        String codValidacaoSerie,
        @WebParam(name = "seqUltimoDocEmitido", targetNamespace = "")
        BigInteger seqUltimoDocEmitido,
        @WebParam(name = "justificacao", targetNamespace = "")
        String justificacao);

    /**
     *
     *                 Esta funcionalidade tem como objetivo, disponibilizar a consulta das séries comunicadas.
     *
     *
     * @param serie
     * @param estado
     * @param tipoDoc
     * @param meioProcessamento
     * @param codValidacaoSerie
     * @param dataRegistoDe
     * @param tipoSerie
     * @param dataRegistoAte
     * @param classeDoc
     * @return
     *     returns pt.gov.portaldasfinancas.servicos.series.ConsultSeriesResp
     */
    @WebMethod
    @WebResult(name = "consultarSeriesResp", targetNamespace = "")
    @RequestWrapper(localName = "consultarSeries", targetNamespace = "http://at.gov.pt/", className = "pt.gov.portaldasfinancas.servicos.series.ConsultarSeries")
    @ResponseWrapper(localName = "consultarSeriesResponse", targetNamespace = "http://at.gov.pt/", className = "pt.gov.portaldasfinancas.servicos.series.ConsultarSeriesResponse")
    @Action(input = "http://at.gov.pt/SeriesWS/consultarSeriesRequest", output = "http://at.gov.pt/SeriesWS/consultarSeriesResponse")
    public ConsultarSeriesResp consultarSeries(
        @WebParam(name = "serie", targetNamespace = "")
        String serie,
        @WebParam(name = "tipoSerie", targetNamespace = "")
        String tipoSerie,
        @WebParam(name = "classeDoc", targetNamespace = "")
        String classeDoc,
        @WebParam(name = "tipoDoc", targetNamespace = "")
        String tipoDoc,
        @WebParam(name = "codValidacaoSerie", targetNamespace = "")
        String codValidacaoSerie,
        @WebParam(name = "dataRegistoDe", targetNamespace = "")
        XMLGregorianCalendar dataRegistoDe,
        @WebParam(name = "dataRegistoAte", targetNamespace = "")
        XMLGregorianCalendar dataRegistoAte,
        @WebParam(name = "estado", targetNamespace = "")
        String estado,
        @WebParam(name = "meioProcessamento", targetNamespace = "")
        String meioProcessamento);

    /**
     *
     *                 Esta funcionalidade tem como objetivo, disponibilizar a ação de anular a comunicação
     *                 de uma série anteriormente comunicada, por erro.
     *
     *
     * @param declaracaoNaoEmissao
     * @param serie
     * @param motivo
     * @param tipoDoc
     * @param codValidacaoSerie
     * @param classeDoc
     * @return
     *     returns pt.gov.portaldasfinancas.servicos.series.SeriesResp
     */
    @WebMethod
    @WebResult(name = "anularSerieResp", targetNamespace = "")
    @RequestWrapper(localName = "anularSerie", targetNamespace = "http://at.gov.pt/", className = "pt.gov.portaldasfinancas.servicos.series.AnularSerie")
    @ResponseWrapper(localName = "anularSerieResponse", targetNamespace = "http://at.gov.pt/", className = "pt.gov.portaldasfinancas.servicos.series.AnularSerieResponse")
    @Action(input = "http://at.gov.pt/SeriesWS/anularSerieRequest", output = "http://at.gov.pt/SeriesWS/anularSerieResponse")
    public SeriesResp anularSerie(
        @WebParam(name = "serie", targetNamespace = "")
        String serie,
        @WebParam(name = "classeDoc", targetNamespace = "")
        String classeDoc,
        @WebParam(name = "tipoDoc", targetNamespace = "")
        String tipoDoc,
        @WebParam(name = "codValidacaoSerie", targetNamespace = "")
        String codValidacaoSerie,
        @WebParam(name = "motivo", targetNamespace = "")
        String motivo,
        @WebParam(name = "declaracaoNaoEmissao", targetNamespace = "")
        boolean declaracaoNaoEmissao);

}
