/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.layout.ColumnsInfo;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;

public class LayoutUtil {
    private static final int DEFAULT_WIDTH = 40000;
    private static final int MIN_WIDTH = 128;
    private static final Logger log = Logger.getLogger(LayoutUtil.class.getName());

    public static ColumnsInfo createTable(int col, int width) {
        return new ColumnsInfo(col, width);
    }

    public static ColumnsInfo createTable(IListContent list, int width, int dpi) {
        width = LayoutUtil.getElementWidth((IContent)list, width, dpi);
        int[] column = new int[]{width};
        return new ColumnsInfo(column);
    }

    public static ColumnsInfo createChart(IForeignContent content, int width, int dpi) {
        ExtendedItemDesign design = (ExtendedItemDesign)content.getGenerateBy();
        DimensionType value = design.getWidth();
        if (value != null) {
            width = LayoutUtil.getElementWidth(value, width, dpi);
        }
        int[] column = new int[]{width};
        return new ColumnsInfo(column);
    }

    public static ColumnsInfo createImage(int width) {
        int[] column = new int[]{width};
        return new ColumnsInfo(column);
    }

    public static ColumnsInfo createImage(int width, int parentWidth, boolean isCenterAligned) {
        if (!isCenterAligned || parentWidth < width) {
            return LayoutUtil.createImage(width);
        }
        int[] column = new int[]{(parentWidth - width) / 2, width, (parentWidth - width) / 2};
        return new ColumnsInfo(column);
    }

    public static int getImageWidth(DimensionType value, int parentWidth, int imageInfoWidth, int dpi) {
        if (value == null) {
            return imageInfoWidth;
        }
        return LayoutUtil.getElementWidth(value, parentWidth, dpi);
    }

    public static int getImageHeight(DimensionType value, int imageInfoHeight, int dpi) {
        return ExcelUtil.convertDimensionType(value, imageInfoHeight, dpi);
    }

    public static int getElementWidth(IContent content, int width, int dpi) {
        DimensionType value = content.getWidth();
        if (value != null) {
            return LayoutUtil.getElementWidth(value, width, dpi);
        }
        return width;
    }

    private static int getElementWidth(DimensionType contentWidth, int width, int dpi) {
        try {
            width = Math.min(ExcelUtil.convertDimensionType(contentWidth, width, dpi), width);
        }
        catch (Exception exception) {}
        return width;
    }

    public static int[] createFixedTable(ITableContent table, int tableWidth, int dpi) {
        int columnCount = table.getColumnCount();
        int[] columns = new int[columnCount];
        int unassignedCount = 0;
        int totalAssigned = 0;
        int i = 0;
        while (i < columnCount) {
            DimensionType value = table.getColumn(i).getWidth();
            if (value == null) {
                columns[i] = -1;
                ++unassignedCount;
            } else {
                columns[i] = ExcelUtil.convertDimensionType(value, tableWidth, dpi);
                totalAssigned += columns[i];
            }
            ++i;
        }
        if (table.getWidth() == null && unassignedCount == 0) {
            return columns;
        }
        columns = EmitterUtil.resizeTableColumn((int)tableWidth, (int[])columns, (int)unassignedCount, (int)totalAssigned);
        i = 0;
        while (i < columns.length) {
            if (columns[i] == 0) {
                columns[i] = 128;
            }
            ++i;
        }
        return columns;
    }

    public static ColumnsInfo createTable(ITableContent table, int width, int dpi, boolean autoExtend) {
        int i;
        int tableWidth = LayoutUtil.getElementWidth((IContent)table, width, dpi);
        int columnCount = table.getColumnCount();
        if (columnCount == 0) {
            return null;
        }
        int[] columns = new int[columnCount];
        int unassignedCount = 0;
        int totalAssigned = 0;
        int i2 = 0;
        while (i2 < columnCount) {
            DimensionType value = table.getColumn(i2).getWidth();
            if (value == null) {
                columns[i2] = -1;
                ++unassignedCount;
            } else {
                columns[i2] = ExcelUtil.convertDimensionType(value, tableWidth, dpi);
                totalAssigned += columns[i2];
            }
            ++i2;
        }
        int leftWidth = tableWidth - totalAssigned;
        if ((leftWidth > 0 || !autoExtend && leftWidth < 0) && unassignedCount == 0 && table.getWidth() != null) {
            int totalResized = 0;
            int i3 = 0;
            while (i3 < columnCount - 1) {
                columns[i3] = LayoutUtil.resize(columns[i3], totalAssigned, leftWidth);
                totalResized += columns[i3];
                ++i3;
            }
            columns[columnCount - 1] = tableWidth - totalResized;
        } else if (leftWidth < 0 && unassignedCount > 0) {
            int totalResized = 0;
            int lastAssignedIndex = 0;
            i = 0;
            while (i < columnCount) {
                if (columns[i] == -1) {
                    columns[i] = 0;
                } else if (!autoExtend) {
                    columns[i] = LayoutUtil.resize(columns[i], totalAssigned, leftWidth);
                    lastAssignedIndex = i;
                    totalResized += columns[i];
                }
                ++i;
            }
            if (!autoExtend) {
                int n = lastAssignedIndex;
                columns[n] = columns[n] + (tableWidth - totalResized);
            }
        } else if (leftWidth >= 0 && unassignedCount > 0) {
            int per = leftWidth / unassignedCount;
            int index = 0;
            i = 0;
            while (i < columns.length) {
                if (columns[i] == -1) {
                    columns[i] = per;
                    index = i;
                }
                ++i;
            }
            columns[index] = leftWidth - per * (unassignedCount - 1);
        }
        int i4 = 0;
        while (i4 < columns.length) {
            if (columns[i4] == 0) {
                columns[i4] = autoExtend ? 40000 : 128;
            }
            ++i4;
        }
        return new ColumnsInfo(columns);
    }

    private static int resize(int width, int total, int left) {
        return Math.round((float)width + (float)width / (float)total * (float)left);
    }
}

