/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.pos.workbench.view.groups.talao;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.dma.eclipse.jface.CustomAction;
import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.swt.dialogs.button.ButtonDialog;
import org.dma.eclipse.swt.dialogs.button.ButtonKeypad;
import org.dma.eclipse.swt.dialogs.button.ButtonMenu;
import org.dma.eclipse.swt.execution.ExecutionManager;
import org.dma.eclipse.swt.graphics.ColorManager;
import org.dma.eclipse.swt.widgets.CustomTable;
import org.dma.java.awt.PrinterHandler;
import org.dma.java.util.ClipboardManager;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.report.BIRTReport;
import org.projectocolibri.api.birt.report.BIRTReportFile;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigosprecos;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Metodospagamento;
import org.projectocolibri.api.database.model.Precarios;
import org.projectocolibri.api.database.model.Unidadesmedida;
import org.projectocolibri.api.language.Label;
import org.projectocolibri.core.support.printer.PrinterList;
import org.projectocolibri.rcp.colibri.RCPcolibri;
import org.projectocolibri.rcp.colibri.workbench.support.views.ColibriViewAction;
import org.projectocolibri.rcp.colibri.workbench.support.views.ViewParameters;
import org.projectocolibri.rcp.colibri.workbench.support.views.jobs.EmitirRelatorioJob;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriButton;
import org.projectocolibri.rcp.colibri.workbench.views.ReportView;
import org.projectocolibri.rcp.colibri.workbench.views.artigos.ficheiro.ArtigosFicheiroView;
import org.projectocolibri.rcp.pos.workbench.view.POSView;
import org.projectocolibri.rcp.pos.workbench.view.groups.talao.TalaoButton;
import org.projectocolibri.rcp.pos.workbench.view.groups.talao.TalaoDisplayText;
import org.projectocolibri.rcp.pos.workbench.view.groups.talao.TalaoLabelProvider;
import org.projectocolibri.rcp.pos.workbench.view.groups.talao.TalaoModelContainer;
import org.projectocolibri.rcp.pos.workbench.view.groups.talao.TalaoTableContainer;

public class TalaoGroup
extends Group {
    private Text text_artigo;
    private TalaoButton button_cima;
    private TalaoButton button_baixo;
    private TalaoButton button_subtrair;
    private TalaoButton button_adicionar;
    private TalaoButton button_quantidade;
    private TalaoButton button_preco;
    private TalaoButton button_remover;
    private TalaoButton button_gravar;
    private TalaoButton button_imprimir;
    private TalaoButton button_pagamento;
    private TalaoButton button_opcoes;
    private final TalaoModelContainer modelContainer = new TalaoModelContainer();
    private TalaoTableContainer tableContainer;
    private TalaoDisplayText displayText;
    private final POSView view;

    protected void checkSubclass() {
    }

    public TalaoGroup(Composite parent, POSView view) {
        super(parent, 0);
        this.view = view;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createCompositeDisplay();
        this.createCompositeTalao();
        this.createCompositeCodigo();
        this.createCompositeTeclado();
        this.registerExecutions();
    }

    public boolean setFocus() {
        return this.text_artigo.setFocus();
    }

    public void dispose() {
        this.unregisterExecutions();
        this.tableContainer.dispose();
        super.dispose();
    }

    public void reset() {
        this.setText();
        this.tableContainer.updateTable();
        this.displayText.total();
        this.validate();
    }

    public void setText() {
        Entidadesdocumentos documento = this.modelContainer.getDocumento();
        super.setText(documento.getEntidade().getNumero() + " - " + documento.getNome());
    }

    private void validate() {
        Entidadesdocumentoslinhas linha = (Entidadesdocumentoslinhas)this.tableContainer.getSelectionElement();
        this.button_cima.setEnabled(!this.tableContainer.isEmpty());
        this.button_baixo.setEnabled(!this.tableContainer.isEmpty());
        this.button_subtrair.setEnabled(linha != null);
        this.button_adicionar.setEnabled(linha != null);
        this.button_quantidade.setEnabled(linha != null);
        this.button_preco.setEnabled(linha != null);
        this.button_remover.setEnabled(linha != null);
        this.button_gravar.setEnabled(!this.tableContainer.isEmpty());
        this.button_imprimir.setEnabled(this.button_gravar.getEnabled());
        this.button_pagamento.setEnabled(this.button_gravar.getEnabled());
        this.button_opcoes.setEnabled(true);
        this.setFocus();
    }

    private Composite createCompositeDisplay() {
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.displayText = new TalaoDisplayText(composite, 20, this.modelContainer);
        return composite;
    }

    private Composite createCompositeCodigo() {
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.text_artigo = new Text(composite, 18432);
        this.text_artigo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.text_artigo.setText(LABELS.talao_artigo.toString());
        this.text_artigo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TalaoGroup.this.text_artigo.selectAll();
            }
        });
        this.text_artigo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TalaoGroup.this.text_artigo.setBackground(null);
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    TalaoGroup.this.text_artigo.setText(String.valueOf(TalaoGroup.this.text_artigo.getText()) + Artigos.BARCODE_SUFFIX[0]);
                    e.doit = false;
                }
            }
        });
        this.text_artigo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String codigo = StringUtils.removeAll((String)TalaoGroup.this.text_artigo.getText(), (char[])Artigos.BARCODE_SUFFIX);
                if (!TalaoGroup.this.text_artigo.getText().equals(codigo)) {
                    if (TalaoGroup.this.modelContainer.getDocumento().isEntidadeValid()) {
                        try {
                            if (!TalaoGroup.this.insert(codigo.toUpperCase())) {
                                TalaoGroup.this.text_artigo.setBackground(ColorManager.COLOR_YELLOW);
                            }
                        }
                        catch (Exception exception) {
                            TalaoGroup.this.text_artigo.setBackground(ColorManager.COLOR_RED);
                        }
                    }
                    TalaoGroup.this.text_artigo.setText(codigo);
                    TalaoGroup.this.text_artigo.selectAll();
                    TalaoGroup.this.text_artigo.setFocus();
                }
            }
        });
        return composite;
    }

    private Composite createCompositeTeclado() {
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(6, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = TalaoButton.SIZE.spacing;
        gridLayout.verticalSpacing = TalaoButton.SIZE.spacing;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.button_cima = new TalaoButton(composite);
        this.button_cima.setSelectionAction((IAction)this.function(FUNCTIONS.CIMA));
        FUNCTIONS.CIMA.decorate(this.button_cima);
        this.button_baixo = new TalaoButton(composite);
        this.button_baixo.setSelectionAction((IAction)this.function(FUNCTIONS.BAIXO));
        FUNCTIONS.BAIXO.decorate(this.button_baixo);
        this.button_subtrair = new TalaoButton(composite);
        this.button_subtrair.setSelectionAction((IAction)this.function(FUNCTIONS.SUBTRAIR));
        FUNCTIONS.SUBTRAIR.decorate(this.button_subtrair);
        this.button_adicionar = new TalaoButton(composite);
        this.button_adicionar.setSelectionAction((IAction)this.function(FUNCTIONS.ADICIONAR));
        FUNCTIONS.ADICIONAR.decorate(this.button_adicionar);
        this.button_quantidade = new TalaoButton(composite);
        this.button_quantidade.setSelectionAction((IAction)this.function(FUNCTIONS.QUANTIDADE));
        FUNCTIONS.QUANTIDADE.decorate(this.button_quantidade);
        this.button_preco = new TalaoButton(composite);
        this.button_preco.setSelectionAction((IAction)this.function(FUNCTIONS.PRECO));
        FUNCTIONS.PRECO.decorate(this.button_preco);
        this.button_remover = new TalaoButton(composite);
        this.button_remover.setSelectionAction((IAction)this.function(FUNCTIONS.REMOVER));
        FUNCTIONS.REMOVER.decorate(this.button_remover);
        this.button_gravar = new TalaoButton(composite);
        this.button_gravar.setSelectionAction((IAction)this.function(FUNCTIONS.GRAVAR));
        FUNCTIONS.GRAVAR.decorate(this.button_gravar);
        this.button_imprimir = new TalaoButton(composite);
        this.button_imprimir.setSelectionAction((IAction)this.function(FUNCTIONS.IMPRIMIR));
        FUNCTIONS.IMPRIMIR.decorate(this.button_imprimir);
        this.button_pagamento = new TalaoButton(composite);
        this.button_pagamento.setSelectionAction((IAction)this.function(FUNCTIONS.PAGAMENTO));
        FUNCTIONS.PAGAMENTO.decorate(this.button_pagamento);
        this.button_opcoes = new TalaoButton(composite, 2);
        this.button_opcoes.setSelectionAction((IAction)this.function(FUNCTIONS.OPCOES));
        FUNCTIONS.OPCOES.decorate(this.button_opcoes);
        return composite;
    }

    private Composite createCompositeTalao() {
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTableContainer(composite);
        return composite;
    }

    private void createTableContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        CustomTable table = new CustomTable(composite, 67588);
        COLUMNS[] cOLUMNSArray = COLUMNS.values();
        int n = cOLUMNSArray.length;
        int n2 = 0;
        while (n2 < n) {
            COLUMNS column = cOLUMNSArray[n2];
            table.createColumn(column.style).setText(column.label);
            ++n2;
        }
        table.addResizeListener(0);
        TableViewer tableViewer = new TableViewer((Table)table);
        tableViewer.setLabelProvider((IBaseLabelProvider)new TalaoLabelProvider());
        this.tableContainer = new TalaoTableContainer(tableViewer, this.modelContainer);
        table.select(0);
    }

    private void registerExecutions() {
        ExecutionManager.register((Control)this.text_artigo, (String)ArtigosFicheiroView.ID, (IAction)new ColibriViewAction(new ViewParameters(ArtigosFicheiroView.ID)), (int)32).addResponse((IAction)new ColibriViewAction(new ViewParameters(POSView.ID))).addResponse((IAction)new CustomAction(){

            public void run() {
                Collection clipboard = ClipboardManager.getClipboard(Artigos.class);
                for (Artigos artigo : clipboard) {
                    TalaoGroup.this.text_artigo.setText(String.valueOf(artigo.getCodigo()) + Artigos.BARCODE_SUFFIX[0]);
                }
            }
        });
    }

    private void unregisterExecutions() {
        ExecutionManager.unregister((Control)this.text_artigo);
    }

    public boolean insert(String codigo) {
        Entidadesdocumentoslinhas linha = this.tableContainer.getNewObject();
        linha.setArtigo(codigo);
        if (!linha.hasArtigo()) {
            return false;
        }
        this.insert(linha.getArtigo(), linha.getUnidademedida());
        return true;
    }

    public void insert(Artigos artigo, Unidadesmedida unidademedida) {
        Precarios precario = ColibriDatabase.getManager().getParametrospos().getEntidade().getPrecario();
        Artigosprecos preco = ColibriDatabase.getManager().loadArtigosprecos(Artigosprecos.generateKey((String)artigo.getCodigo(), (String)precario.getCodigo(), (String)unidademedida.getCodigo(), (String)TABLES.tamanhos.defaultKey(), (String)TABLES.cores.defaultKey()));
        this.insert(artigo, preco == null ? new Artigosprecos(artigo, precario, unidademedida) : preco);
    }

    public void insert(Artigos artigo, Artigosprecos preco) {
        BigDecimal quantidade = preco.getUnidademedida().isGrandeza(Integer.valueOf(0)) ? BigDecimal.ONE : BigDecimal.ZERO;
        Entidadesdocumentoslinhas linha = this.tableContainer.insertObject(artigo, quantidade, preco);
        if (!linha.hasQuantidade()) {
            this.function(FUNCTIONS.QUANTIDADE).run();
        } else if (linha.getPreco().signum() == 0) {
            this.function(FUNCTIONS.PRECO).run();
        }
        this.displayText.total();
        this.validate();
    }

    private Action option(OPTIONS option) {
        switch (option) {
            case RESUMO: {
                return new Action(){

                    public void run() {
                        new EmitirRelatorioJob(new BIRTReport(ColibriDatabase.getManager().getParametrospos().getTemplate()){

                            public FilterMap getFilterMap() {
                                return new FilterMap(TABLES.entidadesmovimentos).addRule(new FilterMapRule(new FIELDS[]{FIELDS.entidadesmovimentos_tipodocumento, FIELDS.documentostipos_codigo}).equal(ColibriDatabase.getManager().getParametrospos().getTipodocumento().getCodigo())).addRule(new FilterMapRule(new FIELDS[]{FIELDS.entidadesmovimentos_datacriacao}).equal(TimeDateUtils.getCurrentDate()));
                            }
                        }, BIRTReport.REPORT_ACTIONS.PREVIEW, BIRTReport.REPORT_FORMATS.PDF){

                            @Override
                            public void task(BIRTReportFile file) {
                            }

                            @Override
                            public void done(BIRTReportFile file) {
                                if (!this.hasError()) {
                                    if (RCPcolibri.PREFERENCES.OPEN_SYSTEM_BROWSER.value.getBoolean()) {
                                        file.open();
                                    } else {
                                        new ColibriViewAction(new ViewParameters(ReportView.ID, file)).run(true);
                                    }
                                }
                            }
                        }.schedule();
                    }
                };
            }
            case GAVETA: {
                return new Action(){

                    public void run() {
                        String printerName = ColibriDatabase.getManager().getParametrospos().getTipodocumento().getImpressora();
                        Debug.out((String)printerName);
                        if (printerName != null) {
                            try {
                                PrinterList.PrinterConfig config = ColibriDatabase.getManager().getParametrospos().getPrinterConfig();
                                Debug.out((String)config.name, (Object)config.drawer);
                                new PrinterHandler(printerName).print(config.drawer);
                            }
                            catch (Exception exception) {
                                TalaoGroup.this.displayText.text(printerName);
                            }
                        }
                    }
                };
            }
            case TROCO: {
                return new Action(){

                    public void run() {
                        final Entidadesdocumentos documento = TalaoGroup.this.modelContainer.getDocumento();
                        ButtonKeypad keypad = new ButtonKeypad(){

                            public boolean done(String result) {
                                if (!result.isEmpty()) {
                                    BigDecimal value = new BigDecimal(result);
                                    BigDecimal troco = value.subtract(documento.getTotal());
                                    TalaoGroup.this.displayText.total(LABELS.opcoes_troco.toString(), troco);
                                    if (ColibriDatabase.getManager().getParametrospos().getAberturagaveta() == 2) {
                                        TalaoGroup.this.option(OPTIONS.GAVETA).run();
                                    }
                                }
                                return true;
                            }
                        };
                        keypad.setText(LABELS.talao_totalentregue.toString());
                        keypad.setValue(documento.getTotal());
                        keypad.openAndSleep();
                        TalaoGroup.this.validate();
                    }
                };
            }
            case NIF: {
                return new Action(){

                    public void run() {
                        final Entidadesdocumentos documento = TalaoGroup.this.modelContainer.getDocumento();
                        ButtonKeypad keypad = new ButtonKeypad(){

                            public boolean done(String result) {
                                Entidades entidade = ColibriDatabase.getManager().loadEntidades(ColibriDatabase.getManager().getParametrospos().getEntidade().getTipoentidade().getCodigo(), ColibriDatabase.getManager().getParametrospos().getEntidade().getPais().getCodigo(), result, new int[]{1});
                                if (entidade != null) {
                                    documento.setEntidade(entidade);
                                    documento.setNif(entidade.getNif());
                                } else if (ColibriDatabase.getManager().getParametrospos().getEntidade().isNifGenerico()) {
                                    documento.setEntidade(ColibriDatabase.getManager().getParametrospos().getEntidade());
                                    documento.setNif(result);
                                }
                                return documento.isNifValid();
                            }
                        };
                        keypad.setText(LABELS.opcoes_nif.toString());
                        keypad.setValue(documento.getNifParsed());
                        keypad.openAndSleep();
                        TalaoGroup.this.setText();
                        TalaoGroup.this.validate();
                    }
                };
            }
            case SAIR: {
                return new Action(){};
            }
        }
        return null;
    }

    private Action function(FUNCTIONS function) {
        switch (function) {
            case CIMA: {
                return new Action(){

                    public void run() {
                        TalaoGroup.this.tableContainer.moveSelectionUp(false);
                        TalaoGroup.this.validate();
                    }
                };
            }
            case BAIXO: {
                return new Action(){

                    public void run() {
                        TalaoGroup.this.tableContainer.moveSelectionDown(false);
                        TalaoGroup.this.validate();
                    }
                };
            }
            case SUBTRAIR: {
                return new Action(){

                    public void run() {
                        BigDecimal augend;
                        Entidadesdocumentoslinhas linha = (Entidadesdocumentoslinhas)TalaoGroup.this.tableContainer.getSelectionElement();
                        BigDecimal bigDecimal = augend = linha.getUnidademedida().isGrandeza(Integer.valueOf(0)) ? BigDecimal.ONE.negate() : BigDecimal.valueOf(0.25).negate();
                        if (linha.getQuantidade().add(augend).signum() <= 0) {
                            return;
                        }
                        linha.addQuantidade(augend);
                        TalaoGroup.this.tableContainer.updateElement(linha);
                        TalaoGroup.this.displayText.total();
                        TalaoGroup.this.validate();
                    }
                };
            }
            case ADICIONAR: {
                return new Action(){

                    public void run() {
                        BigDecimal augend;
                        Entidadesdocumentoslinhas linha = (Entidadesdocumentoslinhas)TalaoGroup.this.tableContainer.getSelectionElement();
                        BigDecimal bigDecimal = augend = linha.getUnidademedida().isGrandeza(Integer.valueOf(0)) ? BigDecimal.ONE : BigDecimal.valueOf(0.25);
                        if (linha.getQuantidade().add(augend).signum() <= 0) {
                            return;
                        }
                        linha.addQuantidade(augend);
                        TalaoGroup.this.tableContainer.updateElement(linha);
                        TalaoGroup.this.displayText.total();
                        TalaoGroup.this.validate();
                    }
                };
            }
            case QUANTIDADE: {
                return new Action(){

                    public void run() {
                        final Entidadesdocumentoslinhas linha = (Entidadesdocumentoslinhas)TalaoGroup.this.tableContainer.getSelectionElement();
                        TalaoGroup.this.displayText.text(linha.getArtigo().getDescricaoToText());
                        ButtonKeypad keypad = new ButtonKeypad(){

                            public boolean done(String result) {
                                if (!result.isEmpty()) {
                                    BigDecimal value = new BigDecimal(result);
                                    linha.setQuantidade(value);
                                }
                                return true;
                            }
                        };
                        keypad.setText(LABELS.talao_quantidade.toString());
                        keypad.setValue(linha.getQuantidade());
                        keypad.openAndSleep();
                        TalaoGroup.this.tableContainer.updateElement(linha);
                        TalaoGroup.this.displayText.total();
                        TalaoGroup.this.validate();
                    }
                };
            }
            case PRECO: {
                return new Action(){

                    public void run() {
                        final Entidadesdocumentoslinhas linha = (Entidadesdocumentoslinhas)TalaoGroup.this.tableContainer.getSelectionElement();
                        TalaoGroup.this.displayText.text(linha.getArtigo().getDescricaoToText());
                        ButtonKeypad keypad = new ButtonKeypad(){

                            public boolean done(String result) {
                                if (!result.isEmpty()) {
                                    BigDecimal precoiva = new BigDecimal(result);
                                    linha.setPrecoiva(precoiva);
                                }
                                return true;
                            }
                        };
                        keypad.setText(LABELS.talao_precoiva.toString());
                        keypad.setValue(linha.getPrecoiva());
                        keypad.openAndSleep();
                        TalaoGroup.this.tableContainer.updateElement(linha);
                        TalaoGroup.this.displayText.total();
                        TalaoGroup.this.validate();
                    }
                };
            }
            case REMOVER: {
                return new Action(){

                    public void run() {
                        final Entidadesdocumentoslinhas linha = (Entidadesdocumentoslinhas)TalaoGroup.this.tableContainer.getSelectionElement();
                        TalaoGroup.this.displayText.text(linha.getArtigo().getDescricao());
                        ButtonDialog dialog = new ButtonDialog(){

                            public void ok() {
                                linha.setQuantidade(BigDecimal.ZERO);
                            }
                        };
                        dialog.setText(LABELS.teclado_remover.toString());
                        dialog.openAndSleep();
                        TalaoGroup.this.tableContainer.updateElement(linha);
                        TalaoGroup.this.displayText.total();
                        TalaoGroup.this.validate();
                    }
                };
            }
            case GRAVAR: {
                return new Action(){

                    public void run() {
                        ButtonDialog dialog = new ButtonDialog(){

                            public void ok() {
                                TalaoGroup.this.displayText.text(LABELS.AGUARDE.toString());
                                if (!ErrorDialog.open((MessageList)TalaoGroup.this.modelContainer.insertObject(new MethodCallback[0]))) {
                                    TalaoGroup.this.modelContainer.createNewObject();
                                }
                            }
                        };
                        dialog.setText(LABELS.teclado_gravar.toString());
                        dialog.openAndSleep();
                        TalaoGroup.this.reset();
                    }
                };
            }
            case IMPRIMIR: {
                return new Action(){

                    public void run() {
                        Entidadesdocumentos documento = TalaoGroup.this.modelContainer.getDocumento();
                        if (ColibriDatabase.getManager().getParametrospos().getAberturagaveta() == 1 && documento.getMetodopagamento().isTipo(Integer.valueOf(0))) {
                            TalaoGroup.this.option(OPTIONS.GAVETA).run();
                        }
                        if (!ErrorDialog.open((MessageList)TalaoGroup.this.modelContainer.insertObject(new MethodCallback[0]))) {
                            TalaoGroup.this.displayText.text(LABELS.AGUARDE.toString());
                            new EmitirRelatorioJob(documento.createReport(), BIRTReport.REPORT_ACTIONS.PRINT){
                                String printerName;
                                {
                                    this.printerName = ColibriDatabase.getManager().getParametrospos().getTipodocumento().getImpressora();
                                }

                                @Override
                                public void task(BIRTReportFile file) {
                                }

                                @Override
                                public void done(BIRTReportFile file) {
                                    if (!this.hasError()) {
                                        this.addError(file.print(this.printerName));
                                    }
                                }
                            }.schedule();
                            TalaoGroup.this.modelContainer.createNewObject();
                        }
                        TalaoGroup.this.reset();
                    }
                };
            }
            case PAGAMENTO: {
                return new Action(){

                    public void run() {
                        if (ColibriDatabase.getManager().getParametrospos().getTipotroco() == 1) {
                            TalaoGroup.this.option(OPTIONS.TROCO).run();
                        }
                        final ArrayList list = new ArrayList(ColibriDatabase.getManager().getMetodospagamentoCollection());
                        int index = 0;
                        String[] labels = new String[list.size()];
                        for (Metodospagamento metodo : list) {
                            labels[index++] = metodo.getDescricao();
                        }
                        ButtonMenu menu = new ButtonMenu(TalaoButton.SIZE.height, labels){

                            public void done(int index) {
                                Entidadesdocumentos documento = TalaoGroup.this.modelContainer.getDocumento();
                                Metodospagamento metodo = (Metodospagamento)list.get(index);
                                documento.setMetodopagamento(metodo);
                                TalaoGroup.this.displayText.total(metodo.getDescricao(), documento.getTotal());
                                TalaoGroup.this.function(FUNCTIONS.IMPRIMIR).run();
                            }
                        };
                        menu.setText(LABELS.teclado_pagamento.toString());
                        menu.openAndSleep();
                    }
                };
            }
            case OPCOES: {
                return new Action(){

                    public void run() {
                        ButtonMenu menu = new ButtonMenu(TalaoButton.SIZE.height, OPTIONS.ITEMS){

                            public void done(int index) {
                                TalaoGroup.this.option(OPTIONS.get(index)).run();
                            }
                        };
                        menu.setText(LABELS.teclado_opcoes.toString());
                        menu.openAndSleep();
                        TalaoGroup.this.validate();
                    }
                };
            }
        }
        return null;
    }

    public static enum COLUMNS {
        QUANTIDADE("#", 15, 0),
        UNIDADE(LABELS.talao_unidademedida.toString(), 10, 0),
        DESCRICAO(LABELS.talao_descricao.toString(), 50, 0),
        TOTAL(LABELS.talao_total.toString(), 25, 0);

        public final String label;
        public final int width;
        public final int style;

        private COLUMNS(String label, int width, int style) {
            this.label = label;
            this.width = width;
            this.style = style;
        }
    }

    private static enum FUNCTIONS {
        CIMA("", Colibri.ICONS.TOOLBAR_SETA_CIMA),
        BAIXO("", Colibri.ICONS.TOOLBAR_SETA_BAIXO),
        SUBTRAIR("", Colibri.ICONS.TOOLBAR_SETA_ESQUERDA),
        ADICIONAR("", Colibri.ICONS.TOOLBAR_SETA_DIREITA),
        QUANTIDADE("123"),
        PRECO(ColibriDatabase.getManager().getParametros().getMoeda().getCodigo()),
        REMOVER(LABELS.teclado_remover, Colibri.ICONS.GOOGLE_CLOSE),
        GRAVAR(LABELS.teclado_gravar, Colibri.ICONS.GOOGLE_SAVE),
        IMPRIMIR(LABELS.teclado_imprimir, Colibri.ICONS.GOOGLE_PRINT),
        PAGAMENTO(LABELS.teclado_pagamento, Colibri.ICONS.GOOGLE_LOCAL_ATM),
        OPCOES(LABELS.teclado_opcoes, Colibri.ICONS.GOOGLE_SETTINGS);

        private String label;
        private Colibri.ICONS icon;

        private FUNCTIONS(String label) {
            this(label, null);
        }

        private FUNCTIONS(LABELS label, Colibri.ICONS icon) {
            this(label.toString(), icon);
        }

        private FUNCTIONS(String label, Colibri.ICONS icon) {
            this.label = label;
            this.icon = icon;
        }

        public void decorate(ColibriButton button) {
            if (this.icon == null) {
                button.setText(this.label);
            } else {
                button.setImage(this.icon);
                button.setToolTipText(this.label);
            }
        }
    }

    static enum LABELS {
        AGUARDE(new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Aguarde...", "Wait...")),
        talao_artigo(org.projectocolibri.api.language.LABELS.entidadesdocumentoslinhas_artigo.label(0)),
        talao_quantidade(org.projectocolibri.api.language.LABELS.entidadesdocumentoslinhas_quantidade.label(0)),
        talao_unidademedida(org.projectocolibri.api.language.LABELS.entidadesdocumentoslinhas_unidademedida.label(0)),
        talao_descricao(org.projectocolibri.api.language.LABELS.entidadesdocumentoslinhas_descricao.label(0)),
        talao_precoiva(org.projectocolibri.api.language.LABELS.entidadesdocumentoslinhas_precoiva.label(0)),
        talao_total(org.projectocolibri.api.language.LABELS.entidadesdocumentos_total.label(0)),
        talao_totalentregue(org.projectocolibri.api.language.LABELS.entidadesdocumentos_totalentregue.label(0)),
        talao_numerodocumento(org.projectocolibri.api.language.LABELS.entidadesdocumentos_numerodocumento.label(0)),
        teclado_remover(new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Remover", "Remove")),
        teclado_gravar(new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Gravar", "Save")),
        teclado_imprimir(new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Imprimir", "Print")),
        teclado_pagamento(new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Pagamento", "Payment")),
        teclado_opcoes(new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Op\u00e7\u00f5es", "Options")),
        opcoes_resumo(new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Resumo", "Summary")),
        opcoes_gaveta(new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Gaveta", "Drawer")),
        opcoes_troco(new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Troco", "Change")),
        opcoes_nif(new Label(Colibri.LANGUAGE_BUNDLE.bundle, "NIF", "TIN")),
        opcoes_sair(new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Sair", "Exit"));

        public final Label label;

        private LABELS(Label label) {
            this.label = label;
        }

        public String toString() {
            return this.label.toString();
        }
    }

    private static enum OPTIONS {
        RESUMO(LABELS.opcoes_resumo),
        GAVETA(LABELS.opcoes_gaveta),
        TROCO(LABELS.opcoes_troco),
        NIF(LABELS.opcoes_nif),
        SAIR(LABELS.opcoes_sair);

        public static final String[] ITEMS;
        private String label;

        static {
            ITEMS = new String[OPTIONS.values().length];
            OPTIONS[] oPTIONSArray = OPTIONS.values();
            int n = oPTIONSArray.length;
            int n2 = 0;
            while (n2 < n) {
                OPTIONS e = oPTIONSArray[n2];
                OPTIONS.ITEMS[e.ordinal()] = e.label;
                ++n2;
            }
        }

        public static OPTIONS get(int index) {
            return OPTIONS.values()[index];
        }

        private OPTIONS(LABELS label) {
            this.label = label.toString();
        }
    }
}

