/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.pos.workbench.view.groups.artigos;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import java.util.Map;
import org.dma.eclipse.swt.graphics.ImageManager;
import org.dma.java.awt.ImageHandler;
import org.dma.java.awt.ImageOverlay;
import org.dma.java.util.Debug;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.imgscalr.Scalr;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigosprecos;
import org.projectocolibri.rcp.pos.workbench.view.groups.artigos.ArtigoButton;
import org.projectocolibri.rcp.pos.workbench.view.groups.artigos.ArtigosGroup;

public class ArtigoImageButton
extends ArtigoButton {
    private static final Font TEXT_FONT = new Font("SansSerif", 0, 16);
    private final Artigos artigo;
    private final Artigosprecos preco;
    private final String[] texto = new String[2];

    public Artigos getArtigo() {
        return this.artigo;
    }

    public Artigosprecos getPreco() {
        return this.preco;
    }

    public ArtigoImageButton(ArtigosGroup parent, Artigos artigo) {
        this(parent, artigo, artigo.getPrecos(0));
        this.texto[0] = artigo.getDescricao2ToText().isEmpty() ? artigo.getDescricaoToText() : artigo.getDescricao2ToText();
        this.texto[1] = String.valueOf(this.preco.getUnidademedida().getCodigo()) + " " + (this.preco.getPrecoiva().signum() == 0 ? "" : String.valueOf(ColibriDatabase.getManager().getParametros().getMoeda().getSymbol()) + this.preco.getPrecoivaToText());
        this.setToolTipText(artigo.getCodigo());
    }

    private ArtigoImageButton(ArtigosGroup parent, Artigos artigo, Artigosprecos preco) {
        super(parent);
        this.artigo = artigo;
        this.preco = preco;
    }

    @Override
    public void setImage() {
        Image image = this.createImage();
        this.setImage(image);
        if (image == null) {
            this.setText(String.valueOf(this.texto[0]) + "\n" + this.texto[1]);
        }
        this.getParent().layout(true);
    }

    private Image createImage() {
        if (this.artigo.hasImagem()) {
            try {
                ImageData data = ImageData.get(this.artigo);
                Image image = data.getImage(this.getSize());
                if (image == null) {
                    int width = this.getSize().x - ArtigoImageButton.SIZE.margin;
                    int height = this.getSize().y - ArtigoImageButton.SIZE.margin;
                    BufferedImage source = width > height ? new ImageHandler(this.artigo.getImagem()).resize(Scalr.Mode.FIT_TO_HEIGHT, height, new BufferedImageOp[0]) : new ImageHandler(this.artigo.getImagem()).resize(Scalr.Mode.FIT_TO_WIDTH, width, new BufferedImageOp[0]);
                    BufferedImage paper = new BufferedImage(Math.max(width, source.getWidth()), Math.max(height, source.getHeight()), 2);
                    Graphics graphics = paper.getGraphics();
                    graphics.drawImage(source, (paper.getWidth() - source.getWidth()) / 2, (paper.getHeight() - source.getHeight()) / 2, null);
                    graphics.dispose();
                    source.flush();
                    ImageOverlay overlay = new ImageOverlay(paper, TEXT_FONT);
                    overlay.writeText(this.texto[0], 2, 0, 1);
                    overlay.writeText(this.texto[1], 2, 1, 1);
                    overlay.dispose();
                    image = data.createImage(paper);
                    Debug.err((String)"data", (Object)data);
                }
                return image;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static class ImageData {
        private static final Map<String, ImageData> DATA_CACHE = new HashMap<String, ImageData>();
        private String key;
        private Point size;

        private ImageData() {
        }

        public static ImageData get(Artigos artigo) {
            ImageData data = DATA_CACHE.get(artigo.getCodigo());
            if (data == null) {
                data = new ImageData();
                DATA_CACHE.put(artigo.getCodigo(), data);
            }
            return data;
        }

        public Image createImage(BufferedImage bufferedImage) {
            Image image = ImageManager.getImage((BufferedImage)bufferedImage);
            this.key = ImageManager.getKey((RenderedImage)bufferedImage);
            return image;
        }

        public Image getImage(Point size) {
            Image image = ImageManager.REGISTRY.get(this.key);
            if (size.equals((Object)this.size)) {
                return image;
            }
            this.size = size;
            if (image != null) {
                ImageManager.REGISTRY.remove(this.key);
            }
            return null;
        }

        public String toString() {
            return "key=" + this.key + "; " + this.size;
        }
    }
}

