/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.views.tree.model;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.dma.eclipse.swt.graphics.ColorManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Color;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.mapper.tree.TreeGroupModel;
import org.projectocolibri.rcp.colibri.workbench.views.tree.model.ITreeNode;

public class TreeNode
extends ArrayList<ITreeNode>
implements ITreeNode {
    private static final long serialVersionUID = 1L;
    private final TreeGroupModel group;
    private IAction action;

    public TreeNode(TreeGroupModel group) {
        this.group = group;
    }

    @Override
    public String getGroup() {
        return this.group.toString();
    }

    @Override
    public String getLabel() {
        return this.group.label();
    }

    @Override
    public BufferedImage getImage() {
        Colibri.ICONS icon = this.group.icon();
        return icon == null ? null : icon.getImage(20);
    }

    @Override
    public Color getForeground() {
        return ColorManager.COLOR_DARK_GREEN;
    }

    @Override
    public IAction getAction() {
        return this.action;
    }

    @Override
    public boolean showToolBar() {
        for (ITreeNode node : this) {
            node.showIcon();
        }
        return true;
    }

    @Override
    public boolean hideToolBar() {
        for (ITreeNode node : this) {
            node.hideIcon();
        }
        return true;
    }

    @Override
    public int countVisibleIcons() {
        int count = 0;
        for (ITreeNode node : this) {
            if (!node.isIconVisible()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isIconVisible() {
        return false;
    }

    @Override
    public boolean showIcon() {
        return false;
    }

    @Override
    public boolean hideIcon() {
        return false;
    }

    @Override
    public boolean changeIcon() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "group=" + this.group + "," + "label=" + this.getLabel();
    }
}

