/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.views.tree;

import org.dma.java.util.Debug;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.ColibriUI;
import org.projectocolibri.rcp.colibri.workbench.support.views.ColibriViewPart;
import org.projectocolibri.rcp.colibri.workbench.support.views.ViewParameters;
import org.projectocolibri.rcp.colibri.workbench.views.tree.TreeContainer;
import org.projectocolibri.rcp.colibri.workbench.views.tree.TreeContextMenu;
import org.projectocolibri.rcp.colibri.workbench.views.tree.model.ITreeNode;
import org.projectocolibri.rcp.colibri.workbench.views.tree.model.TreeNode;

public class TreeView
extends ColibriViewPart<ViewParameters> {
    public static final String ID = TreeView.class.getCanonicalName();
    private TreeViewer viewer;

    @Override
    public void createControl() {
        this.setIcon();
        this.setTitle();
        if (this.viewer == null) {
            this.viewer = new TreeViewer(this.getParent());
            ColibriUI.setMenuTree(new TreeContainer(this.viewer));
            this.viewer.getTree().setMenu((Menu)new TreeContextMenu(this.viewer.getTree()));
            this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    block6: {
                        TreeItem[] selection = TreeView.this.viewer.getTree().getSelection();
                        if (selection.length == 1) {
                            ITreeNode node = (ITreeNode)selection[0].getData();
                            if (node instanceof TreeNode) {
                                try {
                                    if (TreeView.this.viewer.getExpandedState((Object)node)) {
                                        TreeView.this.viewer.collapseToLevel((Object)node, -1);
                                        break block6;
                                    }
                                    TreeView.this.viewer.expandToLevel((Object)node, -1);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            } else {
                                node.getAction().run();
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void setIcon() {
        this.setTitleImage(Colibri.ICONS.WINDOW_TREE);
    }

    @Override
    public void setTitle() {
        this.setPartName(LABELS.window_tree.toString());
    }

    @Override
    public void executeOnPartClosed() {
        ColibriUI.setMenuTree(null);
        this.viewer.getTree().dispose();
        Debug.err((String)"DISPOSED");
    }

    @Override
    public boolean isRestorable() {
        return true;
    }
}

