/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.views.tree;

import java.io.File;
import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.swt.dialogs.file.FileExport;
import org.dma.eclipse.swt.dialogs.file.FileImport;
import org.dma.eclipse.ui.UIHelper;
import org.dma.java.util.MessageList;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.manager.tasks.UtilizadoresiconesTask;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.ColibriUI;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriMenuItem;
import org.projectocolibri.rcp.colibri.workbench.views.tree.model.ITreeNode;
import org.projectocolibri.rcp.colibri.workbench.views.tree.model.TreeNode;

public class TreeContextMenu
extends Menu {
    protected void checkSubclass() {
    }

    public TreeContextMenu(final Tree tree) {
        super((Control)tree);
        ITEMS.ICON_SHOW.createItem(this);
        ITEMS.ICON_HIDE.createItem(this);
        ITEMS.ICON_CHANGE.createItem(this);
        new MenuItem((Menu)this, 2);
        ITEMS.TOOLBAR_SHOW.createItem(this);
        ITEMS.TOOLBAR_HIDE.createItem(this);
        new MenuItem((Menu)this, 2);
        ITEMS.COOLBAR_EXPORT.createItem(this);
        ITEMS.COOLBAR_IMPORT.createItem(this);
        this.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                TreeItem[] selection;
                MenuItem[] menuItemArray = TreeContextMenu.this.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.setEnabled(false);
                    ++n2;
                }
                ITEMS.COOLBAR_EXPORT.enable();
                ITEMS.COOLBAR_IMPORT.enable();
                TreeItem[] treeItemArray = selection = tree.getSelection();
                int n3 = selection.length;
                n = 0;
                while (n < n3) {
                    TreeItem item = treeItemArray[n];
                    ITreeNode node = (ITreeNode)item.getData();
                    if (node instanceof TreeNode) {
                        if (node.countVisibleIcons() == 0) {
                            ITEMS.TOOLBAR_SHOW.enable();
                        } else {
                            ITEMS.TOOLBAR_HIDE.enable();
                        }
                    } else {
                        if (!node.isIconVisible()) {
                            ITEMS.ICON_SHOW.enable();
                        } else {
                            ITEMS.ICON_HIDE.enable();
                        }
                        if (selection.length == 1) {
                            ITEMS.ICON_CHANGE.enable();
                        }
                    }
                    ++n;
                }
            }
        });
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    boolean changed = false;
                    if (ITEMS.COOLBAR_EXPORT.equals(event.widget)) {
                        File file = new FileExport(UIHelper.getWorkbenchShell(), new String[]{Colibri.FILES.COOLBAR.parameters.wildcards}).filePicker(Colibri.FILES.COOLBAR.getParameters((String)ColibriDatabase.getManager().getUtilizador().getUser()).filename);
                        MessageList error = new UtilizadoresiconesTask(ColibriDatabase.getManager()).exportTo(file);
                        ErrorDialog.open((MessageList)error);
                    } else if (ITEMS.COOLBAR_IMPORT.equals(event.widget)) {
                        MessageList error;
                        File file = new FileImport(UIHelper.getWorkbenchShell(), new String[]{Colibri.FILES.COOLBAR.parameters.wildcards}).filePicker();
                        if (file != null && !ErrorDialog.open((MessageList)(error = new UtilizadoresiconesTask(ColibriDatabase.getManager()).importFrom(file)))) {
                            changed = true;
                        }
                    } else {
                        TreeItem[] treeItemArray = tree.getSelection();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            ITreeNode node = (ITreeNode)item.getData();
                            if (ITEMS.TOOLBAR_SHOW.equals(event.widget) && node.showToolBar()) {
                                changed = true;
                            } else if (ITEMS.TOOLBAR_HIDE.equals(event.widget) && node.hideToolBar()) {
                                changed = true;
                            } else if (ITEMS.ICON_SHOW.equals(event.widget) && node.showIcon()) {
                                changed = true;
                            } else if (ITEMS.ICON_HIDE.equals(event.widget) && node.hideIcon()) {
                                changed = true;
                            } else if (ITEMS.ICON_CHANGE.equals(event.widget) && node.changeIcon()) {
                                changed = true;
                            }
                            ++n2;
                        }
                    }
                    if (changed) {
                        ColibriUI.update(true);
                    }
                }
            });
            ++n2;
        }
    }

    private static enum ITEMS {
        ICON_SHOW(LABELS.menutree_contexto_icone_mostrar, Colibri.ICONS.TOOLBAR_ADICIONAR),
        ICON_HIDE(LABELS.menutree_contexto_icone_esconder, Colibri.ICONS.TOOLBAR_REMOVER),
        ICON_CHANGE(LABELS.menutree_contexto_icone_alterar, Colibri.ICONS.TOOLBAR_ALTERAR),
        TOOLBAR_SHOW(LABELS.menutree_contexto_toolbar_mostrar, Colibri.ICONS.TOOLBAR_ADICIONAR),
        TOOLBAR_HIDE(LABELS.menutree_contexto_toolbar_esconder, Colibri.ICONS.TOOLBAR_REMOVER),
        COOLBAR_EXPORT(LABELS.menutree_contexto_coolbar_exportar, Colibri.ICONS.TOOLBAR_EXPORTAR),
        COOLBAR_IMPORT(LABELS.menutree_contexto_coolbar_importar, Colibri.ICONS.TOOLBAR_IMPORTAR);

        private ColibriMenuItem item;
        private final LABELS label;
        private final Colibri.ICONS icon;

        private ITEMS(LABELS label, Colibri.ICONS icon) {
            this.label = label;
            this.icon = icon;
        }

        private void createItem(Menu parent) {
            this.item = new ColibriMenuItem(parent, this.label);
            this.item.setImage(this.icon);
        }

        public void enable() {
            this.item.setEnabled(true);
        }

        public boolean equals(Widget widget) {
            return widget == this.item;
        }
    }
}

