/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.views.servicos.mb;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import org.dma.eclipse.core.jobs.CustomJob;
import org.dma.eclipse.core.jobs.UIAction;
import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.viewers.TableViewerContainer;
import org.dma.eclipse.swt.widgets.CustomDateTime;
import org.dma.eclipse.swt.widgets.CustomTable;
import org.dma.java.time.DatePeriod;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.dma.java.util.TimeDateUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.api.services.payment.PaymentServiceJob;
import org.projectocolibri.api.services.payment.PaymentServiceResponseType;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.views.ColibriViewPart;
import org.projectocolibri.rcp.colibri.workbench.support.views.ViewParameters;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriButton;
import org.projectocolibri.rcp.colibri.workbench.views.servicos.mb.PagamentosComparator;
import org.projectocolibri.rcp.colibri.workbench.views.servicos.mb.PagamentosContainer;
import org.projectocolibri.rcp.colibri.workbench.views.servicos.mb.PagamentosLabelProvider;
import org.projectocolibri.rcp.colibri.workbench.views.servicos.mb.PagamentosValidator;

public class PagamentosView
extends ColibriViewPart<ViewParameters> {
    public static final String ID = PagamentosView.class.getCanonicalName();
    private final CustomDateTime[] date_periodo = new CustomDateTime[2];
    private TableViewerContainer<PaymentServiceResponseType> tableContainer;
    public final CommandAction processarRegistoAction = new CommandAction(Utilizadores.COMMANDS.ProcessarRegisto){

        public void run() {
            PagamentosView.this.jobList.addJob(new CustomJob().addTask((IAction)new UIAction(){

                public void run() {
                    Debug.out((Object)PagamentosView.this.tableContainer.getSelectionList());
                }
            })).schedule();
        }

        @Override
        public boolean isValid() {
            return !PagamentosView.this.isBusy();
        }
    };
    public final CommandAction pesquisarRegistoAction = new CommandAction(Utilizadores.COMMANDS.PesquisarRegisto){

        public void run() {
            DatePeriod periodo = new DatePeriod(PagamentosView.this.date_periodo[0].getCalendar(), PagamentosView.this.date_periodo[1].getCalendar());
            PagamentosView.this.jobList.addJob((CustomJob)new PaymentServiceJob(ColibriDatabase.getManager(), periodo){

                public void error(MessageList error) {
                    ErrorDialog.open((MessageList)error);
                }

                public void done(Collection<PaymentServiceResponseType> col) {
                    PagamentosView.this.tableContainer.setElements(col);
                }
            }).schedule();
        }

        @Override
        public boolean isValid() {
            return !PagamentosView.this.isBusy();
        }
    };

    @Override
    public void createControl() {
        this.getActions().add(this.pesquisarRegistoAction);
        Debug.out((String)"PART 1 STARTED");
        this.createContents(this.getParent());
        this.registerCombos();
        this.createControl2();
        Debug.out((String)"PART 1 DONE");
    }

    private void createControl2() {
        Debug.out((String)"PART 2 CALLED");
        if (this.getParameters() == null) {
            return;
        }
        Debug.out((String)"PART 2 STARTED");
        this.registerValidator();
        this.setInitialized(true);
        Debug.out((String)"PART 2 DONE");
    }

    private Composite createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutFactory.gridLayout());
        this.createTableContainer(composite);
        this.createLowerToolBar(composite);
        return composite;
    }

    private void createTableContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        CustomTable table = new CustomTable(composite, 67586);
        COLUMNS[] cOLUMNSArray = COLUMNS.values();
        int n = cOLUMNSArray.length;
        int n2 = 0;
        while (n2 < n) {
            COLUMNS column = cOLUMNSArray[n2];
            table.createColumn(column.style, column.width).setText(column.label);
            ++n2;
        }
        table.addResizeListener(500);
        TableViewer tableViewer = new TableViewer((Table)table);
        tableViewer.setLabelProvider((IBaseLabelProvider)new PagamentosLabelProvider());
        tableViewer.setComparator((ViewerComparator)new PagamentosComparator());
        this.tableContainer = new PagamentosContainer(tableViewer, this){

            public Collection<PaymentServiceResponseType> retrieveObjects(long topIndex, long bottomIndex) {
                if (PagamentosView.this.pesquisarRegistoAction.isValid()) {
                    PagamentosView.this.pesquisarRegistoAction.run();
                }
                return new ArrayList<PaymentServiceResponseType>();
            }
        };
    }

    private void createLowerToolBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutFactory.rowHolder());
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(composite, 0);
        label.setText("Data Inicio");
        this.date_periodo[0] = new CustomDateTime(composite, 0);
        this.date_periodo[0].setDay(1);
        label = new Label(composite, 0);
        label.setText("Data Fim");
        this.date_periodo[1] = new CustomDateTime(composite, 0);
        this.date_periodo[1].setDay(TimeDateUtils.getDayOfMonthMax((Calendar)TimeDateUtils.getCalendar()));
        new ColibriButton(composite, this.pesquisarRegistoAction);
    }

    private void registerCombos() {
    }

    private void unregisterCombos() {
    }

    private void registerValidator() {
        PagamentosValidator validator = new PagamentosValidator(this);
        this.validationManager.register(ID, (IValidator)validator);
    }

    @Override
    public void initialize(ViewParameters parameters) {
        super.initialize(parameters);
        this.createControl2();
    }

    @Override
    public void setIcon() {
        this.setTitleImage(Colibri.ICONS.COOLBAR_PAGAMENTOS);
    }

    @Override
    public void setTitle() {
        this.setPartName(LABELS.window_pagamentos.toString());
    }

    @Override
    public void setFocus() {
        this.date_periodo[0].setFocus();
    }

    @Override
    public void executeOnPartClosed() {
        this.unregisterCombos();
    }

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.setParameters(new ViewParameters(site, ColibriDatabase.getManager().loadEntidadestipos(Entidadestipos.RECORDS.cliente.codigo)));
        }
    }

    @Override
    public boolean isRestorable() {
        return true;
    }

    public static enum COLUMNS {
        ID("ID", 10, 16384),
        REFERENCIA("Refer\u00eancia", 15, 16384),
        VALOR("Valor Pago", 15, 16384),
        DATA("Data Pagamento", 20, 16384),
        HORA("Hora Pagamento", 20, 16384),
        FACTURA("Factura", 20, 16384);

        public final String label;
        public final int width;
        public final int style;

        private COLUMNS(String label, int width, int style) {
            this.label = label;
            this.width = width;
            this.style = style;
        }
    }
}

