/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.views.filters.swt;

import java.util.ArrayList;
import java.util.Collection;
import org.dma.eclipse.swt.input.support.TraverseSupport;
import org.dma.eclipse.swt.input.validation.field.IFieldRules;
import org.dma.java.input.FieldFormat;
import org.dma.java.util.ArrayUtils;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.nebula.widgets.formattedtext.ITextFormatter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.filter.FilterFieldMap;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.filter.FilterOperandMap;
import org.projectocolibri.api.database.filter.OPERANDS;
import org.projectocolibri.api.database.filter.OPERATORS;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.rcp.colibri.RCPcolibri;
import org.projectocolibri.rcp.colibri.workbench.support.CustomFormattedText;
import org.projectocolibri.rcp.colibri.workbench.support.FormatFactory;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.combos.AutocompleteComboViewer;
import org.projectocolibri.rcp.colibri.workbench.support.combos.ComboManager;
import org.projectocolibri.rcp.colibri.workbench.views.filters.swt.SWTFilterFieldMap;
import org.projectocolibri.rcp.colibri.workbench.views.filters.swt.SWTFilterMap;
import org.projectocolibri.rcp.colibri.workbench.views.filters.swt.SWTFilterOperandMap;
import org.projectocolibri.rcp.colibri.workbench.views.filters.swt.SWTFilterValidator;

public class SWTFilter
extends SWTFilterMap
implements IFieldRules {
    private static final long serialVersionUID = 1L;
    public static final int MAX_LOGICAL_OPERATORS = 1;
    public static final int MAX_INTERFACE_COLUMNS = 6;
    private final Listener listener = new Listener(){
        private static final int MARGIN = 50;

        public void handleEvent(Event event) {
            Control control = (Control)event.widget;
            Rectangle bounds = control.getBounds();
            Rectangle area = SWTFilter.this.sc.getClientArea();
            Point origin = SWTFilter.this.sc.getOrigin();
            if (origin.x > bounds.x) {
                origin.x = Math.max(0, bounds.x);
            }
            if (origin.y > bounds.y) {
                origin.y = Math.max(0, bounds.y);
            }
            if (origin.x + area.width < bounds.x + bounds.width) {
                origin.x = Math.max(0, bounds.x + bounds.width - area.width);
            }
            if (origin.y + area.height < bounds.y + bounds.height + 50) {
                origin.y = Math.max(0, bounds.y + bounds.height - area.height + 50);
            }
            SWTFilter.this.sc.setOrigin(origin);
        }
    };
    private final TraverseSupport traverseSupport;
    private final SWTFilterValidator validator;
    private final Collection<Control> controls;
    private final Collection<ComboViewer> viewers;
    private final ScrolledComposite sc;
    private final FilterMap filterMap;

    public SWTFilter(ScrolledComposite sc, FilterMap filterMap) {
        super(filterMap.table);
        this.traverseSupport = new TraverseSupport(RCPcolibri.PREFERENCES.TRAVERSE_KEYPAD_ENTER.value.getBoolean());
        this.validator = new SWTFilterValidator(this);
        this.controls = new ArrayList<Control>();
        this.viewers = new ArrayList<ComboViewer>();
        this.sc = sc;
        this.filterMap = filterMap;
        this.createContents();
    }

    public void dispose() {
        this.validator.unregisterAll();
        this.removeKeyListeners();
        this.unregisterCombos();
        this.sc.getContent().dispose();
        this.controls.clear();
        this.viewers.clear();
        this.clear();
    }

    private void unregisterCombos() {
        for (ComboViewer viewer : this.viewers) {
            ComboManager.unregister(viewer);
        }
    }

    public void setFocus() {
        this.traverseSupport.selectFirst();
    }

    public boolean hasError() {
        return this.validator.hasError();
    }

    private void createKeyListeners() {
        for (Control control : this.controls) {
            this.traverseSupport.add(control);
            control.addListener(26, this.listener);
        }
    }

    private void removeKeyListeners() {
        for (Control control : this.controls) {
            this.traverseSupport.remove(control);
            control.removeListener(26, this.listener);
        }
    }

    private void fillEmptyColumns(Composite composite, int startPosition) {
        int i = startPosition;
        while (i <= 6) {
            new Label(composite, 0);
            ++i;
        }
    }

    private void createContents() {
        this.filterMap.process();
        Composite composite = new Composite((Composite)this.sc, 0);
        composite.setLayout((Layout)LayoutFactory.gridLayout(6));
        for (TableFieldKey fieldKey : this.filterMap.keySet()) {
            if (!this.table.map.containsKey((Object)fieldKey)) continue;
            ArrayList<SWTFilterOperandMap> operands = new ArrayList<SWTFilterOperandMap>();
            ArrayList<Combo> logicalOperators = new ArrayList<Combo>();
            Label label = new Label(composite, 0);
            label.setText(this.table.map.get(fieldKey).label(ColibriDatabase.getManager().getCampos()));
            label.pack();
            FIELDS field = this.table.map.get((TableFieldKey)fieldKey).field;
            FilterFieldMap fieldMap = (FilterFieldMap)this.filterMap.get((Object)fieldKey);
            int componentsCount = 1;
            int index = 0;
            for (FilterOperandMap operand : fieldMap) {
                Text control = null;
                ITextFormatter formatter = null;
                if (index > 0) {
                    Combo combo = new Combo(composite, 8);
                    combo.setItems(OPERATORS.LOGICAL.ITEMS);
                    combo.setVisibleItemCount(20);
                    combo.pack();
                    combo.select(fieldMap.getLogicalOperators(index - 1).ordinal());
                    logicalOperators.add(combo);
                    ++componentsCount;
                }
                Combo mathOperatorCombo = new Combo(composite, 8);
                mathOperatorCombo.setItems(OPERATORS.MATH.GROUPS.find((FIELDS.TYPES)field.type).labels);
                mathOperatorCombo.setVisibleItemCount(20);
                mathOperatorCombo.pack();
                mathOperatorCombo.select(OPERATORS.MATH.GROUPS.find((FIELDS.TYPES)field.type).indexOf(operand.getOperator()));
                switch (operand.getType()) {
                    case VALUE: {
                        Text text;
                        block5 : switch (field.combo) {
                            case NONE: {
                                text = new Text(composite, 2048);
                                text.setLayoutData((Object)new GridData(150, -1));
                                control = text;
                                switch (field.type) {
                                    default: {
                                        break block5;
                                    }
                                    case TIME: 
                                    case DATE: {
                                        CustomFormattedText formattedText = FormatFactory.getFormattedText(field, text);
                                        this.validator.register(String.valueOf(fieldKey.name()) + index, (Control)label, (Control)text, formattedText.getFormatter(), 0);
                                        formatter = formattedText.getFormatter();
                                        formatter.setValue(operand.getConverted());
                                        text.setText(operand.getConverted() == null ? "" : formatter.getDisplayString());
                                        break block5;
                                    }
                                    case DECIMAL: 
                                    case INTEGER: 
                                    case STRING: 
                                    case LONGSTRING: 
                                }
                                this.validator.register(String.valueOf(fieldKey.name()) + index, (Control)label, (Control)text, (FieldFormat)field.format, 0);
                                text.setText(operand.getValue() == null ? "" : operand.getValue());
                                break;
                            }
                            case ARRAY: {
                                Combo combo = new Combo(composite, 8);
                                combo.setItems(ArrayUtils.insert((String[])field.values, (int)0, (String[])new String[]{""}));
                                combo.setVisibleItemCount(20);
                                combo.pack();
                                if (operand.getConverted() != null) {
                                    switch (field.type) {
                                        default: {
                                            combo.select((Integer)operand.getConverted() + 1);
                                            break;
                                        }
                                        case BOOLEAN: {
                                            combo.select(OPERANDS.VALUES.BOOLEAN.get((boolean)((Boolean)operand.getConverted())).ordinal() + 1);
                                            break;
                                        }
                                        case BINARY: {
                                            combo.select(OPERANDS.VALUES.BINARY.EMPTY.ordinal() + 1);
                                            break;
                                        }
                                    }
                                } else {
                                    combo.select(0);
                                }
                                control = combo;
                                break;
                            }
                            case TABLE: {
                                Combo combo = new Combo(composite, 2048);
                                combo.setVisibleItemCount(20);
                                combo.pack();
                                ComboViewer comboViewer = new ComboViewer(combo);
                                ((AutocompleteComboViewer)((Object)ComboManager.register(field.table, comboViewer).get(comboViewer))).enableEmpty();
                                combo.deselectAll();
                                combo.setText("");
                                combo.select(ArrayUtils.startedWith((String[])comboViewer.getCombo().getItems(), (String)operand.getValue()));
                                this.viewers.add(comboViewer);
                                control = combo;
                            }
                        }
                        break;
                    }
                    case VAR: {
                        Text text = new Text(composite, 2048);
                        text.setLayoutData((Object)new GridData(150, -1));
                        text.setEditable(false);
                        text.setEnabled(false);
                        control = text;
                        String string = field.format(operand.getConverted());
                        text.setText(string);
                        break;
                    }
                    case FIELD: {
                        Text text = new Text(composite, 2048);
                        text.setLayoutData((Object)new GridData(150, -1));
                        text.setEditable(false);
                        text.setEnabled(false);
                        control = text;
                        text.setText(operand.getValue());
                    }
                }
                this.controls.add((Control)control);
                operands.add(new SWTFilterOperandMap(mathOperatorCombo, operand.getValue(), operand.getType(), (Control)control, formatter));
                componentsCount += 2;
                ++index;
            }
            this.put(fieldKey, new SWTFilterFieldMap(operands, logicalOperators));
            this.fillEmptyColumns(composite, componentsCount + 1);
        }
        this.toMap();
        this.createKeyListeners();
        this.sc.setContent((Control)composite);
        this.sc.setMinSize(composite.computeSize(-1, -1, true));
        composite.update();
        this.setFocus();
    }
}

