/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.views;

import org.eclipse.ui.IViewSite;
import org.projectocolibri.api.birt.report.BIRTReportFile;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigosdocumentos;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.database.model.Pesquisas;
import org.projectocolibri.rcp.colibri.workbench.support.views.ColibriViewFile;

public class ViewParameters {
    private Entidadestipos tipoentidade;
    private Documentostipos tipodocumento;
    private Artigosdocumentos documentoartigos;
    private Entidadesdocumentos documentoentidades;
    private Artigos artigo;
    private Entidades entidade;
    private Pesquisas pesquisa;
    private ColibriViewFile file;
    private final String viewId;
    private final String secondaryId;

    public ViewParameters(IViewSite site) {
        this(site.getId(), site.getSecondaryId());
    }

    public ViewParameters(IViewSite site, Entidadestipos tipoentidade) {
        this(site.getId(), tipoentidade);
    }

    @Deprecated
    public ViewParameters(IViewSite site, Documentostipos tipodocumento) {
        this(site.getId(), tipodocumento);
    }

    public ViewParameters(String viewId) {
        this(viewId, (String)null);
    }

    public ViewParameters(String viewId, Entidadestipos tipoentidade) {
        this(viewId, tipoentidade == null ? null : tipoentidade.getCodigo());
        this.tipoentidade = tipoentidade;
    }

    public ViewParameters(String viewId, Documentostipos tipodocumento) {
        this(viewId, tipodocumento.getCodigo());
        this.tipodocumento = tipodocumento;
        this.tipoentidade = tipodocumento.getTipoentidade();
    }

    public ViewParameters(String viewId, Artigosdocumentos documento) {
        this(viewId, documento.isEdited() ? documento.getKey() : documento.getTipodocumento().getCodigo());
        this.documentoartigos = documento;
        this.tipodocumento = documento.getTipodocumento();
        this.tipoentidade = this.tipodocumento.getTipoentidade();
    }

    public ViewParameters(String viewId, Entidadesdocumentos documento) {
        this(viewId, documento.isEdited() ? documento.getKey() : documento.getTipodocumento().getCodigo());
        this.documentoentidades = documento;
        this.tipodocumento = documento.getTipodocumento();
        this.tipoentidade = this.tipodocumento.getTipoentidade();
    }

    public ViewParameters(String viewId, Artigos artigo) {
        this(viewId, artigo.isEdited() ? artigo.getCodigo() : "?");
        this.artigo = artigo;
    }

    public ViewParameters(String viewId, Entidades entidade) {
        this(viewId, entidade.isEdited() ? entidade.getKey() : entidade.getTipoentidade().getCodigo());
        this.entidade = entidade;
        this.tipoentidade = entidade.getTipoentidade();
    }

    public ViewParameters(String viewId, Pesquisas pesquisa) {
        this(viewId, null, pesquisa);
    }

    public ViewParameters(String viewId, Entidadestipos tipoentidade, Pesquisas pesquisa) {
        this(viewId, tipoentidade == null ? null : tipoentidade.getCodigo());
        this.tipoentidade = tipoentidade;
        this.pesquisa = pesquisa;
    }

    public ViewParameters(String viewId, BIRTReportFile file) {
        this(viewId, new ColibriViewFile(file));
    }

    public ViewParameters(String viewId, ColibriViewFile file) {
        this(viewId, file.url);
        this.file = file;
    }

    public ViewParameters(String viewId, String secondaryId) {
        this.viewId = viewId;
        this.secondaryId = secondaryId;
    }

    @Deprecated
    public void reset() {
    }

    public Entidadestipos getTipoentidade() {
        return this.tipoentidade;
    }

    public Documentostipos getTipodocumento() {
        return this.tipodocumento;
    }

    public Artigosdocumentos getDocumentoartigos() {
        return this.documentoartigos;
    }

    public Entidadesdocumentos getDocumentoentidades() {
        return this.documentoentidades;
    }

    public Artigos getArtigo() {
        return this.artigo;
    }

    public Entidades getEntidade() {
        return this.entidade;
    }

    public Pesquisas getPesquisa() {
        return this.pesquisa;
    }

    public ColibriViewFile getFile() {
        return this.file;
    }

    public String getViewId() {
        return this.viewId;
    }

    public String getSecondaryId() {
        return this.secondaryId;
    }

    public String toString() {
        return String.valueOf(this.viewId) + ":" + this.secondaryId;
    }
}

