/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.views;

import org.dma.eclipse.ui.UIHelper;
import org.dma.java.util.Debug;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.projectocolibri.rcp.colibri.RCPcolibri;
import org.projectocolibri.rcp.colibri.workbench.support.views.IViewStateSupport;
import org.projectocolibri.rcp.colibri.workbench.support.views.IViewTableContainer;
import org.projectocolibri.rcp.colibri.workbench.views.BaseView;

public class ColibriViewHelper
extends UIHelper {
    public static void showBaseView() {
        if (RCPcolibri.PREFERENCES.SHOW_BASE_VIEW.value.getBoolean()) {
            try {
                ColibriViewHelper.showView((String)BaseView.ID);
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isViewRestorable(IViewPart view) {
        if (view instanceof IViewStateSupport) {
            return ((IViewStateSupport)view).isRestorable();
        }
        return false;
    }

    public static void hideViews(IPerspectiveDescriptor perspective) {
        ColibriViewHelper.setPerspective((IPerspectiveDescriptor)perspective);
        ColibriViewHelper.hideViews();
    }

    public static void hideViews() {
        ColibriViewHelper.hideViews(ColibriViewHelper.getActivePage());
    }

    public static void hideViews(IWorkbenchPage page) {
        IViewReference[] iViewReferenceArray = page.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewReference = iViewReferenceArray[n2];
            IViewPart view = viewReference.getView(false);
            if (!ColibriViewHelper.isViewRestorable(view)) {
                ColibriViewHelper.hideView((IViewReference)viewReference);
                Debug.out((String)"HIDED", (Object)viewReference.getId());
            }
            ++n2;
        }
    }

    public static void restoreViews(IPerspectiveDescriptor perspective) {
        ColibriViewHelper.setPerspective((IPerspectiveDescriptor)perspective);
        ColibriViewHelper.restoreViews();
    }

    public static void restoreViews() {
        ColibriViewHelper.restoreViews(ColibriViewHelper.getActivePage());
    }

    public static void restoreViews(IWorkbenchPage page) {
        IViewReference[] iViewReferenceArray = page.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewReference = iViewReferenceArray[n2];
            viewReference.getView(true);
            Debug.out((String)"RESTORED", (Object)viewReference.getId());
            ++n2;
        }
    }

    public static void refreshView(String viewId) {
        ColibriViewHelper.refreshView(viewId, null);
    }

    public static void refreshView(String viewId, String secondaryId) {
        IViewPart view;
        IViewReference viewReference = ColibriViewHelper.findViewReference((String)viewId, (String)secondaryId);
        if (viewReference != null && (view = viewReference.getView(true)) instanceof IViewTableContainer) {
            ((IViewTableContainer)view).getTableContainer().updateTable();
            Debug.out((String)"REFRESHED", (Object)viewReference.getId());
        }
    }
}

