/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.tables.viewer;

import java.io.File;
import java.util.Collection;
import org.dma.eclipse.swt.dialogs.file.FolderDialog;
import org.dma.eclipse.swt.viewers.TableViewerContainer;
import org.dma.eclipse.swt.widgets.CustomTable;
import org.dma.java.io.Folder;
import org.eclipse.jface.viewers.TableViewer;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.filter.OPERATORS;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.mapper.TableLayoutArray;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.query.QueryOrdering;
import org.projectocolibri.api.database.query.QueryRange;
import org.projectocolibri.rcp.colibri.workbench.ColibriUI;
import org.projectocolibri.rcp.colibri.workbench.support.tables.viewer.ITableLayoutContainer;
import org.projectocolibri.rcp.colibri.workbench.support.tables.viewer.SWTTableLayout;

public abstract class TableLayoutContainer<T>
extends TableViewerContainer<T>
implements ITableLayoutContainer {
    private FilterMap filterMap;
    private final SWTTableLayout tableLayout;

    public abstract Collection<T> retrieveObjects(QueryDefinition var1);

    public FilterMap getFilterMap() {
        return this.filterMap;
    }

    public SWTTableLayout getTableLayout() {
        return this.tableLayout;
    }

    public TableLayoutContainer(TableViewer viewer, SWTTableLayout tableLayout) {
        this(viewer, tableLayout, 0);
    }

    public TableLayoutContainer(TableViewer viewer, SWTTableLayout tableLayout, int dynamicLoad) {
        this(viewer, tableLayout, dynamicLoad, CustomTable.SORT_DIRECTION.NONE);
    }

    public TableLayoutContainer(TableViewer viewer, SWTTableLayout tableLayout, int dynamicLoad, CustomTable.SORT_DIRECTION direction) {
        super(viewer, dynamicLoad, direction);
        this.filterMap = new FilterMap(tableLayout.table);
        this.tableLayout = tableLayout;
    }

    public void dispose() {
        this.tableLayout.dispose();
        super.dispose();
    }

    @Override
    public boolean resetTable() {
        this.filterMap.clear();
        return this.updateTable();
    }

    @Override
    public boolean updateTable(FilterMap filterMap) {
        if (filterMap.table != this.tableLayout.table) {
            throw new IllegalArgumentException("Expected map from table: " + this.tableLayout.table);
        }
        this.filterMap = filterMap;
        return this.updateTable();
    }

    public boolean updateTable(int columnIndex, OPERATORS.MATH operator, String value) {
        return this.updateTable(this.tableLayout.createFilterMap(columnIndex, operator, value));
    }

    public void updateTable(int keycode) {
        super.updateTable(keycode);
        ColibriUI.postMessage(String.valueOf(this.getCollection().size()));
    }

    public File exportTable(Folder folder) {
        File file = this.tableLayout.getFileParameters(folder).createTempFile();
        try {
            this.tableLayout.export(this.getSelectionIndices().length == 0 ? this.retrieveObjects(0L, Integer.MAX_VALUE) : this.getSelectionList(), file);
        }
        catch (Exception exception) {}
        return file;
    }

    public File exportTable() {
        Folder folder = new FolderDialog(this.table.getShell(), new String[0]).folderPicker();
        return folder == null ? null : this.exportTable(folder);
    }

    private QueryOrdering getOrdering() {
        int index = this.getOrderingIndex();
        QueryOrdering.DIRECTION direction = this.table.getSortDirection() == 128 ? QueryOrdering.DIRECTION.ASCENDING : QueryOrdering.DIRECTION.DESCENDING;
        return index == -1 ? new QueryOrdering(direction, new TableFieldKey[0]) : new QueryOrdering(direction, new TableFieldKey[]{(TableFieldKey)this.tableLayout.get(index)});
    }

    public Collection<T> retrieveObjects(long topIndex, long bottomIndex) {
        QueryDefinition query = new QueryDefinition(this.filterMap, this.getOrdering(), new QueryRange(topIndex, bottomIndex)).addFetchplan((TableLayoutArray)this.tableLayout);
        switch (this.tableLayout.table) {
            default: {
                break;
            }
            case documentostipos: {
                query.addFetchplan(new TableFieldKey[]{new TableFieldKey(new FIELDS[]{FIELDS.documentostipos_estado})});
                break;
            }
            case utilizadores: {
                query.addFetchplan(new TableFieldKey[]{new TableFieldKey(new FIELDS[]{FIELDS.utilizadores_estado})});
                break;
            }
            case artigos: {
                query.addFetchplan(new TableFieldKey[]{new TableFieldKey(new FIELDS[]{FIELDS.artigos_saidas}), new TableFieldKey(new FIELDS[]{FIELDS.artigos_entradas}), new TableFieldKey(new FIELDS[]{FIELDS.artigos_estado}), new TableFieldKey(new FIELDS[]{FIELDS.artigos_stockreal}), new TableFieldKey(new FIELDS[]{FIELDS.artigos_stockminimo})});
                break;
            }
            case artigosmovimentos: {
                query.addFetchplan(new TableFieldKey[]{new TableFieldKey(new FIELDS[]{FIELDS.artigosmovimentos_tipodocumento, FIELDS.documentostipos_tabela}), new TableFieldKey(new FIELDS[]{FIELDS.artigosmovimentos_tipodocumento, FIELDS.documentostipos_codigo}), new TableFieldKey(new FIELDS[]{FIELDS.artigosmovimentos_seriedocumento, FIELDS.documentosseries_serie}), new TableFieldKey(new FIELDS[]{FIELDS.artigosmovimentos_numerodocumento}), new TableFieldKey(new FIELDS[]{FIELDS.artigosmovimentos_numerolinhaproducao})});
                break;
            }
            case entidades: {
                query.addFetchplan(new TableFieldKey[]{new TableFieldKey(new FIELDS[]{FIELDS.entidades_totaldebito}), new TableFieldKey(new FIELDS[]{FIELDS.entidades_totalcredito}), new TableFieldKey(new FIELDS[]{FIELDS.entidades_tipoentidade, FIELDS.entidadestipos_codigo}), new TableFieldKey(new FIELDS[]{FIELDS.entidades_numero}), new TableFieldKey(new FIELDS[]{FIELDS.entidades_estado}), new TableFieldKey(new FIELDS[]{FIELDS.entidades_limitecredito}), new TableFieldKey(new FIELDS[]{FIELDS.entidades_saldoprevisto})});
                break;
            }
            case entidadesdocumentos: {
                query.addFetchplan(new TableFieldKey[]{new TableFieldKey(new FIELDS[]{FIELDS.entidadesdocumentos_estado}), new TableFieldKey(new FIELDS[]{FIELDS.entidadesdocumentos_estadoenvio}), new TableFieldKey(new FIELDS[]{FIELDS.entidadesdocumentos_documentcode}), new TableFieldKey(new FIELDS[]{FIELDS.entidadesdocumentos_webservice, FIELDS.entidadesdocumentosatws_resultado})});
                break;
            }
            case entidadesdocumentoslinhas: {
                query.addFetchplan(new TableFieldKey[]{new TableFieldKey(new FIELDS[]{FIELDS.entidadesdocumentoslinhas_tipo})});
                break;
            }
            case entidadesmovimentos: {
                query.addFetchplan(new TableFieldKey[]{new TableFieldKey(new FIELDS[]{FIELDS.entidadesmovimentos_datavencimento}), new TableFieldKey(new FIELDS[]{FIELDS.entidadesmovimentos_valorpendente})});
            }
        }
        this.filterMap = query;
        return this.retrieveObjects(query);
    }
}

