/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.tables.viewer;

import java.util.Collection;
import org.dma.java.util.ArrayUtils;
import org.dma.java.util.Debug;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.projectocolibri.api.database.ILabelFormatter;
import org.projectocolibri.api.database.ILayoutModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.LAYOUTS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.mapper.TableLayout;
import org.projectocolibri.api.database.mapper.TableLayoutArray;
import org.projectocolibri.rcp.colibri.workbench.InterfaceVARS;

public class SWTTableLayout
extends TableLayout {
    private static final long serialVersionUID = 1L;
    private final ControlListener controlListener = new ControlAdapter(){
        private int width = 0;

        public void controlResized(ControlEvent e) {
            if (this.width != ((SWTTableLayout)SWTTableLayout.this).SWTTable.getSize().x) {
                this.width = ((SWTTableLayout)SWTTableLayout.this).SWTTable.getSize().x;
                SWTTableLayout.this.resizeTableColumns();
            }
        }
    };
    private boolean busy = false;
    private int minimumWidth = 0;
    private int[] columnWidth;
    private final Table SWTTable;
    private final String[] columnLabel;

    private synchronized void setBusy(boolean busy) {
        this.busy = busy;
        this.SWTTable.setRedraw(!busy);
    }

    public SWTTableLayout(Table SWTTable, ILayoutModel model) {
        this(SWTTable, model.table(), model.getManager().getCampos(), (Collection<TableFieldKey>)model.getLayoutArray());
    }

    public SWTTableLayout(Table SWTTable, TABLES table, ILabelFormatter formatter) {
        this(SWTTable, table, formatter, (Collection<TableFieldKey>)LAYOUTS.getLayout((TABLES)table));
    }

    public SWTTableLayout(Table SWTTable, TABLES table, ILabelFormatter formatter, Collection<TableFieldKey> layout) {
        super(table, layout);
        this.SWTTable = SWTTable;
        this.columnLabel = this.getColumnLabel(formatter);
        SWTTable.setLinesVisible(true);
        SWTTable.setHeaderVisible(true);
        this.addTableListeners();
        this.createTableColumns();
    }

    public void dispose() {
        this.removeTableListeners();
        this.disposeTableColumns();
    }

    private void addTableListeners() {
        this.SWTTable.addControlListener(this.controlListener);
    }

    private void removeTableListeners() {
        this.SWTTable.removeControlListener(this.controlListener);
    }

    private void addColumnListeners(final int index) {
        final TableColumn column = this.SWTTable.getColumn(index);
        column.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!SWTTableLayout.this.busy) {
                    ((SWTTableLayout)SWTTableLayout.this).columnWidth[index] = column.getWidth();
                }
            }
        });
    }

    private int computeColumnLength(int index) {
        int width = 0;
        FIELDS field = this.table.map.get((TableFieldKey)((TableFieldKey)this.get((int)index))).field;
        if (field.combo == FIELDS.COMBO_TYPES.ARRAY) {
            width = ArrayUtils.larger((String[])field.values).length();
        } else {
            width = field.format.getSize().size + field.format.getSize().scale;
            if (width >= this.columnLabel[index].length() * 2) {
                width = width * 2 / 3;
            }
            width = Math.max(width, 5);
            width = Math.min(width, 25);
        }
        return Math.max(width, this.columnLabel[index].length());
    }

    private void disposeTableColumns() {
        this.setBusy(true);
        while (this.SWTTable.getColumnCount() != 0) {
            this.SWTTable.getColumn(0).dispose();
        }
        this.setBusy(false);
    }

    public void createTableColumns() {
        this.disposeTableColumns();
        this.setBusy(true);
        this.columnWidth = new int[this.columnLabel.length];
        int i = 0;
        while (i < this.columnLabel.length) {
            TableColumn column = new TableColumn(this.SWTTable, 0);
            column.setText(this.columnLabel[i]);
            column.setMoveable(true);
            this.columnWidth[i] = InterfaceVARS.averageCharWidth(this.computeColumnLength(i));
            this.addColumnListeners(i);
            ++i;
        }
        this.setBusy(false);
    }

    public void resizeTableColumns() {
        if (this.busy) {
            return;
        }
        this.setBusy(true);
        int tableWidth = Math.max(this.SWTTable.getClientArea().width, this.minimumWidth);
        int layoutWidth = 0;
        int[] nArray = this.columnWidth;
        int n = this.columnWidth.length;
        int n2 = 0;
        while (n2 < n) {
            int width = nArray[n2];
            layoutWidth += width;
            ++n2;
        }
        Debug.out((String)"WIDTH", (Object)(String.valueOf(tableWidth) + "/" + layoutWidth));
        int index = 0;
        TableColumn[] tableColumnArray = this.SWTTable.getColumns();
        int n3 = tableColumnArray.length;
        n = 0;
        while (n < n3) {
            TableColumn column = tableColumnArray[n];
            column.setWidth(tableWidth > layoutWidth ? this.columnWidth[index++] * tableWidth / layoutWidth : this.columnWidth[index++]);
            ++n;
        }
        this.setBusy(false);
    }

    public void setMinimumWidth(int minimumWidth) {
        this.minimumWidth = minimumWidth;
        this.resizeTableColumns();
    }

    public void setResizable(boolean resizable) {
        TableColumn[] tableColumnArray = this.SWTTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setResizable(false);
            ++n2;
        }
    }

    public void setColumnLabel(TableFieldKey fieldKey, String label) {
        int index = this.indexOf(fieldKey);
        if (index >= 0 && !label.isEmpty()) {
            this.columnLabel[index] = label;
        }
    }

    public TableLayoutArray getColumnLayout() {
        TableFieldKey[] layout = new TableFieldKey[this.columnLabel.length];
        int index = 0;
        int[] nArray = this.SWTTable.getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int order = nArray[n2];
            layout[index++] = (TableFieldKey)this.get(order);
            ++n2;
        }
        return new TableLayoutArray(layout);
    }

    public int getVisibleCount() {
        Rectangle rect = this.SWTTable.getClientArea();
        int itemHeight = this.SWTTable.getItemHeight();
        int headerHeight = this.SWTTable.getHeaderHeight();
        return (rect.height - headerHeight + itemHeight - 1) / itemHeight;
    }

    public String[] getColumnLabel() {
        return this.columnLabel;
    }
}

