/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.tables.editor;

import java.util.Collection;
import java.util.Iterator;
import org.dma.eclipse.swt.input.support.KeyboardSupport;
import org.dma.java.input.FieldFormat;
import org.dma.java.util.ArrayUtils;
import org.dma.java.util.Debug;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.nebula.widgets.formattedtext.FormattedTextCellEditor;
import org.eclipse.nebula.widgets.formattedtext.ITextFormatter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.rcp.colibri.RCPcolibri;
import org.projectocolibri.rcp.colibri.workbench.support.FormatFactory;
import org.projectocolibri.rcp.colibri.workbench.support.tables.editor.CustomComboBoxCellEditor;
import org.projectocolibri.rcp.colibri.workbench.support.tables.editor.CustomTextCellEditor;
import org.projectocolibri.rcp.colibri.workbench.support.tables.viewer.SWTTableLayout;
import org.projectocolibri.rcp.colibri.workbench.support.tables.viewer.TableLayoutContainer;
import org.projectocolibri.rcp.colibri.workbench.support.validators.TableValidator;

public abstract class TableEditor<T extends IDatabaseModel>
extends TableValidator<T> {
    protected final TableLayoutContainer<T> tableContainer;
    protected final KeyboardSupport keyboardSupport;

    public abstract Object getValueException(T var1, String var2, Object var3);

    public abstract void modifyException(T var1, String var2, Object var3);

    public abstract void postInsert(int var1, Collection<T> var2);

    public abstract void postRemove(int var1, Collection<T> var2);

    public TableEditor(final TableLayoutContainer tableContainer) {
        super(tableContainer.getViewer());
        this.tableContainer = tableContainer;
        this.viewer.setCellEditors(this.createCellEditors(this.viewer));
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                TableFieldKey fieldKey = TableEditor.this.getFieldKey(property);
                FIELDS rootField = tableContainer.getTableLayout().table.map.get((TableFieldKey)fieldKey.root()).field;
                IDatabaseModel model = (IDatabaseModel)element;
                return model.isEditable(rootField);
            }

            public Object getValue(Object element, String property) {
                int index = TableEditor.this.getColumnIndex(property);
                TableEditor.this.table.showColumn(TableEditor.this.table.getColumn(index));
                IDatabaseModel model = (IDatabaseModel)element;
                TableFieldKey fieldKey = TableEditor.this.getFieldKey(property);
                Object value = model.getValue(fieldKey);
                Debug.out((String)property, (Object)value);
                return TableEditor.this.getValueException(model, property, value);
            }

            public void modify(Object element, String property, Object value) {
                TableFieldKey fieldKey;
                IDatabaseModel model = (IDatabaseModel)(element instanceof Item ? ((Item)element).getData() : element);
                if (model.setValue(fieldKey = TableEditor.this.getFieldKey(property), value)) {
                    Debug.out((String)property, (Object)value);
                    TableEditor.this.modifyException(model, property, value);
                }
            }
        });
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (!RCPcolibri.PREFERENCES.SINGLE_CLICK_EDIT.value.getBoolean()) {
                    TableEditor.this.viewer.cancelEditing();
                }
            }
        });
        this.table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                if (TableEditor.this.table.getSelectionCount() == 0) {
                    return;
                }
                TableItem item = TableEditor.this.table.getSelection()[0];
                int i = 0;
                while (i < TableEditor.this.viewer.getCellEditors().length) {
                    if (item.getBounds(i).contains(event.x, event.y)) {
                        TableEditor.this.viewer.editElement(item.getData(), i);
                        break;
                    }
                    ++i;
                }
            }
        });
        this.keyboardSupport = new KeyboardSupport(this.viewer);
        this.keyboardSupport.startSupport();
    }

    public void dispose() {
        Debug.out();
        this.cancelEditing();
        super.dispose();
        int i = 0;
        while (i < this.viewer.getCellEditors().length) {
            this.viewer.getCellEditors()[i].dispose();
            ++i;
        }
        this.tableContainer.dispose();
    }

    private CellEditor[] createCellEditors(TableViewer viewer) {
        SWTTableLayout layout = this.tableContainer.getTableLayout();
        viewer.setColumnProperties(layout.toStringList().toArray());
        int index = 0;
        CellEditor[] cellEditors = new CellEditor[layout.size()];
        Iterator iterator = layout.iterator();
        while (iterator.hasNext()) {
            TableFieldKey fieldKey = (TableFieldKey)iterator.next();
            String columnLabel = layout.getColumnLabel(index, ColibriDatabase.getManager().getCampos());
            FIELDS field = layout.table.map.get((TableFieldKey)fieldKey).field;
            block0 : switch (field.combo) {
                case NONE: {
                    Object editor;
                    switch (field.type) {
                        default: {
                            editor = new CustomTextCellEditor((Composite)this.table, field);
                            ITextFormatter formatter = FormatFactory.getTextFormatter(field);
                            if (formatter == null) {
                                this.register(fieldKey.name(), columnLabel, editor.getControl(), (FieldFormat)field.format);
                            } else {
                                this.register(fieldKey.name(), columnLabel, editor.getControl(), formatter);
                                editor.setFormatter(formatter);
                            }
                            cellEditors[index] = editor;
                            break block0;
                        }
                        case TIME: {
                            editor = new FormattedTextCellEditor((Composite)this.table);
                            editor.setFormatter(FormatFactory.getTextFormatter(field));
                            this.register(fieldKey.name(), columnLabel, editor.getControl());
                            cellEditors[index] = editor;
                            break block0;
                        }
                        case DATE: {
                            editor = new FormattedTextCellEditor((Composite)this.table);
                            editor.setFormatter(FormatFactory.getTextFormatter(field));
                            this.register(fieldKey.name(), columnLabel, editor.getControl());
                            cellEditors[index] = editor;
                            break block0;
                        }
                        case DECIMAL: 
                        case INTEGER: 
                    }
                    editor = new FormattedTextCellEditor((Composite)this.table);
                    editor.setFormatter(FormatFactory.getTextFormatter(field));
                    this.register(fieldKey.name(), columnLabel, editor.getControl());
                    cellEditors[index] = editor;
                    break;
                }
                case ARRAY: {
                    Object editor = new ComboBoxCellEditor((Composite)this.table, field.values);
                    this.register(fieldKey.name(), columnLabel, editor.getControl());
                    cellEditors[index] = editor;
                    CCombo control = (CCombo)editor.getControl();
                    control.setVisibleItemCount(20);
                    editor.setActivationStyle(RCPcolibri.PREFERENCES.OPEN_CELL_COMBOS.value.getBoolean() ? 4 : 0);
                    control.setEditable(false);
                    break;
                }
                case TABLE: {
                    Object editor = new CustomComboBoxCellEditor((Composite)this.table, ColibriDatabase.getManager().getTableManager(field.table).getArray(null), ColibriDatabase.getManager().getTableManager(field.table).getArray(field.table.map.getKey()), field.format.isUppercase());
                    this.register(fieldKey.name(), columnLabel, editor.getControl(), new FieldFormat(field.type.type, 255, new char[0]));
                    cellEditors[index] = editor;
                    CCombo control = (CCombo)editor.getControl();
                    control.setVisibleItemCount(20);
                    editor.setActivationStyle(RCPcolibri.PREFERENCES.OPEN_CELL_COMBOS.value.getBoolean() ? 4 : 0);
                }
            }
            cellEditors[index].getControl().setToolTipText(field.label.tooltip());
            cellEditors[index].getControl().addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    Debug.out((String)"CELL");
                }

                public void focusLost(FocusEvent e) {
                    Debug.out((String)"CELL");
                    TableEditor.this.validateTable();
                }
            });
            ++index;
        }
        return cellEditors;
    }

    public void cancelEditing() {
        this.viewer.cancelEditing();
        this.table.getShell().setFocus();
    }

    public void addNewElement(boolean showFirstColumn) {
        this.postInsert(this.tableContainer.addNewElement(), this.tableContainer.getCollection());
        if (showFirstColumn) {
            this.tableContainer.showFirstColumn();
        }
        this.validateTable();
    }

    public void addElements(Collection<T> col, boolean showFirstColumn) {
        this.postInsert(this.tableContainer.addElements(col), this.tableContainer.getCollection());
        if (showFirstColumn) {
            this.tableContainer.showFirstColumn();
        }
        this.validateTable();
    }

    public void insertNewElement(boolean showFirstColumn) {
        this.postInsert(this.tableContainer.insertNewElement(), this.tableContainer.getCollection());
        if (showFirstColumn) {
            this.tableContainer.showFirstColumn();
        }
        this.validateTable();
    }

    public void replaceSelectedElement(T element, boolean showFirstColumn) {
        this.postInsert(this.tableContainer.replaceSelectedElement(element), this.tableContainer.getCollection());
        if (showFirstColumn) {
            this.tableContainer.showFirstColumn();
        }
        this.validateTable();
    }

    public boolean canRemoveElement(T element) {
        return true;
    }

    public void removeSelectedElements(boolean showFirstColumn) {
        if (this.canRemoveElement((IDatabaseModel)this.tableContainer.getSelectionElement())) {
            this.postRemove(this.tableContainer.removeSelectedElements(), this.tableContainer.getCollection());
        }
        if (showFirstColumn) {
            this.tableContainer.showFirstColumn();
        }
        this.validateTable();
    }

    public void moveSelectedElementsUp() {
        this.postInsert(this.tableContainer.moveSelectedElementsUp(), this.tableContainer.getCollection());
        this.validateTable();
    }

    public void moveSelectedElementsDown() {
        this.postInsert(this.tableContainer.moveSelectedElementsDown(), this.tableContainer.getCollection());
        this.validateTable();
    }

    public void setEnabled(boolean enabled) {
        int i = 0;
        while (i < this.viewer.getCellEditors().length) {
            this.viewer.getCellEditors()[i].getControl().setEnabled(enabled);
            ++i;
        }
    }

    public int getColumnIndex(String property) {
        return ArrayUtils.indexOf((Object[])this.viewer.getColumnProperties(), (Object)property);
    }

    public TableFieldKey getFieldKey(String property) {
        return (TableFieldKey)this.tableContainer.getTableLayout().get(this.getColumnIndex(property));
    }

    public void setToolTipText(String property, String tooltip) {
        int index = this.getColumnIndex(property);
        this.viewer.getCellEditors()[index].getControl().setToolTipText(tooltip);
    }

    public CCombo getCCombo(String property) {
        int index = this.getColumnIndex(property);
        return index == -1 ? null : (CCombo)this.viewer.getCellEditors()[index].getControl();
    }

    public Text getText(String property) {
        int index = this.getColumnIndex(property);
        return index == -1 ? null : (Text)this.viewer.getCellEditors()[index].getControl();
    }
}

