/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.combos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.dma.java.util.Debug;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Combo;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.rcp.colibri.workbench.support.combos.AutocompleteComboViewer;

public class GlobalCombo
extends HashMap<ComboViewer, AutocompleteComboViewer> {
    private static final long serialVersionUID = 1L;
    private final List<IDatabaseModel> objectCollection = new ArrayList<IDatabaseModel>();
    public final TABLES table;
    public final Object secondaryId;

    public GlobalCombo(TABLES table, Object secondaryId) {
        this.table = table;
        this.secondaryId = secondaryId;
    }

    public void addViewer(ComboViewer viewer) {
        AutocompleteComboViewer autocomplete = (AutocompleteComboViewer)((Object)this.get(viewer));
        if (autocomplete == null) {
            this.put(viewer, new AutocompleteComboViewer(viewer){

                @Override
                public void updateViewers() {
                    GlobalCombo.this.updateViewers();
                }
            });
        }
        Debug.out((String)("[" + this + "] VIEWER ADDED"), (Object)this.size());
        viewer.getCombo().setToolTipText(this.table.label.toString());
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setInput(this.objectCollection);
        viewer.getCombo().select(0);
        this.refreshViewer(viewer);
    }

    public void removeViewer(ComboViewer viewer) {
        AutocompleteComboViewer autocomplete = (AutocompleteComboViewer)((Object)this.remove(viewer));
        if (autocomplete != null) {
            Debug.err((String)("[" + this + "] VIEWER REMOVED"), (Object)this.size());
            autocomplete.dispose();
            viewer.setInput(null);
        }
    }

    public void refreshViewer(ComboViewer viewer) {
        viewer.refresh();
        viewer.getCombo().pack();
        ((AutocompleteComboViewer)((Object)this.get(viewer))).refresh();
        Debug.out((String)("[" + this + "]"), (Object)("(" + viewer.getCombo().getSelectionIndex() + "/" + viewer.getCombo().getItemCount() + ") " + viewer.getCombo().getText()));
    }

    public void refreshViewers() {
        for (ComboViewer viewer : this.keySet()) {
            this.refreshViewer(viewer);
        }
    }

    public void updateViewers() {
        this.updateCollection();
        this.refreshViewers();
    }

    private Collection<IDatabaseModel> loadCollection() {
        return this.secondaryId == null ? ColibriDatabase.getManager().getTableManager(this.table).getCollection() : ColibriDatabase.getManager().getTableManager(this.table).getCollection(this.secondaryId);
    }

    public void updateCollection() {
        this.objectCollection.clear();
        this.objectCollection.addAll(this.loadCollection());
        Debug.out((String)("[" + this + "]"), (Object)"COLLECTION UPDATED");
    }

    public IDatabaseModel getSelectedObject(Combo combo) {
        for (ComboViewer viewer : this.keySet()) {
            int index;
            if (!viewer.getCombo().equals(combo) || (index = combo.getSelectionIndex()) == -1) continue;
            return this.objectCollection.get(index);
        }
        return null;
    }

    public boolean isFocusControl() {
        for (ComboViewer viewer : this.keySet()) {
            if (!viewer.getControl().isFocusControl()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.secondaryId == null ? this.table.name() : String.valueOf(this.table.name()) + ":" + this.secondaryId;
    }
}

