/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.bars.menubar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.projectocolibri.rcp.colibri.workbench.IColibriPerspective;
import org.projectocolibri.rcp.colibri.workbench.support.bars.menubar.ColibriMenuBarItem;
import org.projectocolibri.rcp.colibri.workbench.support.bars.menubar.IColibriMenuBar;

public class ColibriMenuBar
extends HashMap<String, Collection<IContributionItem>>
implements IColibriMenuBar {
    private static final long serialVersionUID = 1L;
    private final IActionBarConfigurer configurer;
    private final IMenuManager menuBar;

    public void print(String message, String perspectiveId) {
        ArrayList<String> col = new ArrayList<String>(this.menuBar.getItems().length);
        IContributionItem[] iContributionItemArray = this.menuBar.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            col.add(item.getId());
            ++n2;
        }
        System.out.print(String.valueOf(message) + " " + perspectiveId + ": ");
        System.out.println(col);
    }

    public ColibriMenuBar(IActionBarConfigurer configurer) {
        this.configurer = configurer;
        this.menuBar = configurer.getMenuManager();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void build(IColibriPerspective perspective) {
        ArrayList<MenuManager> col = new ArrayList<MenuManager>();
        for (ColibriMenuBarItem item : perspective.createMenuBar(this.configurer.getWindowConfigurer().getWindow())) {
            col.add(item.createMenuBar(this.configurer));
        }
        this.put(perspective.getId(), col);
    }

    @Override
    public void save(IColibriPerspective perspective) {
        this.put(perspective.getId(), Arrays.asList(this.menuBar.getItems()));
    }

    @Override
    public void show(IColibriPerspective perspective) {
        if (!this.containsKey(perspective.getId())) {
            this.build(perspective);
        }
        this.menuBar.removeAll();
        for (IContributionItem item : (Collection)this.get(perspective.getId())) {
            this.menuBar.add(item);
        }
        this.menuBar.update(true);
    }
}

