/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.bars.coolbar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.dma.eclipse.ui.UIHelper;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.projectocolibri.rcp.colibri.workbench.IColibriPerspective;
import org.projectocolibri.rcp.colibri.workbench.support.bars.coolbar.ColibriCoolBarItem;
import org.projectocolibri.rcp.colibri.workbench.support.bars.coolbar.IColibriCoolBar;

public class ColibriCoolBar
extends HashMap<String, Collection<IContributionItem>>
implements IColibriCoolBar {
    private static final long serialVersionUID = 1L;
    private final IActionBarConfigurer configurer;
    private final ICoolBarManager coolBar;

    public void print(String message, String perspectiveId) {
        ArrayList<String> col = new ArrayList<String>(this.coolBar.getItems().length);
        IContributionItem[] iContributionItemArray = this.coolBar.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            col.add(item.getId());
            ++n2;
        }
        System.out.print(String.valueOf(message) + " " + perspectiveId + ": ");
        System.out.println(col);
    }

    public ColibriCoolBar(IActionBarConfigurer configurer) {
        this.configurer = configurer;
        this.coolBar = configurer.getCoolBarManager();
        UIHelper.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ColibriCoolBar.this.coolBar.setLockLayout(true);
            }
        });
    }

    @Override
    public void dispose() {
    }

    @Override
    public void build(IColibriPerspective perspective) {
        ArrayList<ToolBarContributionItem> col = new ArrayList<ToolBarContributionItem>();
        for (ColibriCoolBarItem item : perspective.createCoolBar(this.configurer.getWindowConfigurer().getWindow())) {
            col.add(new ToolBarContributionItem((IToolBarManager)item.createToolBar(this.configurer), item.getId()));
        }
        this.put(perspective.getId(), col);
    }

    @Override
    public void save(IColibriPerspective perspective) {
        this.put(perspective.getId(), Arrays.asList(this.coolBar.getItems()));
    }

    @Override
    public void show(IColibriPerspective perspective) {
        if (!this.containsKey(perspective.getId())) {
            this.build(perspective);
        }
        this.coolBar.removeAll();
        for (IContributionItem item : (Collection)this.get(perspective.getId())) {
            this.coolBar.add(item);
        }
        this.coolBar.update(true);
    }
}

