/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.shells.update;

import java.io.File;
import org.dma.eclipse.core.bindings.BindingSupport;
import org.dma.eclipse.jface.CustomAction;
import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.swt.dialogs.file.FolderDialog;
import org.dma.eclipse.swt.input.support.TraverseSupport;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.java.input.FieldFormat;
import org.dma.java.io.CustomFile;
import org.dma.java.io.Folder;
import org.dma.java.io.URLFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.core.remote.RemoteDownloadJob;
import org.projectocolibri.core.remote.updates.URLSectionKey;
import org.projectocolibri.core.remote.updates.UpdateFileHandler;
import org.projectocolibri.rcp.colibri.RCPcolibri;
import org.projectocolibri.rcp.colibri.workbench.ColibriUI;
import org.projectocolibri.rcp.colibri.workbench.shells.update.UpdateShellValidator;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriShell;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriTextButton;

public class UpdateShell
extends ColibriShell {
    private Text text_versao;
    private Label label_versao;
    private Label label_plataforma;
    private Combo combo_plataforma;
    private Label label_folder;
    private Text text_folder;
    private final BindingSupport bindingSupport = new BindingSupport();
    private final UpdateFileHandler handler;
    final CommandAction executarAction = new CommandAction(){

        public void run() {
            URLFile src = ((URLSectionKey)((UpdateShell)UpdateShell.this).handler.getPlatforms().get((int)((UpdateShell)UpdateShell.this).combo_plataforma.getSelectionIndex())).file;
            CustomFile dst = new CustomFile(UpdateShell.this.text_folder.getText(), new String[]{src.getName()});
            new RemoteDownloadJob(src, (File)dst){

                public void error() {
                    ErrorDialog.open((String)this.getName(), (String)LABELS.info_operacao_interrompida.toString());
                }

                public void done() {
                    ColibriUI.showTip(this.getName(), LABELS.info_operacao_concluida.toString());
                }
            }.schedule();
        }

        @Override
        public boolean isValid() {
            return !UpdateShell.this.hasError();
        }
    };

    public UpdateShell(Shell parent, UpdateFileHandler handler) {
        super(parent, 34032);
        this.handler = handler;
        this.getActions().add(this.executarAction);
        this.setText(LABELS.remote_update_window.toString());
        this.setImage(Colibri.ICONS.COOLBAR_ACTUALIZACAO);
        this.createContents();
        this.createButtons();
        this.registerValidator();
        this.reset();
        this.setGridLayout();
        this.pack();
        this.setCenteredLocation();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void reset() {
        int index = 0;
        String[] items = new String[this.handler.getPlatforms().size()];
        for (URLSectionKey url : this.handler.getPlatforms()) {
            items[index++] = url.description;
        }
        this.combo_plataforma.setItems(items);
        this.combo_plataforma.pack();
        this.combo_plataforma.select(0);
    }

    private void createContents() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)LayoutFactory.gridLayout(3));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        TraverseSupport traverseSupport = new TraverseSupport(RCPcolibri.PREFERENCES.TRAVERSE_KEYPAD_ENTER.value.getBoolean());
        this.label_versao = new Label(composite, 0);
        this.label_versao.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_versao.setText(LABELS.remote_update_versao.toString());
        this.text_versao = new Text(composite, 2048);
        this.text_versao.setLayoutData((Object)new GridData(150, -1));
        this.text_versao.setEditable(false);
        this.text_versao.setText(this.handler.getHeader().version.toString());
        traverseSupport.add((Control)this.text_versao);
        new Label(composite, 0);
        this.label_plataforma = new Label(composite, 0);
        this.label_plataforma.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_plataforma.setText(LABELS.remote_update_plataforma.toString());
        this.combo_plataforma = new Combo(composite, 8);
        this.combo_plataforma.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.combo_plataforma.setVisibleItemCount(20);
        traverseSupport.add((Control)this.combo_plataforma);
        new Label(composite, 0);
        this.label_folder = new Label(composite, 0);
        this.label_folder.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_folder.setText(LABELS.remote_update_pasta.toString());
        this.text_folder = new Text(composite, 2048);
        this.text_folder.setLayoutData((Object)new GridData(450, -1));
        traverseSupport.add((Control)this.text_folder);
        ColibriTextButton button = new ColibriTextButton(composite, LABELS.botao_procurar);
        button.setLayoutData(new GridData(100, -1));
        button.setSelectionAction((IAction)new CustomAction(){

            public void run() {
                Folder folder = new FolderDialog(UpdateShell.this.getShell(), new String[0]).folderPicker();
                if (folder != null) {
                    UpdateShell.this.text_folder.setText(folder.getAbsolutePath());
                }
                UpdateShell.this.text_folder.setFocus();
            }
        });
        Text text = new Text(composite, 2632);
        GridData gridData = new GridData(4, 4, true, true, 3, 1);
        gridData.widthHint = 500;
        gridData.heightHint = 171;
        text.setLayoutData((Object)gridData);
        text.setText(this.handler.getHeader().getReadme());
    }

    private void createButtons() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)LayoutFactory.buttonHolder(2));
        composite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        new ColibriTextButton(composite, LABELS.botao_executar).setSelectionAction(this.executarAction);
        new ColibriTextButton(composite, LABELS.botao_sair).setSelectionAction((IAction)new CustomAction(){

            public void run() {
                UpdateShell.this.dispose();
            }
        });
    }

    private void registerValidator() {
        UpdateShellValidator validator = new UpdateShellValidator(this);
        validator.register(LABELS.remote_update_versao.name(), (Control)this.label_versao, (Control)this.text_versao, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 2);
        validator.register(LABELS.remote_update_plataforma.name(), (Control)this.label_plataforma, (Control)this.combo_plataforma, 4);
        validator.register(LABELS.remote_update_pasta.name(), (Control)this.label_folder, (Control)this.text_folder, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 8);
        this.register(this.getText(), (IValidator)validator);
    }
}

