/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.shells.filters;

import org.dma.eclipse.swt.dialogs.file.FileExport;
import org.dma.eclipse.swt.dialogs.file.FileImport;
import org.dma.eclipse.swt.graphics.ColorManager;
import org.dma.eclipse.swt.widgets.CustomStyledText;
import org.dma.java.io.CustomFile;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.filter.FilterMapValidator;
import org.projectocolibri.api.database.model.Pesquisas;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.ColibriUI;
import org.projectocolibri.rcp.colibri.workbench.InterfaceVARS;
import org.projectocolibri.rcp.colibri.workbench.shells.filters.FilterShellValidator;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriShell;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriToolItem;

public abstract class FilterShell
extends ColibriShell {
    private final FilterShellValidator validator = new FilterShellValidator(this);
    private final FilterMapValidator filterValidator;
    private final CustomStyledText textEditor;
    private final FilterMap filterMap;
    private final String descricao;
    final CommandAction gravarRegistoAction = new CommandAction(Utilizadores.COMMANDS.GravarRegisto){

        public void run() {
            FilterShell.this.done(FilterShell.this.filterMap);
            FilterShell.this.dispose();
        }

        @Override
        public boolean isValid() {
            return !FilterShell.this.filterValidator.hasErrors();
        }
    };
    final CommandAction importarRegistoAction = new CommandAction(Utilizadores.COMMANDS.ImportarRegisto){

        public void run() {
            String filter = new FileImport((Shell)FilterShell.this, new String[]{Colibri.FILES.FILTERS.parameters.wildcards}).readText(CustomFile.UTF8_CHARSET);
            if (!filter.isEmpty()) {
                FilterShell.this.textEditor.setText(FilterShell.this.filterMap.cloneCopy(filter).toText());
            }
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };
    final CommandAction exportarRegistoAction = new CommandAction(Utilizadores.COMMANDS.ExportarRegisto){

        public void run() {
            String text = FilterShell.this.filterMap.toText();
            if (!text.isEmpty()) {
                new FileExport(FilterShell.this.getShell(), new String[]{Colibri.FILES.FILTERS.parameters.wildcards}).writeText(text, Colibri.FILES.FILTERS.getParameters((String)((FilterShell)FilterShell.this).descricao).filename, CustomFile.UTF8_CHARSET);
            }
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };

    public abstract void done(FilterMap var1);

    public FilterShell(Shell parent, Templates template) {
        this(parent, template.getCodigo(), template.getDescricao(), template.getFiltroToMap());
    }

    public FilterShell(Shell parent, Pesquisas pesquisa) {
        this(parent, pesquisa.getCodigo(), pesquisa.getDescricao(), pesquisa.getFiltroToMap());
    }

    public FilterShell(Shell parent, String codigo, String descricao, FilterMap filterMap) {
        super(parent, 34032);
        this.descricao = descricao;
        this.filterMap = filterMap;
        this.filterValidator = filterMap.validator();
        this.getActions().add(this.importarRegistoAction).add(this.exportarRegistoAction);
        this.setText(String.valueOf(LABELS.pesquisas_filtro.toString()) + " " + codigo + " - " + descricao);
        this.setImage(Colibri.ICONS.WINDOW_FILTER);
        this.createToolBar();
        this.textEditor = this.createEditor();
        this.createDefaultButtons(this.gravarRegistoAction);
        this.update();
        this.setGridLayout();
        this.pack();
        this.setParentBounds();
    }

    @Override
    public void dispose() {
        this.textEditor.dispose();
        super.dispose();
    }

    public boolean setFocus() {
        return this.textEditor.setFocus();
    }

    private void createToolBar() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)LayoutFactory.rowHolder());
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        ToolBar toolbar = new ToolBar((Composite)this, 0);
        new ColibriToolItem(toolbar, this.importarRegistoAction);
        new ColibriToolItem(toolbar, this.exportarRegistoAction);
    }

    private CustomStyledText createEditor() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)LayoutFactory.gridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        CustomStyledText text = new CustomStyledText(composite, 2816){

            public String getLineDelimiter() {
                return "\n";
            }

            public void doUpdate() {
                FilterShell.this.filterValidator.checkErrors(this.getText(), 1);
                int start = 0;
                int index = 0;
                int i = 0;
                while (i < this.getLineCount()) {
                    try {
                        String line = this.getLine(i);
                        if (!line.isEmpty()) {
                            boolean error = FilterShell.this.filterValidator.hasError(index++);
                            StyleRange styleRange = new StyleRange();
                            styleRange.start = start;
                            styleRange.length = line.length();
                            styleRange.fontStyle = error ? 1 : 0;
                            styleRange.foreground = error ? InterfaceVARS.COLOR_ERROR : ColorManager.COLOR_BLACK;
                            this.setStyleRange(styleRange);
                        }
                        start += line.length() + this.getLineDelimiter().length();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                FilterShell.this.validator.validateButtons();
                ColibriUI.postError(FilterShell.this.filterValidator.toString());
            }
        };
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 171;
        gridData.widthHint = 300;
        text.setLayoutData((Object)gridData);
        text.setText(this.filterMap.toText());
        return text;
    }
}

