/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.empresa.vendedores.shell;

import org.dma.eclipse.core.bindings.BindingSupport;
import org.dma.eclipse.core.bindings.ValueBindingDefinition;
import org.dma.eclipse.core.bindings.converters.ComboToInteger;
import org.dma.eclipse.core.bindings.converters.IntegerToCombo;
import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.swt.input.support.TraverseSupport;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.widgets.CustomComboViewer;
import org.dma.java.util.MessageList;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.formattedtext.FormattedText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.model.Vendedores;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.RCPcolibri;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.empresa.vendedores.VendedoresContainer;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.empresa.vendedores.shell.VendedoresShellValidator;
import org.projectocolibri.rcp.colibri.workbench.support.FormatFactory;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.converters.BigDecimalToStringFormatted;
import org.projectocolibri.rcp.colibri.workbench.support.converters.StringToBigDecimalFormatted;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriShell;

public class VendedoresShell
extends ColibriShell {
    private Text text_codigo;
    private Label label_codigo;
    private Text text_nome;
    private Label label_nome;
    private Label label_estado;
    private Combo combo_estado;
    private ComboViewer comboviewer_estado;
    private Text text_comissao;
    private Label label_comissao;
    private FormattedText format_comissao;
    private final BindingSupport bindingSupport = new BindingSupport();
    private final VendedoresContainer tableContainer;
    final CommandAction gravarRegistoAction = new CommandAction(TABLES.vendedores, Utilizadores.COMMANDS.GravarRegisto){

        public void run() {
            MessageList error = VendedoresShell.this.tableContainer.insertObject();
            if (!ErrorDialog.open((MessageList)error)) {
                VendedoresShell.this.dispose();
            }
        }

        @Override
        public boolean isValid() {
            return !VendedoresShell.this.hasError();
        }
    };

    public Vendedores getVendedor() {
        return this.tableContainer.getVendedor();
    }

    public VendedoresShell(Shell parent, VendedoresContainer tableContainer) {
        super(parent, 32864);
        this.tableContainer = tableContainer;
        this.setText(LABELS.vendedores.toString());
        this.setImage(Colibri.ICONS.WINDOW_SHELL);
        this.createContents();
        this.createDefaultButtons(this.gravarRegistoAction);
        this.registerBindings();
        this.registerValidator();
        this.setGridLayout();
        this.pack();
        this.setCenteredLocation();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void createContents() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)LayoutFactory.gridLayout(2));
        TraverseSupport traverseSupport = new TraverseSupport(RCPcolibri.PREFERENCES.TRAVERSE_KEYPAD_ENTER.value.getBoolean());
        this.label_codigo = new Label(composite, 0);
        this.label_codigo.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_codigo.setText(LABELS.vendedores_codigo.toString());
        this.text_codigo = new Text(composite, 2048);
        this.text_codigo.setLayoutData((Object)new GridData(150, -1));
        traverseSupport.add((Control)this.text_codigo);
        this.label_nome = new Label(composite, 0);
        this.label_nome.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_nome.setText(LABELS.vendedores_nome.toString());
        this.text_nome = new Text(composite, 2048);
        this.text_nome.setLayoutData((Object)new GridData(450, -1));
        traverseSupport.add((Control)this.text_nome);
        this.label_estado = new Label(composite, 0);
        this.label_estado.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_estado.setText(LABELS.vendedores_estado.toString());
        this.combo_estado = new Combo(composite, 8);
        this.combo_estado.setVisibleItemCount(20);
        this.combo_estado.setItems(FIELDS.vendedores_estado.values);
        this.comboviewer_estado = new CustomComboViewer(this.combo_estado);
        traverseSupport.add((Control)this.combo_estado);
        this.label_comissao = new Label(composite, 0);
        this.label_comissao.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_comissao.setText(LABELS.vendedores_comissao.toString());
        this.text_comissao = new Text(composite, 133120);
        this.text_comissao.setLayoutData((Object)new GridData(75, -1));
        this.format_comissao = FormatFactory.getFormattedText(FIELDS.vendedores_comissao, this.text_comissao);
        traverseSupport.add((Control)this.text_comissao);
    }

    private void registerBindings() {
        this.bindingSupport.register(FIELDS.vendedores_codigo.name, new ValueBindingDefinition((IObservableValue)SWTObservables.observeText((Control)this.text_codigo, (int)24), BeansObservables.observeValue((Object)this.getVendedor(), (String)FIELDS.vendedores_codigo.name)));
        this.bindingSupport.register(FIELDS.vendedores_nome.name, new ValueBindingDefinition((IObservableValue)SWTObservables.observeText((Control)this.text_nome, (int)24), BeansObservables.observeValue((Object)this.getVendedor(), (String)FIELDS.vendedores_nome.name)));
        this.bindingSupport.register(FIELDS.vendedores_estado.name, new ValueBindingDefinition((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.comboviewer_estado), BeansObservables.observeValue((Object)this.getVendedor(), (String)FIELDS.vendedores_estado.name), (IConverter)new ComboToInteger(FIELDS.vendedores_estado.values), (IConverter)new IntegerToCombo(FIELDS.vendedores_estado.values)));
        this.bindingSupport.register(FIELDS.vendedores_comissao.name, new ValueBindingDefinition((IObservableValue)SWTObservables.observeText((Control)this.text_comissao, (int)24), BeansObservables.observeValue((Object)this.getVendedor(), (String)FIELDS.vendedores_comissao.name), (IConverter)new StringToBigDecimalFormatted(this.format_comissao), (IConverter)new BigDecimalToStringFormatted(this.format_comissao)));
    }

    private void registerValidator() {
        VendedoresShellValidator validator = new VendedoresShellValidator(this);
        validator.register(FIELDS.vendedores_codigo, (Control)this.label_codigo, (Control)this.text_codigo, 26);
        validator.register(FIELDS.vendedores_nome, (Control)this.label_nome, (Control)this.text_nome, 8);
        validator.register(FIELDS.vendedores_estado, (Control)this.label_estado, (Control)this.combo_estado, 4);
        validator.register(FIELDS.vendedores_comissao, (Control)this.label_comissao, this.format_comissao, 8);
        this.register(this.getText(), (IValidator)validator);
    }
}

