/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.empresa.armazens.shell;

import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.empresa.armazens.shell.ArmazensShell;
import org.projectocolibri.rcp.colibri.workbench.support.validators.FieldValidator;

public class ArmazensShellValidator
extends FieldValidator {
    private final ArmazensShell shell;

    public ArmazensShellValidator(ArmazensShell shell) {
        this.shell = shell;
    }

    public boolean isEdited() {
        return this.shell.getArmazem().isEdited();
    }

    public void validateInput() {
        if (!this.isEdited() && ColibriDatabase.getManager().existsArmazens(this.shell.getArmazem().getCodigo())) {
            this.getProperty(FIELDS.armazens_codigo.name).setError(LABELS.erro_campo_existe.toString());
        }
        if (!this.shell.getArmazem().isCodigopostalValid()) {
            this.getProperty(FIELDS.armazens_codigopostal.name).setError(LABELS.erro_campo_invalido.toString());
        }
    }

    public void validateButtons() {
        this.shell.getActions().validate();
    }
}

