/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.configuracao.utilizadores.shell.tabs.logs;

import org.dma.eclipse.jface.dialogs.message.QuestionDialog;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.java.util.Debug;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.model.Utilizadoreslogs;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.configuracao.utilizadores.shell.UtilizadoresShell;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.configuracao.utilizadores.shell.tabs.logs.UtilizadoresTab3Container;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.configuracao.utilizadores.shell.tabs.logs.UtilizadoresTab3LabelProvider;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.configuracao.utilizadores.shell.tabs.logs.UtilizadoresTab3Validator;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.tables.viewer.SWTTableLayout;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriTabItem;

public class UtilizadoresTab3
extends ColibriTabItem {
    private UtilizadoresTab3Container tableContainer;
    private final UtilizadoresShell shell;
    final CommandAction removerLinhaAction = new CommandAction(TABLES.utilizadoreslogs, Utilizadores.COMMANDS.RemoverLinha){

        public void run() {
            Utilizadoreslogs log = (Utilizadoreslogs)UtilizadoresTab3.this.tableContainer.getSelectionElement();
            ColibriDatabase.getManager().deleteUtilizadoreslogs(log.getUser().getKey(), log.getData());
            UtilizadoresTab3.this.tableContainer.updateTable();
        }

        @Override
        public boolean canRun() {
            return QuestionDialog.open((String)LABELS.pergunta_registo_remover.toString());
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };
    final CommandAction actualizarRegistoAction = new CommandAction(TABLES.utilizadoreslogs, Utilizadores.COMMANDS.ActualizarRegisto){

        public void run() {
            UtilizadoresTab3.this.tableContainer.updateTable();
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };
    final CommandAction exportarRegistoAction = new CommandAction(TABLES.utilizadoreslogs, Utilizadores.COMMANDS.ExportarRegisto){

        public void run() {
            UtilizadoresTab3.this.tableContainer.removeSelection();
            UtilizadoresTab3.this.tableContainer.exportTable();
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };

    public UtilizadoresTab3Container getTableContainer() {
        return this.tableContainer;
    }

    public UtilizadoresShell getShell() {
        return this.shell;
    }

    public UtilizadoresTab3(UtilizadoresShell shell) {
        super(shell.getTabFolder());
        this.shell = shell;
        this.getActions().addToolItem(this.removerLinhaAction).addToolItem(this.actualizarRegistoAction).addToolItem(this.exportarRegistoAction);
        if (!ColibriDatabase.getManager().getUtilizador().isColibri()) {
            this.getActions().remove(this.removerLinhaAction);
        }
        this.setText(LABELS.utilizadores_tab_logs.toString());
        this.setControl((Control)this.createContents());
        this.registerCombos();
        this.registerBindings();
        this.registerValidator();
        this.reset();
    }

    @Override
    public void dispose() {
        Debug.err((String)"dispose");
        this.unregisterValidator();
        this.unregisterBindings();
        this.unregisterCombos();
        this.tableContainer.dispose();
    }

    @Override
    public void setFocus() {
        this.tableContainer.setFocus();
    }

    @Override
    public void reset() {
        this.tableContainer.resetTable();
    }

    private Composite createContents() {
        Composite composite = new Composite((Composite)this.getParent(), 0);
        composite.setLayout((Layout)LayoutFactory.gridLayout());
        this.createToolBar(composite);
        this.createTableContainer(composite);
        return composite;
    }

    private void createTableContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 0;
        composite.setLayoutData((Object)gridData);
        Table table = new Table(composite, 67588);
        SWTTableLayout tableLayout = new SWTTableLayout(table, TABLES.utilizadoreslogs, ColibriDatabase.getManager().getCampos());
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setLabelProvider((IBaseLabelProvider)new UtilizadoresTab3LabelProvider(tableLayout));
        this.tableContainer = new UtilizadoresTab3Container(tableViewer, tableLayout, this);
    }

    private void registerCombos() {
    }

    private void unregisterCombos() {
    }

    @Override
    public void registerBindings() {
    }

    @Override
    public void unregisterBindings() {
    }

    @Override
    public void registerValidator() {
        UtilizadoresTab3Validator validator = new UtilizadoresTab3Validator(this);
        this.shell.register(this.getText(), (IValidator)validator);
    }

    @Override
    public void unregisterValidator() {
    }
}

