/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.configuracao.layouts;

import java.util.Collection;
import org.dma.java.util.MessageList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Layouts;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.configuracao.layouts.shell.LayoutsShell;
import org.projectocolibri.rcp.colibri.workbench.support.tables.viewer.SWTTableLayout;
import org.projectocolibri.rcp.colibri.workbench.support.tables.viewer.TableSearchContainer;

public class LayoutsContainer
extends TableSearchContainer<Layouts> {
    private Layouts layout;
    private final Shell parent;

    public Layouts getLayout() {
        return this.layout;
    }

    public LayoutsContainer(TableViewer viewer, SWTTableLayout tableLayout, Shell parent) {
        super(viewer, tableLayout);
        this.parent = parent;
    }

    public Layouts getNewObject() {
        return new Layouts(ColibriDatabase.getManager(), "");
    }

    public MessageList insertObject() {
        return this.updateTable(ColibriDatabase.getManager().storeLayouts(this.layout));
    }

    public MessageList removeObject() {
        return this.updateTable(ColibriDatabase.getManager().deleteLayouts(((Layouts)this.getSelectionElement()).getCodigo()));
    }

    public void createObject() {
        this.layout = this.getNewObject();
        new LayoutsShell(this.parent, this).open();
    }

    public void copyObject() {
        this.layout = ColibriDatabase.getManager().loadLayouts(((Layouts)this.getSelectionElement()).getCodigo()).cloneCopy();
        new LayoutsShell(this.parent, this).open();
    }

    public void editObject() {
        if (ColibriDatabase.getManager().getUtilizador().hasPermission(TABLES.layouts, Utilizadores.COMMANDS.EditarRegisto)) {
            this.layout = ColibriDatabase.getManager().loadLayouts(((Layouts)this.getSelectionElement()).getCodigo());
            new LayoutsShell(this.parent, this).open();
        }
    }

    @Override
    public Collection<Layouts> retrieveObjects(QueryDefinition query) {
        return ColibriDatabase.getManager().getLayoutsCollection(query);
    }
}

