/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.bancos.contasbancarias.shell;

import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.bancos.contasbancarias.shell.ContasbancariasShell;
import org.projectocolibri.rcp.colibri.workbench.support.validators.FieldValidator;

public class ContasbancariasShellValidator
extends FieldValidator {
    private final ContasbancariasShell shell;

    public ContasbancariasShellValidator(ContasbancariasShell shell) {
        this.shell = shell;
    }

    public boolean isEdited() {
        return this.shell.getContabancaria().isEdited();
    }

    public void validateInput() {
        if (!this.isEdited() && ColibriDatabase.getManager().existsContasbancarias(this.shell.getContabancaria().getCodigo())) {
            this.getProperty(FIELDS.contasbancarias_codigo.name).setError(LABELS.erro_campo_existe.toString());
        }
        if (!this.shell.getContabancaria().isIbanValid()) {
            this.getProperty(FIELDS.contasbancarias_iban.name).setError(LABELS.erro_campo_invalido.toString());
        }
        if (!this.shell.getContabancaria().isCodigopostalValid()) {
            this.getProperty(FIELDS.contasbancarias_codigopostal.name).setError(LABELS.erro_campo_invalido.toString());
        }
    }

    public void validateButtons() {
        this.shell.getActions().validate();
    }
}

