/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.artigos.familias;

import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.jface.dialogs.message.QuestionDialog;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.java.util.MessageList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.artigos.familias.FamiliasContainer;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.artigos.familias.FamiliasLabelProvider;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.artigos.familias.FamiliasValidator;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.preferences.ColibriPreferencePage;
import org.projectocolibri.rcp.colibri.workbench.support.tables.viewer.SWTTableLayout;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriButton;

public class FamiliasPreference
extends ColibriPreferencePage {
    private Combo combo_pesquisar;
    private Text text_pesquisar;
    private final Integer tabela;
    private FamiliasContainer tableContainer;
    final CommandAction novoRegistoAction = new CommandAction(TABLES.familias, Utilizadores.COMMANDS.NovoRegisto){

        public void run() {
            FamiliasPreference.this.tableContainer.createObject();
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };
    final CommandAction anularRegistoAction = new CommandAction(TABLES.familias, Utilizadores.COMMANDS.AnularRegisto){

        public void run() {
            ErrorDialog.open((MessageList)FamiliasPreference.this.tableContainer.removeObject());
        }

        @Override
        public boolean canRun() {
            return QuestionDialog.open((String)LABELS.pergunta_registo_anular.toString());
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };
    final CommandAction duplicarRegistoAction = new CommandAction(TABLES.familias, Utilizadores.COMMANDS.DuplicarRegisto){

        public void run() {
            FamiliasPreference.this.tableContainer.copyObject();
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };
    final CommandAction pesquisarRegistoAction = new CommandAction(TABLES.familias, Utilizadores.COMMANDS.PesquisarRegisto){

        public void run() {
            FamiliasPreference.this.tableContainer.executeFastSearch();
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };
    final CommandAction actualizarRegistoAction = new CommandAction(TABLES.familias, Utilizadores.COMMANDS.ActualizarRegisto){

        public void run() {
            FamiliasPreference.this.tableContainer.resetTable();
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };

    public FamiliasPreference(Integer tabela) {
        super(LABELS.familias.toString());
        this.tabela = tabela;
        this.getActions().addToolItem(this.novoRegistoAction).addToolItem(this.anularRegistoAction).addToolItem(this.duplicarRegistoAction).add(this.pesquisarRegistoAction).add(this.actualizarRegistoAction);
    }

    public Control createContents(Composite parent) {
        this.createToolBar(parent);
        this.createTableContainer(parent);
        this.createLowerToolBar(parent);
        this.registerValidator();
        return null;
    }

    @Override
    public void setFocus() {
        super.setFocus();
        this.text_pesquisar.setFocus();
    }

    private void createTableContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 0;
        composite.setLayoutData((Object)gridData);
        Table table = new Table(composite, 67588);
        SWTTableLayout tableLayout = new SWTTableLayout(table, TABLES.familias, ColibriDatabase.getManager().getCampos());
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setLabelProvider((IBaseLabelProvider)new FamiliasLabelProvider(tableLayout));
        this.tableContainer = new FamiliasContainer(tableViewer, tableLayout, this.getShell(), this.tabela);
    }

    private void createLowerToolBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutFactory.rowHolder());
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.combo_pesquisar = new Combo(composite, 8);
        this.combo_pesquisar.setVisibleItemCount(20);
        this.text_pesquisar = new Text(composite, 2048);
        this.text_pesquisar.setLayoutData((Object)new RowData(150, -1));
        ColibriButton button_pesquisar = new ColibriButton(composite, this.pesquisarRegistoAction);
        new ColibriButton(composite, this.actualizarRegistoAction);
        this.tableContainer.atach(this.combo_pesquisar, this.text_pesquisar, (Button)button_pesquisar);
        this.tableContainer.reset(0);
    }

    private void registerValidator() {
        FamiliasValidator validator = new FamiliasValidator(this.tableContainer, this);
        this.register(TABLES.familias.name(), (IValidator)validator);
    }
}

