/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.artigos.familias;

import java.util.Collection;
import org.dma.java.util.MessageList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Familias;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.artigos.familias.shell.FamiliasShell;
import org.projectocolibri.rcp.colibri.workbench.support.tables.viewer.SWTTableLayout;
import org.projectocolibri.rcp.colibri.workbench.support.tables.viewer.TableSearchContainer;

public class FamiliasContainer
extends TableSearchContainer<Familias> {
    private Familias familia;
    private final Shell parent;
    private final Integer tabela;

    public Familias getFamilia() {
        return this.familia;
    }

    public FamiliasContainer(TableViewer viewer, SWTTableLayout tableLayout, Shell parent, Integer tabela) {
        super(viewer, tableLayout);
        this.parent = parent;
        this.tabela = tabela;
    }

    public Familias getNewObject() {
        return new Familias(ColibriDatabase.getManager(), this.tabela);
    }

    public MessageList insertObject() {
        return this.updateTable(ColibriDatabase.getManager().storeFamilias(this.familia));
    }

    public MessageList removeObject() {
        return this.updateTable(ColibriDatabase.getManager().deleteFamilias(((Familias)this.getSelectionElement()).getCodigo()));
    }

    public void createObject() {
        this.familia = this.getNewObject();
        new FamiliasShell(this.parent, this).open();
    }

    public void copyObject() {
        this.familia = ColibriDatabase.getManager().loadFamilias(((Familias)this.getSelectionElement()).getCodigo()).cloneCopy();
        new FamiliasShell(this.parent, this).open();
    }

    public void editObject() {
        if (ColibriDatabase.getManager().getUtilizador().hasPermission(TABLES.familias, Utilizadores.COMMANDS.EditarRegisto)) {
            this.familia = ColibriDatabase.getManager().loadFamilias(((Familias)this.getSelectionElement()).getCodigo());
            new FamiliasShell(this.parent, this).open();
        }
    }

    @Override
    public Collection<Familias> retrieveObjects(QueryDefinition query) {
        query.setRule(new FilterMapRule(new FIELDS[]{FIELDS.familias_tabela}).equal(this.tabela));
        return ColibriDatabase.getManager().getFamiliasCollection(query);
    }
}

