/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.preferences.processamentos.entidades;

import java.util.Date;
import org.dma.eclipse.core.bindings.BindingSupport;
import org.dma.eclipse.jface.dialogs.message.QuestionDialog;
import org.dma.eclipse.swt.input.support.TraverseSupport;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.widgets.CustomComboViewer;
import org.dma.java.util.TimeDateUtils;
import org.eclipse.nebula.widgets.formattedtext.FormattedText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.RCPcolibri;
import org.projectocolibri.rcp.colibri.workbench.preferences.processamentos.entidades.FacturacaoAutomaticaJob;
import org.projectocolibri.rcp.colibri.workbench.preferences.processamentos.entidades.FacturacaoAutomaticaValidator;
import org.projectocolibri.rcp.colibri.workbench.support.FormatFactory;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.combos.ComboManager;
import org.projectocolibri.rcp.colibri.workbench.support.preferences.ColibriPreferencePage;

public class FacturacaoAutomatica
extends ColibriPreferencePage {
    private Label label_tipodocumento;
    private Combo combo_tipodocumento;
    private CustomComboViewer<Documentostipos> comboViewer_tipodocumento;
    private Label label_datacriacao;
    private Text text_datacriacao;
    private FormattedText format_datacriacao;
    private final BindingSupport bindingSupport = new BindingSupport();
    private final Entidadestipos tipoentidade;
    private final TIPO_PROCESSAMENTO tipo;
    final CommandAction executarAction = new CommandAction(TABLES.empresa, Utilizadores.COMMANDS.Processamentos){

        public void run() {
            new FacturacaoAutomaticaJob().createEntidadesdocumentos(FacturacaoAutomatica.this.getTipodocumento(), FacturacaoAutomatica.this.getDatacriacao()).schedule();
        }

        @Override
        public boolean canRun() {
            return QuestionDialog.open((String)LABELS.pergunta_operacao_confirmar.toString());
        }

        @Override
        public boolean isValid() {
            return !FacturacaoAutomatica.this.hasError();
        }
    };

    public static LABELS getTitle(TIPO_PROCESSAMENTO tipo) {
        switch (tipo) {
            case FACTURACAO: {
                return LABELS.processamentos_entidades_facturacao;
            }
            case LIQUIDACAO: {
                return LABELS.processamentos_entidades_liquidacao;
            }
        }
        return null;
    }

    public Documentostipos getTipodocumento() {
        return (Documentostipos)this.comboViewer_tipodocumento.getSelectedElement();
    }

    public Date getDatacriacao() {
        return (Date)this.format_datacriacao.getValue();
    }

    public TIPO_PROCESSAMENTO getTipo() {
        return this.tipo;
    }

    public FacturacaoAutomatica(Entidadestipos tipoentidade, TIPO_PROCESSAMENTO tipo) {
        super(FacturacaoAutomatica.getTitle(tipo).toString());
        this.tipoentidade = tipoentidade;
        this.tipo = tipo;
        this.getActions().add(this.executarAction);
    }

    public Control createContents(Composite parent) {
        this.createComposite(parent);
        this.createExecuteButton(parent, Utilizadores.COMMANDS.Processamentos);
        this.registerCombos();
        this.registerBindings();
        this.registerValidator();
        return null;
    }

    @Override
    public void dispose() {
        this.unregisterCombos();
        super.dispose();
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutFactory.gridLayout(2));
        TraverseSupport traverseSupport = new TraverseSupport(RCPcolibri.PREFERENCES.TRAVERSE_KEYPAD_ENTER.value.getBoolean());
        this.label_tipodocumento = new Label(composite, 0);
        this.label_tipodocumento.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_tipodocumento.setText(LABELS.documentostipos_codigo.toString());
        this.combo_tipodocumento = new Combo(composite, 2048);
        this.combo_tipodocumento.setVisibleItemCount(20);
        this.comboViewer_tipodocumento = new CustomComboViewer(this.combo_tipodocumento);
        traverseSupport.add((Control)this.combo_tipodocumento);
        this.label_datacriacao = new Label(composite, 0);
        this.label_datacriacao.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_datacriacao.setText(LABELS.entidadesdocumentos_datacriacao.toString());
        this.text_datacriacao = new Text(composite, 2048);
        this.text_datacriacao.setLayoutData((Object)new GridData(150, -1));
        this.format_datacriacao = FormatFactory.getFormattedText(FIELDS.entidadesdocumentos_datacriacao, this.text_datacriacao);
        this.format_datacriacao.setValue((Object)TimeDateUtils.getCurrentDate());
        traverseSupport.add((Control)this.text_datacriacao);
        return composite;
    }

    private void registerCombos() {
        ComboManager.register(TABLES.documentostipos, this.tipoentidade.getCodigo(), this.comboViewer_tipodocumento);
    }

    public void unregisterCombos() {
        ComboManager.unregister(this.comboViewer_tipodocumento);
    }

    private void registerBindings() {
    }

    private void registerValidator() {
        FacturacaoAutomaticaValidator validator = new FacturacaoAutomaticaValidator(this);
        validator.register(FIELDS.documentostipos_codigo, (Control)this.label_tipodocumento, (Control)this.combo_tipodocumento, 4);
        validator.register(FIELDS.entidadesdocumentos_datacriacao, (Control)this.label_datacriacao, this.format_datacriacao, 8);
        this.register(this.getTitle(), (IValidator)validator);
    }

    public static enum TIPO_PROCESSAMENTO {
        FACTURACAO,
        LIQUIDACAO;

    }
}

