/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench;

import org.dma.eclipse.core.jobs.CustomJob;
import org.dma.eclipse.jface.dialogs.message.CustomMessageDialog;
import org.dma.eclipse.jface.dialogs.message.InformationDialog;
import org.dma.eclipse.jface.dialogs.message.QuestionDialog;
import org.dma.eclipse.swt.widgets.CustomImageDescriptor;
import org.dma.eclipse.ui.MessageConsoleView;
import org.dma.eclipse.ui.UIHelper;
import org.dma.eclipse.ui.internal.UIHelper2;
import org.dma.java.util.Debug;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.contexts.IContextService;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.ColibriPerspective;
import org.projectocolibri.rcp.colibri.workbench.ColibriPerspectiveMap;
import org.projectocolibri.rcp.colibri.workbench.IColibriPerspective;
import org.projectocolibri.rcp.colibri.workbench.support.bars.coolbar.ColibriCoolBar;
import org.projectocolibri.rcp.colibri.workbench.support.bars.coolbar.IColibriCoolBar;
import org.projectocolibri.rcp.colibri.workbench.support.bars.menubar.ColibriMenuBar;
import org.projectocolibri.rcp.colibri.workbench.support.bars.menubar.IColibriMenuBar;
import org.projectocolibri.rcp.colibri.workbench.support.bars.statusbar.ColibriStatusBar;
import org.projectocolibri.rcp.colibri.workbench.support.bars.statusbar.IColibriStatusBar;
import org.projectocolibri.rcp.colibri.workbench.support.views.IColibriMenuTree;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriTrayItem;

public class ColibriUI {
    public static final ImageDescriptor DEBUG_DESCRIPTOR = new CustomImageDescriptor(Colibri.ICONS.COOLBAR_DEBUG.getImage(16));
    public static final MessageConsoleView CONSOLE = new MessageConsoleView(LABELS.window_debug.toString(), DEBUG_DESCRIPTOR);
    private static IColibriMenuTree menuTree;
    private static IColibriMenuBar menuBar;
    private static IColibriCoolBar coolBar;
    private static IColibriStatusBar statusBar;
    private static ColibriTrayItem trayItem;
    private static boolean dirty;
    private static final ColibriPerspectiveMap perspectiveMap;
    private static boolean started;

    static {
        dirty = true;
        perspectiveMap = new ColibriPerspectiveMap();
        started = false;
    }

    public static IColibriMenuTree getMenuTree() {
        return menuTree;
    }

    public static void setMenuTree(IColibriMenuTree menuTree) {
        ColibriUI.menuTree = menuTree;
    }

    public static IColibriMenuBar getMenuBar() {
        return menuBar;
    }

    public static void setMenuBar(IColibriMenuBar menuBar) {
        ColibriUI.menuBar = menuBar;
    }

    public static void initMenuBar(IActionBarConfigurer configurer) {
        ColibriUI.setMenuBar(new ColibriMenuBar(configurer));
    }

    public static IColibriCoolBar getCoolBar() {
        return coolBar;
    }

    public static void setCoolBar(IColibriCoolBar coolBar) {
        ColibriUI.coolBar = coolBar;
    }

    public static void initCoolBar(IActionBarConfigurer configurer) {
        ColibriUI.setCoolBar(new ColibriCoolBar(configurer));
    }

    public static IColibriStatusBar getStatusBar() {
        return statusBar;
    }

    public static void setStatusBar(IColibriStatusBar statusBar) {
        ColibriUI.statusBar = statusBar;
    }

    public static void initStatusBar(IStatusLineManager statusLine) {
        ColibriUI.setStatusBar(new ColibriStatusBar(UIHelper.getDisplay(), statusLine));
    }

    public static void postError(String message) {
        if (statusBar != null) {
            statusBar.postError(message);
        }
    }

    public static void postMessage(String message) {
        if (statusBar != null) {
            statusBar.postMessage(message);
        }
    }

    public static void clearMessage() {
        if (statusBar == null) {
            return;
        }
        if (Colibri.isDirty()) {
            statusBar.setDefaultMessage(LABELS.info_aplicacao_reiniciar.toString());
        }
        statusBar.clearMessage();
    }

    public static ColibriTrayItem getTrayItem() {
        return trayItem;
    }

    public static void showTip(String text, String message) {
        if (trayItem != null) {
            trayItem.showTip(text, message);
        }
    }

    public static void showTip(String message) {
        ColibriUI.showTip(CustomMessageDialog.DIALOG_TYPES.INFORMATION.title(), message);
    }

    public static void markDirty() {
        dirty = true;
    }

    public static void update() {
        ColibriUI.update(dirty);
    }

    public static void update(boolean force) {
        if (menuTree != null) {
            if (force) {
                menuTree.build();
            }
            if (coolBar != null) {
                coolBar.build(perspectiveMap.get(ColibriPerspective.ID));
            }
        }
        ColibriUI.showBarsFrom(perspectiveMap.getPerspectiveId());
        dirty = false;
    }

    public static void showBarsFrom(String perspectiveId) {
        IColibriPerspective perspective = perspectiveMap.get(perspectiveId);
        if (menuBar != null) {
            menuBar.show(perspective);
        }
        if (coolBar != null) {
            coolBar.show(perspective);
        }
    }

    public static void saveBarsTo(String perspectiveId) {
        IColibriPerspective perspective = perspectiveMap.get(perspectiveId);
        if (menuBar != null) {
            menuBar.save(perspective);
        }
        if (coolBar != null) {
            coolBar.save(perspective);
        }
    }

    public static void closePerspective(String perspectiveId) {
        perspectiveMap.closePerspective(perspectiveId);
        if (perspectiveId.equals(ColibriPerspective.ID)) {
            ColibriUI.markDirty();
        }
    }

    public static void setPerspective(String perspectiveId) {
        ColibriUI.saveBarsTo(perspectiveMap.getPerspectiveId());
        perspectiveMap.setPerspective(perspectiveId);
        ColibriUI.update();
    }

    public static void resetPerspective() {
        ColibriUI.saveBarsTo(perspectiveMap.getPerspectiveId());
        perspectiveMap.resetPerspective();
        ColibriUI.update();
    }

    public static void refreshPerspective() {
        perspectiveMap.refreshPerspective();
    }

    public static void configure(WorkbenchAdvisor advisor) {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        store.setValue("showIntro", false);
        store.setValue("SHOW_PROGRESS_ON_STARTUP", true);
        store.setValue("defaultPerspectiveId", advisor.getInitialWindowPerspectiveId());
        store.setValue("DOCK_PERSPECTIVE_BAR", "topRight");
        store.setValue("SHOW_TEXT_ON_PERSPECTIVE_BAR", true);
        store.setValue("SHOW_OPEN_ON_PERSPECTIVE_BAR", true);
        store.setValue("SHOW_OTHER_IN_PERSPECTIVE_MENU", false);
        store.setValue("SHOW_TRADITIONAL_STYLE_TABS", false);
        store.setValue("ENABLE_ANIMATIONS", false);
        store.setValue("SHOW_SYSTEM_JOBS", false);
        store.setValue("CLOSE_EDITORS_ON_EXIT", true);
        store.setValue("SHOW_MEMORY_MONITOR", true);
        store.setValue("ENABLE_DETACHED_VIEWS", true);
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        contextService.activateContext("org.projectocolibri.rcp.keyboard.DefaultContext");
        contextService.activateContext("org.eclipse.ui.contexts.window");
    }

    public static void configure(IWorkbenchWindowConfigurer configurer, String title) {
        configurer.setShowMenuBar(true);
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowPerspectiveBar(true);
        configurer.setShowProgressIndicator(true);
        configurer.setTitle(title);
    }

    public static boolean start(boolean minimizeToTray, IColibriPerspective ... perspectives) {
        Debug.out();
        if (menuBar == null) {
            throw new RuntimeException("MenuBar not initialized (ApplicationActionBarAdvisor)");
        }
        if (coolBar == null) {
            throw new RuntimeException("CoolBar not initialized (ApplicationActionBarAdvisor)");
        }
        if (statusBar == null) {
            throw new RuntimeException("Statusbar not initialized (ApplicationActionBarAdvisor)");
        }
        if (!started && UIHelper.isWorkbenchWindowActive()) {
            try {
                trayItem = new ColibriTrayItem(Display.getDefault(), minimizeToTray);
                UIHelper2.disablePerspectiveToolBarMenu();
                perspectiveMap.put(perspectives);
                perspectiveMap.restorePerspectives();
                ColibriUI.update();
                ColibriUI.clearMessage();
                started = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return started;
    }

    public static boolean stop(boolean confirm) {
        Debug.out();
        if (started) {
            block5: {
                if (!confirm || QuestionDialog.open((String)LABELS.pergunta_operacao_confirmar.toString(), (String)LABELS.menuoption_ficheiro_sair.toString())) break block5;
                return false;
            }
            try {
                if (CustomJob.isIdle()) {
                    return perspectiveMap.closePerspectives();
                }
                return !InformationDialog.open((String)LABELS.info_aplicacao_ocupada.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void dispose() {
        Debug.out();
        if (started) {
            try {
                menuBar.dispose();
                coolBar.dispose();
                statusBar.dispose();
                trayItem.dispose();
                CONSOLE.restoreOutputStream();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

