/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.dma.eclipse.ui.UIHelper;
import org.dma.java.util.Debug;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.PlatformUI;
import org.projectocolibri.rcp.birt.workbench.BIRTPerspective;
import org.projectocolibri.rcp.colibri.workbench.ColibriPerspective;
import org.projectocolibri.rcp.colibri.workbench.IColibriPerspective;
import org.projectocolibri.rcp.colibri.workbench.support.listeners.WorkbenchListeners;
import org.projectocolibri.rcp.colibri.workbench.support.views.ColibriViewHelper;
import org.projectocolibri.rcp.pos.workbench.POSPerspective;

public class ColibriPerspectiveMap
extends LinkedHashMap<String, IColibriPerspective> {
    public static final String UNKNOWN_PERSPECTIVE = "#UNKNOWN";
    public static final Collection<String> UNWANTED_PERSPECTIVES = Arrays.asList("org.eclipse.birt.report.designer.ui.ReportPerspective", "org.eclipse.team.ui.TeamSynchronizingPerspective", "org.eclipse.debug.ui.DebugPerspective", "org.eclipse.pde.ui.PDEPerspective", "org.eclipse.jdt.ui.JavaPerspective", "org.eclipse.jdt.ui.JavaBrowsingPerspective", "org.eclipse.jdt.ui.JavaHierarchyPerspective");
    public static final IColibriPerspective[] FIXED_PERSPECTIVES = new IColibriPerspective[]{new ColibriPerspective(), new BIRTPerspective(), new POSPerspective()};
    private final WorkbenchListeners listeners = new WorkbenchListeners();
    private String perspectiveId = "#UNKNOWN";

    public static void removePerspectives(Collection<String> perspectives) {
        IPerspectiveRegistry perspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        if (perspectiveRegistry instanceof IExtensionChangeHandler) {
            try {
                ArrayList<IPerspectiveDescriptor> remove = new ArrayList<IPerspectiveDescriptor>();
                IPerspectiveDescriptor[] iPerspectiveDescriptorArray = perspectiveRegistry.getPerspectives();
                int n = iPerspectiveDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPerspectiveDescriptor perspectiveDescriptor = iPerspectiveDescriptorArray[n2];
                    if (perspectives.contains(perspectiveDescriptor.getId())) {
                        remove.add(perspectiveDescriptor);
                    }
                    ++n2;
                }
                if (!remove.isEmpty()) {
                    IExtensionChangeHandler handler = (IExtensionChangeHandler)perspectiveRegistry;
                    handler.removeExtension(null, remove.toArray());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getPerspectiveId() {
        return this.perspectiveId;
    }

    public ColibriPerspectiveMap() {
        this.put(FIXED_PERSPECTIVES);
        ColibriPerspectiveMap.removePerspectives(UNWANTED_PERSPECTIVES);
    }

    public IColibriPerspective get(String perspectiveId) {
        IColibriPerspective perspective = (IColibriPerspective)super.get(perspectiveId);
        if (perspective == null) {
            throw new UnsupportedOperationException(String.valueOf(perspectiveId) + " not registered in ApplicationWorkbenchAdvisor");
        }
        return perspective;
    }

    public void put(IColibriPerspective ... perspectives) {
        IColibriPerspective[] iColibriPerspectiveArray = perspectives;
        int n = perspectives.length;
        int n2 = 0;
        while (n2 < n) {
            IColibriPerspective perspective = iColibriPerspectiveArray[n2];
            this.put(perspective.getId(), perspective);
            ++n2;
        }
    }

    public boolean isPerspectiveRestorable(String perspectiveId) {
        IColibriPerspective perspective = this.get(perspectiveId);
        return perspective != null && perspective.saveOnClose();
    }

    public void restorePerspectives() {
        IPerspectiveDescriptor[] perspectives = UIHelper.getOpenPerspectives();
        this.listeners.addWorkbenchListeners();
        int i = perspectives.length - 1;
        while (i >= 0) {
            ColibriViewHelper.restoreViews(perspectives[i]);
            Debug.out((String)"RESTORED", (Object)perspectives[i].getId());
            --i;
        }
        this.listeners.addPerspectiveListener();
        this.perspectiveId = perspectives.length == 0 ? UNKNOWN_PERSPECTIVE : perspectives[0].getId();
        Debug.err((String)"perspectiveId", (Object)this.perspectiveId);
        if (this.perspectiveId.equals(ColibriPerspective.ID)) {
            ColibriViewHelper.showBaseView();
        }
    }

    public boolean closePerspectives() {
        this.listeners.removeWorkbenchListeners();
        boolean result = UIHelper.getActivePage().closeAllEditors(false);
        this.listeners.removePerspectiveListener();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = UIHelper.getOpenPerspectives();
        int n = iPerspectiveDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor perspective = iPerspectiveDescriptorArray[n2];
            ColibriViewHelper.hideViews(perspective);
            if (!this.isPerspectiveRestorable(perspective.getId())) {
                UIHelper.closePerspective((String)perspective.getId());
                Debug.out((String)"CLOSED", (Object)perspective.getId());
            }
            ++n2;
        }
        return result;
    }

    public void closePerspective(String perspectiveId) {
        this.perspectiveId = UIHelper.closePerspective((String)perspectiveId).getId();
        System.gc();
    }

    public void setPerspective(String perspectiveId) {
        this.listeners.removePerspectiveListener();
        UIHelper.setPerspective((String)perspectiveId);
        this.perspectiveId = perspectiveId;
        this.listeners.addPerspectiveListener();
    }

    public void resetPerspective() {
        this.listeners.removePerspectiveListener();
        UIHelper.resetPerspective();
        this.listeners.addPerspectiveListener();
    }

    public void refreshPerspective() {
        this.listeners.removePerspectiveListener();
        UIHelper.closePerspective((String)this.perspectiveId);
        UIHelper.setPerspective((String)this.perspectiveId);
        this.listeners.addPerspectiveListener();
    }
}

