/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IWorkbenchWindow;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.ColibriPageLayout;
import org.projectocolibri.rcp.colibri.workbench.ColibriUI;
import org.projectocolibri.rcp.colibri.workbench.IColibriPerspective;
import org.projectocolibri.rcp.colibri.workbench.actions.CleanPerspectiveAction;
import org.projectocolibri.rcp.colibri.workbench.actions.ClosePerspectiveAction;
import org.projectocolibri.rcp.colibri.workbench.actions.OpenComunicacaoViewAction;
import org.projectocolibri.rcp.colibri.workbench.actions.OpenDatabaseViewAction;
import org.projectocolibri.rcp.colibri.workbench.actions.OpenDebugViewAction;
import org.projectocolibri.rcp.colibri.workbench.actions.OpenHelpViewAction;
import org.projectocolibri.rcp.colibri.workbench.actions.OpenPagamentosViewAction;
import org.projectocolibri.rcp.colibri.workbench.actions.OpenParametrosPreferenceAction;
import org.projectocolibri.rcp.colibri.workbench.actions.OpenProcessamentosPreferenceAction;
import org.projectocolibri.rcp.colibri.workbench.actions.OpenTabelasPreferenceAction;
import org.projectocolibri.rcp.colibri.workbench.actions.RemoteAssistanceAction;
import org.projectocolibri.rcp.colibri.workbench.actions.RemoteUpdateAction;
import org.projectocolibri.rcp.colibri.workbench.actions.ResetPerspectiveAction;
import org.projectocolibri.rcp.colibri.workbench.support.bars.coolbar.ColibriCoolBarItem;
import org.projectocolibri.rcp.colibri.workbench.support.bars.menubar.ColibriMenuBarItem;
import org.projectocolibri.rcp.colibri.workbench.views.BaseView;
import org.projectocolibri.rcp.colibri.workbench.views.tree.TreeView;

public class ColibriPerspective
extends ColibriPageLayout
implements IColibriPerspective {
    public static final String ID = ColibriPerspective.class.getCanonicalName();

    public ColibriPerspective() {
        super(ID);
    }

    @Override
    public void createInitialLayout(IPageLayout layout) {
        layout.setFixed(false);
        layout.setEditorAreaVisible(false);
        layout.addStandaloneView(TreeView.ID, true, 1, 0.25f, layout.getEditorArea());
        layout.getViewLayout(TreeView.ID).setCloseable(false);
        layout.addView(BaseView.ID, 2, 0.75f, layout.getEditorArea());
        layout.getViewLayout(BaseView.ID).setCloseable(false);
        super.createInitialLayout(layout);
    }

    private Collection<IAction> createFileActions(IWorkbenchWindow window) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        actions.add((IAction)new OpenTabelasPreferenceAction(window));
        actions.add((IAction)new OpenParametrosPreferenceAction(window));
        actions.add((IAction)new OpenProcessamentosPreferenceAction(window));
        return actions;
    }

    private Collection<IAction> createServiceActions(IWorkbenchWindow window) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL) {
            actions.add((IAction)new OpenPagamentosViewAction());
        }
        if (Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL) {
            actions.add((IAction)new OpenComunicacaoViewAction());
        }
        return actions;
    }

    private Collection<IAction> createWorkspaceActions(IWorkbenchWindow window) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        actions.add((IAction)new CleanPerspectiveAction());
        actions.add((IAction)new ResetPerspectiveAction());
        return actions;
    }

    private Collection<IAction> createHelpActions(IWorkbenchWindow window) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        actions.add((IAction)new OpenHelpViewAction());
        if (Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL) {
            actions.add((IAction)new RemoteAssistanceAction());
        }
        if (Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL) {
            actions.add((IAction)new RemoteUpdateAction());
        }
        return actions;
    }

    private Collection<IAction> createSupportActions(IWorkbenchWindow window) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        actions.add((IAction)new OpenDebugViewAction());
        actions.add((IAction)new OpenDatabaseViewAction());
        return actions;
    }

    @Override
    public Collection<ColibriMenuBarItem> createMenuBar(IWorkbenchWindow window) {
        ArrayList<ColibriMenuBarItem> items = new ArrayList<ColibriMenuBarItem>();
        ArrayList<IAction> actions = new ArrayList<IAction>(this.createFileActions(window));
        actions.add((IAction)new ClosePerspectiveAction(ID));
        items.add(new ColibriMenuBarItem(LABELS.menubar_ficheiro.toString(), actions));
        items.add(new ColibriMenuBarItem(LABELS.menubar_servicos.toString(), this.createServiceActions(window)));
        items.add(new ColibriMenuBarItem(LABELS.menubar_workspace.toString(), this.createWorkspaceActions(window)));
        items.add(new ColibriMenuBarItem(LABELS.menubar_ajuda.toString(), this.createHelpActions(window)));
        items.add(new ColibriMenuBarItem(LABELS.menubar_suporte.toString(), this.createSupportActions(window)));
        return items;
    }

    @Override
    public Collection<ColibriCoolBarItem> createCoolBar(IWorkbenchWindow window) {
        ArrayList<ColibriCoolBarItem> items = new ArrayList<ColibriCoolBarItem>();
        ArrayList<IAction> actions = new ArrayList<IAction>();
        actions.addAll(this.createFileActions(window));
        actions.addAll(this.createServiceActions(window));
        actions.add((IAction)new ClosePerspectiveAction(ID));
        items.add(new ColibriCoolBarItem(ID, actions));
        items.addAll(ColibriUI.getMenuTree().getCoolBarMap().getItems());
        return items;
    }

    @Override
    public boolean saveOnClose() {
        return true;
    }

    @Override
    public String getId() {
        return ID;
    }
}

