/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.birt.workbench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IWorkbenchWindow;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.birt.workbench.actions.EditCopyAction;
import org.projectocolibri.rcp.birt.workbench.actions.EditCutAction;
import org.projectocolibri.rcp.birt.workbench.actions.EditDeleteAction;
import org.projectocolibri.rcp.birt.workbench.actions.EditPasteAction;
import org.projectocolibri.rcp.birt.workbench.actions.EditRedoAction;
import org.projectocolibri.rcp.birt.workbench.actions.EditUndoAction;
import org.projectocolibri.rcp.birt.workbench.actions.SaveFileAction;
import org.projectocolibri.rcp.colibri.workbench.ColibriPageLayout;
import org.projectocolibri.rcp.colibri.workbench.IColibriPerspective;
import org.projectocolibri.rcp.colibri.workbench.actions.ClosePerspectiveAction;
import org.projectocolibri.rcp.colibri.workbench.actions.OpenTabelasPreferenceAction;
import org.projectocolibri.rcp.colibri.workbench.support.bars.coolbar.ColibriCoolBarItem;
import org.projectocolibri.rcp.colibri.workbench.support.bars.menubar.ColibriMenuBarItem;
import org.projectocolibri.rcp.colibri.workbench.views.BaseView;
import org.projectocolibri.xml.beans.licencas.LICENCAS;

public class BIRTPerspective
extends ColibriPageLayout
implements IColibriPerspective {
    public static final String ID = BIRTPerspective.class.getCanonicalName();

    public BIRTPerspective() {
        super(ID);
    }

    @Override
    public void createInitialLayout(IPageLayout layout) {
        if (!ColibriDatabase.getManager().getLicenca().hasModulo(new LICENCAS.MODULOS[]{LICENCAS.MODULOS.BIRT})) {
            layout.setFixed(true);
            layout.setEditorAreaVisible(false);
            layout.addStandaloneView(BaseView.ID, true, 2, 0.75f, layout.getEditorArea());
        } else {
            IFolderLayout folder = layout.createFolder("left", 1, 0.26f, layout.getEditorArea());
            folder.addView("org.eclipse.gef.ui.palette_view");
            layout.getViewLayout("org.eclipse.gef.ui.palette_view").setCloseable(false);
            folder.addView("org.eclipse.ui.views.ContentOutline");
            layout.getViewLayout("org.eclipse.ui.views.ContentOutline").setCloseable(false);
            folder = layout.createFolder("bottom", 4, 0.66f, layout.getEditorArea());
            folder.addView("org.eclipse.birt.report.designer.ui.attributes.AttributeView");
            layout.getViewLayout("org.eclipse.birt.report.designer.ui.attributes.AttributeView").setCloseable(false);
        }
        super.createInitialLayout(layout);
    }

    private Collection<IAction> createFileActions(IWorkbenchWindow window) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        actions.add((IAction)new OpenTabelasPreferenceAction(window));
        actions.add((IAction)new ClosePerspectiveAction(ID));
        return actions;
    }

    @Override
    public Collection<ColibriMenuBarItem> createMenuBar(IWorkbenchWindow window) {
        return Arrays.asList(new ColibriMenuBarItem(LABELS.menubar_ficheiro.toString(), this.createFileActions(window)));
    }

    @Override
    public Collection<ColibriCoolBarItem> createCoolBar(IWorkbenchWindow window) {
        return Arrays.asList(new ColibriCoolBarItem(LABELS.menubar_ficheiro.toString(), this.createFileActions(window)), new ColibriCoolBarItem(ID, new IAction[]{new SaveFileAction(window), new EditUndoAction(window), new EditRedoAction(window), new EditCutAction(window), new EditCopyAction(window), new EditPasteAction(window), new EditDeleteAction(window)}));
    }

    @Override
    public boolean saveOnClose() {
        return false;
    }

    @Override
    public String getId() {
        return ID;
    }
}

