/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class DataSetCacheObjectWithDummyData
implements IDataSetCacheObject {
    private IResultClass resultClass;
    private IDataSetCacheObject base;

    public DataSetCacheObjectWithDummyData(IBaseDataSetDesign dataSetDesign, IDataSetCacheObject base) throws DataException {
        this.base = base;
        this.resultClass = this.populateResultClass(dataSetDesign, base.getResultClass());
    }

    public boolean isCachedDataReusable(int requiredCapability) {
        return this.base.isCachedDataReusable(requiredCapability);
    }

    public boolean needUpdateCache(int requiredCapability) {
        return this.base.needUpdateCache(requiredCapability);
    }

    public IResultClass getResultClass() throws DataException {
        return this.resultClass;
    }

    public void release() {
        this.base.release();
    }

    public IDataSetCacheObject getSourceDataSetCacheObject() {
        return this.base;
    }

    private IResultClass populateResultClass(IBaseDataSetDesign dataSetDesign, IResultClass baseResultClass) throws DataException {
        ResultFieldMetadata columnMetaData;
        List resultHints = dataSetDesign.getResultSetHints();
        List computedColumns = dataSetDesign.getComputedColumns();
        ArrayList<ResultFieldMetadata> columnsList = new ArrayList<ResultFieldMetadata>();
        int i = 1;
        while (i <= baseResultClass.getFieldCount()) {
            columnsList.add(baseResultClass.getFieldMetaData(i));
            ++i;
        }
        Iterator it = resultHints.iterator();
        int j = 0;
        while (it.hasNext()) {
            IColumnDefinition columnDefn = (IColumnDefinition)it.next();
            if (baseResultClass.getFieldIndex(columnDefn.getColumnName()) == -1) {
                columnMetaData = new ResultFieldMetadata(j + 1, columnDefn.getColumnName(), columnDefn.getDisplayName(), DataType.getClass((int)columnDefn.getDataType()), null, true, columnDefn.getAnalysisType(), columnDefn.getAnalysisColumn(), columnDefn.isIndexColumn(), columnDefn.isCompressedColumn());
                columnsList.add(columnMetaData);
                columnMetaData.setAlias(columnDefn.getAlias());
            }
            ++j;
        }
        int count = columnsList.size();
        it = computedColumns.iterator();
        resultHints.size();
        while (it.hasNext()) {
            IComputedColumn compColumn = (IComputedColumn)it.next();
            if (baseResultClass.getFieldIndex(compColumn.getName()) != -1) continue;
            columnMetaData = new ResultFieldMetadata(++count, compColumn.getName(), compColumn.getName(), DataType.getClass((int)compColumn.getDataType()), null, true, -1);
            columnsList.add(columnMetaData);
        }
        return new ResultClass(columnsList);
    }
}

