/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.datechooser;

import java.util.Date;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.nebula.widgets.datechooser.DateChooserCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DateChooserComboObservableValue
extends AbstractObservableValue {
    protected final DateChooserCombo combo;
    private final int updateEventType;
    private boolean updating = false;
    private Date oldValue;
    private Listener updateListener = new Listener(){

        public void handleEvent(Event event) {
            Date newValue;
            if (!DateChooserComboObservableValue.this.updating && ((newValue = DateChooserComboObservableValue.this.combo.getValue()) == null && DateChooserComboObservableValue.this.oldValue != null || newValue != null && !newValue.equals(DateChooserComboObservableValue.this.oldValue))) {
                DateChooserComboObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)DateChooserComboObservableValue.this.oldValue, (Object)newValue));
                DateChooserComboObservableValue.this.oldValue = newValue;
            }
        }
    };
    private static final int[] validUpdateEventTypes;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            DateChooserComboObservableValue.this.dispose();
        }
    };

    static {
        int[] nArray = new int[3];
        nArray[0] = 24;
        nArray[1] = 16;
        validUpdateEventTypes = nArray;
    }

    public DateChooserComboObservableValue(DateChooserCombo combo, int updateEventType) {
        this(SWTObservables.getRealm((Display)combo.getDisplay()), combo, updateEventType);
    }

    public DateChooserComboObservableValue(Realm realm, DateChooserCombo combo, int updateEventType) {
        super(realm);
        boolean eventValid = false;
        int i = 0;
        while (!eventValid && i < validUpdateEventTypes.length) {
            eventValid = updateEventType == validUpdateEventTypes[i];
            ++i;
        }
        if (!eventValid) {
            throw new IllegalArgumentException("UpdateEventType [" + updateEventType + "] is not supported.");
        }
        this.combo = combo;
        this.updateEventType = updateEventType;
        if (updateEventType != 0) {
            combo.addListener(updateEventType, this.updateListener);
        }
        combo.addDisposeListener(this.disposeListener);
    }

    public void dispose() {
        if (!this.combo.isDisposed() && this.updateEventType != 0) {
            this.combo.removeListener(this.updateEventType, this.updateListener);
        }
        super.dispose();
    }

    protected Object doGetValue() {
        this.oldValue = this.combo.getValue();
        return this.oldValue;
    }

    protected void doSetValue(Object value) {
        try {
            this.updating = true;
            this.combo.setValue((Date)value);
            this.oldValue = this.combo.getValue();
        }
        finally {
            this.updating = false;
        }
    }

    public Object getValueType() {
        return Date.class;
    }
}

