/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerTreeViewPage;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.ResourceAction;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.ui.actions.ActionFactory;

public class RenameResourceAction
extends ResourceAction {
    public RenameResourceAction(LibraryExplorerTreeViewPage page) {
        super(Messages.getString((String)"RenameLibraryAction.Text"), page);
        this.setId(ActionFactory.RENAME.getId());
    }

    public boolean isEnabled() {
        return this.canModifySelectedResources();
    }

    public void run() {
        Collection<File> files = null;
        try {
            files = this.getSelectedFiles();
        }
        catch (IOException e) {
            ExceptionUtil.handle((Throwable)e);
            return;
        }
        if (files == null || files.size() != 1) {
            return;
        }
        File file = files.iterator().next();
        String newName = this.queryNewResourceName(file);
        if (newName == null || newName.length() <= 0) {
            return;
        }
        File newFile = new Path(file.getAbsolutePath()).removeLastSegments(1).append(newName).toFile();
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, this.createRenameFileRunnable(file, newFile));
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        catch (InterruptedException e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    protected String queryNewResourceName(final File resource) {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IPath prefix = new Path(resource.getAbsolutePath()).removeLastSegments(1);
        IInputValidator validator = new IInputValidator(){

            public String isValid(String string) {
                if (new Path(resource.getName()).removeFileExtension().toFile().getName().equals(string)) {
                    return Messages.getString((String)"RenameResourceAction.nameExists");
                }
                Path newPath = new Path(string);
                IStatus status = workspace.validateName(newPath.toFile().getName(), resource.isFile() ? 1 : 2);
                if (!status.isOK()) {
                    return status.getMessage();
                }
                IPath fullPath = prefix.append(string);
                if (fullPath.toFile().exists()) {
                    return Messages.getString((String)"RenameResourceAction.nameExists");
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.getShell(), Messages.getString((String)"RenameResourceAction.inputDialogTitle"), Messages.getString((String)"RenameResourceAction.inputDialogMessage"), new Path(resource.getName()).toFile().getName(), validator);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            Path newPath = new Path(dialog.getValue());
            return newPath.toFile().getName();
        }
        return null;
    }
}

