/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.simpleapi.IDataSet;
import org.eclipse.birt.report.model.api.simpleapi.IDataSource;
import org.eclipse.birt.report.model.simpleapi.DataSource;
import org.eclipse.birt.report.model.simpleapi.ResultSetColumnImpl;

public class DataSet
implements IDataSet {
    private DataSetHandle dataSet;

    public DataSet(DataSetHandle dataSet) {
        this.dataSet = dataSet;
    }

    public IDataSource getDataSource() {
        if (!(this.dataSet instanceof OdaDataSetHandle)) {
            return null;
        }
        DataSourceHandle dataSource = this.dataSet.getDataSource();
        if (dataSource == null) {
            return null;
        }
        return new DataSource(dataSource);
    }

    public String getQueryText() {
        if (this.dataSet instanceof OdaDataSetHandle) {
            return ((OdaDataSetHandle)this.dataSet).getQueryText();
        }
        return null;
    }

    public void setQueryText(String query) throws SemanticException {
        if (this.dataSet instanceof OdaDataSetHandle) {
            ActivityStack cmdStack = this.dataSet.getModule().getActivityStack();
            cmdStack.startNonUndoableTrans(null);
            try {
                ((OdaDataSetHandle)this.dataSet).setQueryText(query);
            }
            catch (SemanticException e) {
                cmdStack.rollback();
                throw e;
            }
            cmdStack.commit();
        }
    }

    public String getPrivateDriverProperty(String name) {
        if (this.dataSet instanceof OdaDataSetHandle) {
            return ((OdaDataSetHandle)this.dataSet).getPrivateDriverProperty(name);
        }
        return null;
    }

    public void setPrivateDriverProperty(String name, String value) throws SemanticException {
        if (this.dataSet instanceof OdaDataSetHandle) {
            ActivityStack cmdStack = this.dataSet.getModule().getActivityStack();
            cmdStack.startNonUndoableTrans(null);
            try {
                ((OdaDataSetHandle)this.dataSet).setPrivateDriverProperty(name, value);
            }
            catch (SemanticException e) {
                cmdStack.rollback();
                throw e;
            }
            cmdStack.commit();
        }
    }

    public List getCachedResultSetColumns() {
        ArrayList<ResultSetColumnImpl> values = new ArrayList<ResultSetColumnImpl>();
        CachedMetaDataHandle metaDataHandle = this.dataSet.getCachedMetaDataHandle();
        if (metaDataHandle == null) {
            return values;
        }
        MemberHandle memberHandle = metaDataHandle.getResultSet();
        if (memberHandle == null) {
            return values;
        }
        Iterator iterator = memberHandle.iterator();
        while (iterator.hasNext()) {
            ResultSetColumnHandle columnHandle = (ResultSetColumnHandle)iterator.next();
            ResultSetColumnImpl column = new ResultSetColumnImpl(columnHandle);
            values.add(column);
        }
        return Collections.unmodifiableList(values);
    }
}

